/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util.mcmmo;

import java.util.Arrays;
import org.bukkit.ChatColor;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.util.mcmmo.MobHealthDisplayUpdaterTask;

public final class MobHealthbarUtils {
    private MobHealthbarUtils() {
    }

    public static String fixDeathMessage(String string, Player player) {
        EntityDamageEvent entityDamageEvent = player.getLastDamageCause();
        String string2 = entityDamageEvent instanceof EntityDamageByEntityEvent ? MobHealthbarUtils.getPrettyEntityTypeString(((EntityDamageByEntityEvent)entityDamageEvent).getDamager().getType()) : "a mob";
        return string.replaceAll("(?:\u00a7(?:[0-9A-FK-ORa-fk-or]){1}(?:[\u2764\u25a0]{1,10})){1,2}", string2);
    }

    public static void handleMobHealthbars(Player player, LivingEntity livingEntity, double d) {
        McRPGPlayer mcRPGPlayer;
        if (McRPG.getInstance().isHealthBarPluginEnabled() || !McRPG.getInstance().getConfig().getBoolean("Configuration.HealthBarEnabled")) {
            return;
        }
        if (MobHealthbarUtils.isBoss(livingEntity)) {
            return;
        }
        if (!player.isOnline() || !PlayerManager.isPlayerStored(player.getUniqueId())) {
            return;
        }
        try {
            mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
        }
        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
            return;
        }
        if (mcRPGPlayer.getHealthbarType() == MobHealthbarType.DISABLED) {
            return;
        }
        String string = livingEntity.getCustomName();
        if (string == null) {
            string = "";
        }
        boolean bl = livingEntity.isCustomNameVisible();
        String string2 = MobHealthbarUtils.createHealthDisplay(mcRPGPlayer, livingEntity, d);
        livingEntity.setCustomName(string2);
        livingEntity.setCustomNameVisible(true);
        int n = McRPG.getInstance().getConfig().getInt("Configuration.HealthBarDisplayTime");
        if (n != -1) {
            boolean bl2;
            boolean bl3 = bl2 = !ChatColor.stripColor((String)string).equalsIgnoreCase(ChatColor.stripColor((String)string2));
            if (bl2) {
                livingEntity.setMetadata(McRPG.getInstance().getCustomNameKey(), (MetadataValue)new FixedMetadataValue((Plugin)McRPG.getInstance(), (Object)string));
                livingEntity.setMetadata(McRPG.getInstance().getCustomVisibleKey(), (MetadataValue)new FixedMetadataValue((Plugin)McRPG.getInstance(), (Object)bl));
            } else if (!livingEntity.hasMetadata(McRPG.getInstance().getCustomNameKey())) {
                livingEntity.setMetadata(McRPG.getInstance().getCustomNameKey(), (MetadataValue)new FixedMetadataValue((Plugin)McRPG.getInstance(), (Object)""));
                livingEntity.setMetadata(McRPG.getInstance().getCustomVisibleKey(), (MetadataValue)new FixedMetadataValue((Plugin)McRPG.getInstance(), (Object)false));
            }
            new MobHealthDisplayUpdaterTask(livingEntity).runTaskLater((Plugin)McRPG.getInstance(), n * 20);
        }
    }

    private static String createHealthDisplay(McRPGPlayer mcRPGPlayer, LivingEntity livingEntity, double d) {
        int n;
        String string;
        int n2;
        double d2 = livingEntity.getMaxHealth();
        double d3 = Math.max(livingEntity.getHealth() - d, 0.0);
        double d4 = d3 / d2 * 100.0;
        ChatColor chatColor = ChatColor.BLACK;
        switch (mcRPGPlayer.getHealthbarType()) {
            case HEARTS: {
                n2 = Math.min((int)(d2 / 2.0), 10);
                chatColor = ChatColor.DARK_RED;
                string = "\u2764";
                break;
            }
            case BAR: {
                n2 = 10;
                if (d4 >= 85.0) {
                    chatColor = ChatColor.DARK_GREEN;
                } else if (d4 >= 70.0) {
                    chatColor = ChatColor.GREEN;
                } else if (d4 >= 55.0) {
                    chatColor = ChatColor.GOLD;
                } else if (d4 >= 40.0) {
                    chatColor = ChatColor.YELLOW;
                } else if (d4 >= 25.0) {
                    chatColor = ChatColor.RED;
                } else if (d4 >= 0.0) {
                    chatColor = ChatColor.DARK_RED;
                }
                string = "\u25a0";
                break;
            }
            default: {
                return null;
            }
        }
        int n3 = (int)Math.ceil((double)n2 * (d4 / 100.0));
        int n4 = n2 - n3;
        String string2 = chatColor + "";
        for (n = 0; n < n3; ++n) {
            string2 = string2 + string;
        }
        string2 = string2 + ChatColor.GRAY;
        for (n = 0; n < n4; ++n) {
            string2 = string2 + string;
        }
        return string2;
    }

    private static boolean isBoss(LivingEntity livingEntity) {
        switch (livingEntity.getType()) {
            case ENDER_DRAGON: 
            case WITHER: {
                return true;
            }
        }
        return false;
    }

    public static String getPrettyEntityTypeString(EntityType entityType) {
        return MobHealthbarUtils.createPrettyEnumString(entityType.toString());
    }

    private static String createPrettyEnumString(String string) {
        String[] stringArray = string.split("_");
        String string2 = "";
        int n = 1;
        for (String string3 : stringArray) {
            string2 = string2.concat(MobHealthbarUtils.getCapitalized(string3));
            if (n < stringArray.length) {
                string2 = string2.concat(" ");
            }
            ++n;
        }
        return string2;
    }

    private static String getCapitalized(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    public static enum MobHealthbarType {
        HEARTS("Hearts"),
        BAR("Bar"),
        DISABLED("Disabled");

        String name;

        private MobHealthbarType(String string2) {
            this.name = string2;
        }

        public static MobHealthbarType fromString(String string) {
            return Arrays.stream(MobHealthbarType.values()).filter(mobHealthbarType -> mobHealthbarType.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
        }

        public String getName() {
            return this.name;
        }
    }
}

