/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util.blockmeta.conversion;

import java.io.File;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.HiddenConfig;
import us.eunoians.mcrpg.util.blockmeta.conversion.BlockStoreConversionXDirectory;

public class BlockStoreConversionMain
implements Runnable {
    private int taskID = -1;
    private int i;
    private World world;
    BukkitScheduler scheduler;
    File dataDir;
    File[] xDirs;
    BlockStoreConversionXDirectory[] converters;

    public BlockStoreConversionMain(World world) {
        this.world = world;
        this.scheduler = McRPG.getInstance().getServer().getScheduler();
        this.dataDir = new File(this.world.getWorldFolder(), "mcmmo_data");
        this.converters = new BlockStoreConversionXDirectory[HiddenConfig.getInstance().getConversionRate()];
    }

    public void start() {
        if (this.taskID >= 0) {
            return;
        }
        this.taskID = this.scheduler.runTaskLater((Plugin)McRPG.getInstance(), (Runnable)this, 1L).getTaskId();
    }

    @Override
    public void run() {
        if (!this.dataDir.exists()) {
            this.softStop();
            return;
        }
        if (!this.dataDir.isDirectory()) {
            this.dataDir.delete();
            this.softStop();
            return;
        }
        if (this.dataDir.listFiles().length <= 0) {
            this.dataDir.delete();
            this.softStop();
            return;
        }
        this.xDirs = this.dataDir.listFiles();
        this.i = 0;
        while (this.i < HiddenConfig.getInstance().getConversionRate() && this.i < this.xDirs.length) {
            if (this.converters[this.i] == null) {
                this.converters[this.i] = new BlockStoreConversionXDirectory();
            }
            this.converters[this.i].start(this.world, this.xDirs[this.i]);
            ++this.i;
        }
        this.softStop();
    }

    public void stop() {
        if (this.taskID < 0) {
            return;
        }
        this.scheduler.cancelTask(this.taskID);
        this.taskID = -1;
    }

    public void softStop() {
        this.stop();
        if (this.dataDir.exists() || this.dataDir.isDirectory()) {
            this.start();
            return;
        }
        McRPG.getInstance().getLogger().info("Finished converting the storage for " + this.world.getName() + ".");
        this.dataDir = null;
        this.xDirs = null;
        this.world = null;
        this.scheduler = null;
        this.converters = null;
    }
}

