/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util.blockmeta.chunkmeta;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import us.eunoians.mcrpg.util.blockmeta.ChunkletStore;
import us.eunoians.mcrpg.util.blockmeta.chunkmeta.ChunkStore;

public class PrimitiveChunkStore
implements ChunkStore {
    private static final long serialVersionUID = -1L;
    private transient boolean dirty = false;
    public boolean[][][] store;
    private static final int CURRENT_VERSION = 7;
    private static final int MAGIC_NUMBER = -362881349;
    private int cx;
    private int cz;
    private UUID worldUid;

    public PrimitiveChunkStore(World world, int n, int n2) {
        this.cx = n;
        this.cz = n2;
        this.worldUid = world.getUID();
        this.store = new boolean[16][16][world.getMaxHeight()];
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public int getChunkX() {
        return this.cx;
    }

    @Override
    public int getChunkZ() {
        return this.cz;
    }

    @Override
    public boolean isTrue(int n, int n2, int n3) {
        return this.store[n][n3][n2];
    }

    @Override
    public void setTrue(int n, int n2, int n3) {
        if (n2 >= this.store[0][0].length || n2 < 0) {
            return;
        }
        this.store[n][n3][n2] = true;
        this.dirty = true;
    }

    @Override
    public void setFalse(int n, int n2, int n3) {
        if (n2 >= this.store[0][0].length || n2 < 0) {
            return;
        }
        this.store[n][n3][n2] = false;
        this.dirty = true;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < this.store[0][0].length; ++k) {
                    if (!this.store[i][j][k]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void copyFrom(ChunkletStore chunkletStore) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < this.store[0][0].length; ++k) {
                    this.store[i][j][k] = chunkletStore.isTrue(i, k, j);
                }
            }
        }
        this.dirty = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeInt(-362881349);
        objectOutputStream.writeInt(7);
        objectOutputStream.writeLong(this.worldUid.getLeastSignificantBits());
        objectOutputStream.writeLong(this.worldUid.getMostSignificantBits());
        objectOutputStream.writeInt(this.cx);
        objectOutputStream.writeInt(this.cz);
        objectOutputStream.writeObject(this.store);
        this.dirty = false;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        if (n != -362881349) {
            n2 = 0;
        }
        long l = objectInputStream.readLong();
        long l2 = objectInputStream.readLong();
        this.worldUid = new UUID(l2, l);
        this.cx = objectInputStream.readInt();
        this.cz = objectInputStream.readInt();
        this.store = (boolean[][][])objectInputStream.readObject();
        if (n2 < 5) {
            this.fixArray();
            this.dirty = true;
        }
    }

    private void fixArray() {
        boolean[][][] blArray = this.store;
        this.store = new boolean[16][16][Bukkit.getWorld((UUID)this.worldUid).getMaxHeight()];
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < this.store[0][0].length; ++k) {
                    try {
                        this.store[i][j][k] = blArray[i][k][j];
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

