/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util.blockmeta.chunkmeta;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import us.eunoians.mcrpg.util.blockmeta.chunkmeta.McMMOSimpleChunkBuffer;

public class McMMOSimpleRegionFile {
    private RandomAccessFile file;
    private final int[] dataStart = new int[1024];
    private final int[] dataActualLength = new int[1024];
    private final int[] dataLength = new int[1024];
    private final ArrayList<Boolean> inuse = new ArrayList();
    private int segmentSize;
    private int segmentMask;
    private final int rx;
    private final int rz;
    private final int defaultSegmentSize;
    private final File parent;
    private long lastAccessTime = System.currentTimeMillis();
    private static long TIMEOUT_TIME = 300000L;

    public McMMOSimpleRegionFile(File file, int n, int n2) {
        this(file, n, n2, 10);
    }

    public McMMOSimpleRegionFile(File file, int n, int n2, int n3) {
        this.rx = n;
        this.rz = n2;
        this.defaultSegmentSize = n3;
        this.parent = file;
        this.lastAccessTime = System.currentTimeMillis();
        if (this.file == null) {
            try {
                int n4;
                int n5;
                this.file = new RandomAccessFile(this.parent, "rw");
                if (this.file.length() < 12288L) {
                    for (n5 = 0; n5 < 3072; ++n5) {
                        this.file.writeInt(0);
                    }
                    this.file.seek(8192L);
                    this.file.writeInt(n3);
                }
                this.file.seek(8192L);
                this.segmentSize = this.file.readInt();
                this.segmentMask = (1 << this.segmentSize) - 1;
                n5 = this.sizeToSegments(12288);
                for (n4 = 0; n4 < n5; ++n4) {
                    while (this.inuse.size() <= n4) {
                        this.inuse.add(false);
                    }
                    this.inuse.set(n4, true);
                }
                this.file.seek(0L);
                for (n4 = 0; n4 < 1024; ++n4) {
                    this.dataStart[n4] = this.file.readInt();
                }
                for (n4 = 0; n4 < 1024; ++n4) {
                    this.dataActualLength[n4] = this.file.readInt();
                    this.dataLength[n4] = this.sizeToSegments(this.dataActualLength[n4]);
                    this.setInUse(n4, true);
                }
                this.extendFile();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public final synchronized RandomAccessFile getFile() {
        this.lastAccessTime = System.currentTimeMillis();
        if (this.file == null) {
            try {
                int n;
                int n2;
                this.file = new RandomAccessFile(this.parent, "rw");
                if (this.file.length() < 12288L) {
                    for (n2 = 0; n2 < 3072; ++n2) {
                        this.file.writeInt(0);
                    }
                    this.file.seek(8192L);
                    this.file.writeInt(this.defaultSegmentSize);
                }
                this.file.seek(8192L);
                this.segmentSize = this.file.readInt();
                this.segmentMask = (1 << this.segmentSize) - 1;
                n2 = this.sizeToSegments(12288);
                for (n = 0; n < n2; ++n) {
                    while (this.inuse.size() <= n) {
                        this.inuse.add(false);
                    }
                    this.inuse.set(n, true);
                }
                this.file.seek(0L);
                for (n = 0; n < 1024; ++n) {
                    this.dataStart[n] = this.file.readInt();
                }
                for (n = 0; n < 1024; ++n) {
                    this.dataActualLength[n] = this.file.readInt();
                    this.dataLength[n] = this.sizeToSegments(this.dataActualLength[n]);
                    this.setInUse(n, true);
                }
                this.extendFile();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return this.file;
    }

    public synchronized boolean testCloseTimeout() {
        return false;
    }

    public synchronized DataOutputStream getOutputStream(int n, int n2) {
        int n3 = this.getChunkIndex(n, n2);
        return new DataOutputStream(new DeflaterOutputStream(new McMMOSimpleChunkBuffer(this, n3)));
    }

    public synchronized DataInputStream getInputStream(int n, int n2) {
        int n3 = this.getChunkIndex(n, n2);
        int n4 = this.dataActualLength[n3];
        if (n4 == 0) {
            return null;
        }
        byte[] byArray = new byte[n4];
        this.getFile().seek(this.dataStart[n3] << this.segmentSize);
        this.getFile().readFully(byArray);
        return new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
    }

    synchronized void write(int n, byte[] byArray, int n2) {
        int n3 = this.setInUse(n, false);
        int n4 = this.findSpace(n3, n2);
        this.getFile().seek(n4 << this.segmentSize);
        this.getFile().write(byArray, 0, n2);
        this.dataStart[n] = n4;
        this.dataActualLength[n] = n2;
        this.dataLength[n] = this.sizeToSegments(n2);
        this.setInUse(n, true);
        this.saveFAT();
    }

    public synchronized void close() {
        try {
            if (this.file != null) {
                this.file.seek(8192L);
                this.file.close();
            }
            this.file = null;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to close file", iOException);
        }
    }

    private synchronized int setInUse(int n, boolean bl) {
        if (this.dataActualLength[n] == 0) {
            return this.dataStart[n];
        }
        int n2 = this.dataStart[n];
        int n3 = n2 + this.dataLength[n];
        for (int i = n2; i < n3; ++i) {
            while (i > this.inuse.size() - 1) {
                this.inuse.add(false);
            }
            Boolean bl2 = this.inuse.set(i, bl);
            if (bl2 == null || bl2 != bl) continue;
            if (bl2.booleanValue()) {
                throw new IllegalStateException("Attempting to overwrite an in-use segment");
            }
            throw new IllegalStateException("Attempting to delete empty segment");
        }
        return this.dataStart[n];
    }

    private synchronized void extendFile() {
        long l = -this.getFile().length() & (long)this.segmentMask;
        this.getFile().seek(this.getFile().length());
        while (l-- > 0L) {
            this.getFile().write(0);
        }
    }

    private synchronized int findSpace(int n, int n2) {
        int n3;
        int n4 = this.sizeToSegments(n2);
        boolean bl = true;
        for (n3 = n; n3 < this.inuse.size() && n3 < n + n4; ++n3) {
            if (!this.inuse.get(n3).booleanValue()) continue;
            bl = false;
            break;
        }
        if (bl) {
            return n;
        }
        n3 = 0;
        int n5 = 0;
        while (n5 < this.inuse.size()) {
            if (this.inuse.get(n5).booleanValue()) {
                n3 = ++n5;
            } else {
                ++n5;
            }
            if (n5 - n3 < n4) continue;
            return n3;
        }
        return n3;
    }

    private synchronized int sizeToSegments(int n) {
        if (n <= 0) {
            return 1;
        }
        return (n - 1 >> this.segmentSize) + 1;
    }

    private synchronized Integer getChunkIndex(int n, int n2) {
        if (this.rx != n >> 5 || this.rz != n2 >> 5) {
            throw new RuntimeException(n + ", " + n2 + " not in region " + this.rx + ", " + this.rz);
        }
        return ((n &= 0x1F) << 5) + (n2 &= 0x1F);
    }

    private synchronized void saveFAT() {
        int n;
        this.getFile().seek(0L);
        for (n = 0; n < 1024; ++n) {
            this.getFile().writeInt(this.dataStart[n]);
        }
        for (n = 0; n < 1024; ++n) {
            this.getFile().writeInt(this.dataActualLength[n]);
        }
    }
}

