/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util.blockmeta.chunkmeta;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.util.blockmeta.chunkmeta.ChunkManager;
import us.eunoians.mcrpg.util.blockmeta.chunkmeta.ChunkStore;
import us.eunoians.mcrpg.util.blockmeta.chunkmeta.ChunkStoreFactory;
import us.eunoians.mcrpg.util.blockmeta.chunkmeta.McMMOSimpleRegionFile;
import us.eunoians.mcrpg.util.blockmeta.conversion.BlockStoreConversionZDirectory;

public class HashChunkManager
implements ChunkManager {
    private HashMap<UUID, HashMap<Long, McMMOSimpleRegionFile>> regionFiles = new HashMap();
    public HashMap<String, ChunkStore> store = new HashMap();
    public ArrayList<BlockStoreConversionZDirectory> converters = new ArrayList();
    private HashMap<UUID, Boolean> oldData = new HashMap();

    @Override
    public synchronized void closeAll() {
        for (UUID uUID : this.regionFiles.keySet()) {
            HashMap<Long, McMMOSimpleRegionFile> hashMap = this.regionFiles.get(uUID);
            Iterator<McMMOSimpleRegionFile> iterator = hashMap.values().iterator();
            while (iterator.hasNext()) {
                McMMOSimpleRegionFile mcMMOSimpleRegionFile = iterator.next();
                if (mcMMOSimpleRegionFile == null) continue;
                mcMMOSimpleRegionFile.close();
                iterator.remove();
            }
        }
        this.regionFiles.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ChunkStore readChunkStore(World world, int n, int n2) {
        McMMOSimpleRegionFile mcMMOSimpleRegionFile = this.getSimpleRegionFile(world, n, n2);
        DataInputStream dataInputStream = mcMMOSimpleRegionFile.getInputStream(n, n2);
        if (dataInputStream == null) {
            return null;
        }
        try (ObjectInputStream objectInputStream = new ObjectInputStream(dataInputStream);){
            Object object = objectInputStream.readObject();
            if (object instanceof ChunkStore) {
                ChunkStore chunkStore = (ChunkStore)object;
                return chunkStore;
            }
            try {
                throw new RuntimeException("Wrong class type read for chunk meta data for " + n + ", " + n2);
            }
            catch (IOException iOException) {
                ChunkStore chunkStore = null;
                return chunkStore;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ChunkStore chunkStore = null;
                return chunkStore;
            }
        }
    }

    @Override
    public synchronized void writeChunkStore(World world, int n, int n2, ChunkStore chunkStore) {
        if (!chunkStore.isDirty()) {
            return;
        }
        try {
            McMMOSimpleRegionFile mcMMOSimpleRegionFile = this.getSimpleRegionFile(world, n, n2);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(mcMMOSimpleRegionFile.getOutputStream(n, n2));
            objectOutputStream.writeObject(chunkStore);
            objectOutputStream.flush();
            objectOutputStream.close();
            chunkStore.setDirty(false);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to write chunk meta data for " + n + ", " + n2, iOException);
        }
    }

    @Override
    public synchronized void closeChunkStore(World world, int n, int n2) {
        McMMOSimpleRegionFile mcMMOSimpleRegionFile = this.getSimpleRegionFile(world, n, n2);
        if (mcMMOSimpleRegionFile != null) {
            mcMMOSimpleRegionFile.close();
        }
    }

    private synchronized McMMOSimpleRegionFile getSimpleRegionFile(World world, int n, int n2) {
        int n3;
        int n4;
        long l;
        McMMOSimpleRegionFile mcMMOSimpleRegionFile;
        File file = new File(world.getWorldFolder(), "mcmmo_regions");
        file.mkdirs();
        UUID uUID = world.getUID();
        HashMap<Long, McMMOSimpleRegionFile> hashMap = this.regionFiles.get(uUID);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.regionFiles.put(uUID, hashMap);
        }
        if ((mcMMOSimpleRegionFile = hashMap.get(l = (long)(n4 = n >> 5) << 32 | (long)(n3 = n2 >> 5) & 0xFFFFFFFFL)) == null) {
            File file2 = new File(file, "mcmmo_" + n4 + "_" + n3 + "_.mcm");
            mcMMOSimpleRegionFile = new McMMOSimpleRegionFile(file2, n4, n3);
            hashMap.put(l, mcMMOSimpleRegionFile);
        }
        return mcMMOSimpleRegionFile;
    }

    @Override
    public synchronized void loadChunklet(int n, int n2, int n3, World world) {
        this.loadChunk(n, n3, world, null);
    }

    @Override
    public synchronized void unloadChunklet(int n, int n2, int n3, World world) {
        this.unloadChunk(n, n3, world);
    }

    @Override
    public synchronized void loadChunk(int n, int n2, World world, Entity[] entityArray) {
        if (world == null || this.store.containsKey(world.getName() + "," + n + "," + n2)) {
            return;
        }
        UUID uUID = world.getUID();
        if (!this.oldData.containsKey(uUID)) {
            this.oldData.put(uUID, new File(world.getWorldFolder(), "mcmmo_data").exists());
        } else if (this.oldData.get(uUID).booleanValue() && this.convertChunk(new File(world.getWorldFolder(), "mcmmo_data"), n, n2, world, true)) {
            return;
        }
        ChunkStore chunkStore = null;
        try {
            chunkStore = this.readChunkStore(world, n, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (chunkStore == null) {
            return;
        }
        this.store.put(world.getName() + "," + n + "," + n2, chunkStore);
    }

    @Override
    public synchronized void unloadChunk(int n, int n2, World world) {
        this.saveChunk(n, n2, world);
        if (this.store.containsKey(world.getName() + "," + n + "," + n2)) {
            this.store.remove(world.getName() + "," + n + "," + n2);
        }
    }

    @Override
    public synchronized void saveChunk(int n, int n2, World world) {
        if (world == null) {
            return;
        }
        String string = world.getName() + "," + n + "," + n2;
        if (this.store.containsKey(string)) {
            ChunkStore chunkStore = this.store.get(world.getName() + "," + n + "," + n2);
            if (!chunkStore.isDirty()) {
                return;
            }
            this.writeChunkStore(world, n, n2, chunkStore);
        }
    }

    @Override
    public synchronized boolean isChunkLoaded(int n, int n2, World world) {
        if (world == null) {
            return false;
        }
        return this.store.containsKey(world.getName() + "," + n + "," + n2);
    }

    @Override
    public synchronized void chunkLoaded(int n, int n2, World world) {
    }

    @Override
    public synchronized void chunkUnloaded(int n, int n2, World world) {
        if (world == null) {
            return;
        }
        this.unloadChunk(n, n2, world);
    }

    @Override
    public synchronized void saveWorld(World world) {
        if (world == null) {
            return;
        }
        this.closeAll();
        String string = world.getName();
        ArrayList<String> arrayList = new ArrayList<String>(this.store.keySet());
        for (String string2 : arrayList) {
            String[] stringArray = string2.split(",");
            if (!string.equals(stringArray[0])) continue;
            try {
                this.saveChunk(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), world);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public synchronized void unloadWorld(World world) {
        if (world == null) {
            return;
        }
        this.closeAll();
        String string = world.getName();
        ArrayList<String> arrayList = new ArrayList<String>(this.store.keySet());
        for (String string2 : arrayList) {
            String[] stringArray = string2.split(",");
            if (!string.equals(stringArray[0])) continue;
            try {
                this.unloadChunk(Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), world);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public synchronized void loadWorld(World world) {
    }

    @Override
    public synchronized void saveAll() {
        this.closeAll();
        for (World world : McRPG.getInstance().getServer().getWorlds()) {
            this.saveWorld(world);
        }
    }

    @Override
    public synchronized void unloadAll() {
        this.closeAll();
        for (World world : McRPG.getInstance().getServer().getWorlds()) {
            this.unloadWorld(world);
        }
    }

    @Override
    public synchronized boolean isTrue(int n, int n2, int n3, World world) {
        if (world == null) {
            return false;
        }
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        String string = world.getName() + "," + n4 + "," + n5;
        if (!this.store.containsKey(string)) {
            this.loadChunk(n4, n5, world, null);
        }
        if (!this.store.containsKey(string)) {
            return false;
        }
        ChunkStore chunkStore = this.store.get(string);
        int n6 = Math.abs(n) % 16;
        int n7 = Math.abs(n3) % 16;
        return chunkStore.isTrue(n6, n2, n7);
    }

    @Override
    public synchronized boolean isTrue(Block block) {
        if (block == null) {
            return false;
        }
        return this.isTrue(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public synchronized boolean isTrue(BlockState blockState) {
        if (blockState == null) {
            return false;
        }
        return this.isTrue(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getWorld());
    }

    @Override
    public synchronized void setTrue(int n, int n2, int n3, World world) {
        ChunkStore chunkStore;
        if (world == null) {
            return;
        }
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        int n6 = Math.abs(n) % 16;
        int n7 = Math.abs(n3) % 16;
        String string = world.getName() + "," + n4 + "," + n5;
        if (!this.store.containsKey(string)) {
            this.loadChunk(n4, n5, world, null);
        }
        if ((chunkStore = this.store.get(string)) == null) {
            chunkStore = ChunkStoreFactory.getChunkStore(world, n4, n5);
            this.store.put(string, chunkStore);
        }
        chunkStore.setTrue(n6, n2, n7);
    }

    @Override
    public synchronized void setTrue(Block block) {
        if (block == null) {
            return;
        }
        this.setTrue(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public void setTrue(BlockState blockState) {
        if (blockState == null) {
            return;
        }
        this.setTrue(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getWorld());
    }

    @Override
    public synchronized void setFalse(int n, int n2, int n3, World world) {
        ChunkStore chunkStore;
        if (world == null) {
            return;
        }
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        int n6 = Math.abs(n) % 16;
        int n7 = Math.abs(n3) % 16;
        String string = world.getName() + "," + n4 + "," + n5;
        if (!this.store.containsKey(string)) {
            this.loadChunk(n4, n5, world, null);
        }
        if ((chunkStore = this.store.get(string)) == null) {
            return;
        }
        chunkStore.setFalse(n6, n2, n7);
    }

    @Override
    public synchronized void setFalse(Block block) {
        if (block == null) {
            return;
        }
        this.setFalse(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public synchronized void setFalse(BlockState blockState) {
        if (blockState == null) {
            return;
        }
        this.setFalse(blockState.getX(), blockState.getY(), blockState.getZ(), blockState.getWorld());
    }

    @Override
    public synchronized void cleanUp() {
    }

    public synchronized void convertChunk(File file, int n, int n2, World world) {
        this.convertChunk(file, n, n2, world, false);
    }

    public synchronized boolean convertChunk(File file, int n, int n2, World world, boolean bl) {
        if (!bl || !file.exists()) {
            return false;
        }
        File file2 = new File(file, "" + n);
        if (!file2.exists()) {
            return false;
        }
        File file3 = new File(file2, "" + n2);
        if (!file3.exists()) {
            return false;
        }
        boolean bl2 = false;
        for (BlockStoreConversionZDirectory blockStoreConversionZDirectory : this.converters) {
            if (blockStoreConversionZDirectory == null || blockStoreConversionZDirectory.taskID >= 0) continue;
            blockStoreConversionZDirectory.start(world, file2, file3);
            bl2 = true;
            break;
        }
        if (!bl2) {
            BlockStoreConversionZDirectory blockStoreConversionZDirectory = new BlockStoreConversionZDirectory();
            blockStoreConversionZDirectory.start(world, file2, file3);
            this.converters.add(blockStoreConversionZDirectory);
        }
        return true;
    }
}

