/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util.blockmeta;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import us.eunoians.mcrpg.util.blockmeta.ChunkletStore;
import us.eunoians.mcrpg.util.blockmeta.PrimitiveChunkletStore;

public class PrimitiveExChunkletStore
implements ChunkletStore,
Externalizable {
    private static final long serialVersionUID = 8603603827094383873L;
    public boolean[][][] store = new boolean[16][16][64];

    @Override
    public boolean isTrue(int n, int n2, int n3) {
        return this.store[n][n3][n2];
    }

    @Override
    public void setTrue(int n, int n2, int n3) {
        this.store[n][n3][n2] = true;
    }

    @Override
    public void setFalse(int n, int n2, int n3) {
        this.store[n][n3][n2] = false;
    }

    @Override
    public boolean isEmpty() {
        return !PrimitiveChunkletStore.checkEmpty(this.store);
    }

    @Override
    public void copyFrom(ChunkletStore chunkletStore) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 64; ++k) {
                    this.store[i][j][k] = chunkletStore.isTrue(i, k, j);
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) {
        byte[] byArray = new byte[2304];
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            block1: for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 64; ++k) {
                    if (!this.store[i][j][k]) continue;
                    byte[] byArray2 = this.constructColumn(i, j);
                    for (int i2 = 0; i2 < 9; ++i2) {
                        byArray[n] = byArray2[i2];
                        ++n;
                    }
                    continue block1;
                }
            }
        }
        objectOutput.write(byArray, 0, n);
        objectOutput.flush();
    }

    @Override
    public void readExternal(ObjectInput objectInput) {
        byte[] byArray = new byte[9];
        while (objectInput.read(byArray, 0, 9) == 9) {
            int n = PrimitiveExChunkletStore.addressByteX(byArray[0]);
            int n2 = PrimitiveExChunkletStore.addressByteZ(byArray[0]);
            boolean[] blArray = new boolean[64];
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    blArray[j + i * 8] = (byArray[i + 1] & 1 << j) != 0;
                }
            }
            this.store[n][n2] = blArray;
        }
    }

    private byte[] constructColumn(int n, int n2) {
        byte[] byArray = new byte[9];
        int n3 = 1;
        byArray[0] = PrimitiveExChunkletStore.makeAddressByte(n, n2);
        for (int i = 0; i < 8; ++i) {
            byte by = 0;
            int n4 = 8 * i;
            int n5 = n4 + 8;
            for (int j = n4; j < n5; ++j) {
                if (!this.store[n][n2][j]) continue;
                by = (byte)(by | 1 << j % 8);
            }
            byArray[n3] = by;
            ++n3;
        }
        return byArray;
    }

    protected static byte makeAddressByte(int n, int n2) {
        return (byte)((n << 4) + n2);
    }

    protected static int addressByteX(byte by) {
        return (by & 0xF0) >>> 4;
    }

    protected static int addressByteZ(byte by) {
        return by & 0xF;
    }
}

