/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util.blockmeta;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.util.HashMap;
import org.bukkit.World;
import org.bukkit.block.Block;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.util.blockmeta.ChunkletManager;
import us.eunoians.mcrpg.util.blockmeta.ChunkletStore;
import us.eunoians.mcrpg.util.blockmeta.ChunkletStoreFactory;

public class HashChunkletManager
implements ChunkletManager {
    public HashMap<String, ChunkletStore> store = new HashMap();

    @Override
    public void loadChunklet(int n, int n2, int n3, World world) {
        File file = new File(world.getWorldFolder(), "mcmmo_data");
        File file2 = new File(file, "" + n);
        if (!file2.exists()) {
            return;
        }
        File file3 = new File(file2, "" + n3);
        if (!file3.exists()) {
            return;
        }
        File file4 = new File(file3, "" + n2);
        if (!file4.exists()) {
            return;
        }
        ChunkletStore chunkletStore = this.deserializeChunkletStore(file4);
        if (chunkletStore != null) {
            this.store.put(world.getName() + "," + n + "," + n3 + "," + n2, chunkletStore);
        }
    }

    @Override
    public void unloadChunklet(int n, int n2, int n3, World world) {
        File file = new File(world.getWorldFolder(), "mcmmo_data");
        this.unload(n, n3, world, file, n2);
    }

    @Override
    public void loadChunk(int n, int n2, World world) {
        File file = new File(world.getWorldFolder(), "mcmmo_data");
        File file2 = new File(file, "" + n);
        if (!file2.exists()) {
            return;
        }
        File file3 = new File(file2, "" + n2);
        if (!file3.exists()) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            ChunkletStore chunkletStore;
            File file4 = new File(file3, "" + i);
            if (!file4.exists() || (chunkletStore = this.deserializeChunkletStore(file4)) == null) continue;
            this.store.put(world.getName() + "," + n + "," + n2 + "," + i, chunkletStore);
        }
    }

    @Override
    public void unloadChunk(int n, int n2, World world) {
        File file = new File(world.getWorldFolder(), "mcmmo_data");
        for (int i = 0; i < 4; ++i) {
            this.unload(n, n2, world, file, i);
        }
    }

    private void unload(int n, int n2, World world, File file, int n3) {
        if (this.store.containsKey(world.getName() + "," + n + "," + n2 + "," + n3)) {
            File file2;
            File file3 = new File(file, "" + n);
            if (!file3.exists()) {
                file3.mkdir();
            }
            if (!(file2 = new File(file3, "" + n2)).exists()) {
                file2.mkdir();
            }
            File file4 = new File(file2, "" + n3);
            ChunkletStore chunkletStore = this.store.get(world.getName() + "," + n + "," + n2 + "," + n3);
            this.serializeChunkletStore(chunkletStore, file4);
            this.store.remove(world.getName() + "," + n + "," + n2 + "," + n3);
        }
    }

    @Override
    public void chunkLoaded(int n, int n2, World world) {
    }

    @Override
    public void chunkUnloaded(int n, int n2, World world) {
        this.unloadChunk(n, n, world);
    }

    @Override
    public void saveWorld(World world) {
        String string = world.getName();
        File file = new File(world.getWorldFolder(), "mcmmo_data");
        if (!file.exists()) {
            file.mkdirs();
        }
        for (String string2 : this.store.keySet()) {
            File file2;
            String[] stringArray = string2.split(",");
            if (!string.equals(stringArray[0])) continue;
            File file3 = new File(file, "" + stringArray[1]);
            if (!file3.exists()) {
                file3.mkdir();
            }
            if (!(file2 = new File(file3, "" + stringArray[2])).exists()) {
                file2.mkdir();
            }
            File file4 = new File(file2, "" + stringArray[3]);
            this.serializeChunkletStore(this.store.get(string2), file4);
        }
    }

    @Override
    public void unloadWorld(World world) {
        this.saveWorld(world);
        String string = world.getName();
        for (String string2 : this.store.keySet()) {
            String string3 = string2.split(",")[0];
            if (!string3.equals(string)) continue;
            this.store.remove(string2);
            return;
        }
    }

    @Override
    public void loadWorld(World world) {
    }

    @Override
    public void saveAll() {
        for (World world : McRPG.getInstance().getServer().getWorlds()) {
            this.saveWorld(world);
        }
    }

    @Override
    public void unloadAll() {
        this.saveAll();
        for (World world : McRPG.getInstance().getServer().getWorlds()) {
            this.unloadWorld(world);
        }
    }

    @Override
    public boolean isTrue(int n, int n2, int n3, World world) {
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        int n6 = n2 >> 6;
        String string = world.getName() + "," + n4 + "," + n5 + "," + n6;
        if (!this.store.containsKey(string)) {
            this.loadChunklet(n4, n6, n5, world);
        }
        if (!this.store.containsKey(string)) {
            return false;
        }
        ChunkletStore chunkletStore = this.store.get(world.getName() + "," + n4 + "," + n5 + "," + n6);
        int n7 = Math.abs(n) % 16;
        int n8 = Math.abs(n3) % 16;
        int n9 = Math.abs(n2) % 64;
        return chunkletStore.isTrue(n7, n9, n8);
    }

    @Override
    public boolean isTrue(Block block) {
        return this.isTrue(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public void setTrue(int n, int n2, int n3, World world) {
        ChunkletStore chunkletStore;
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        int n6 = n2 >> 6;
        int n7 = Math.abs(n) % 16;
        int n8 = Math.abs(n3) % 16;
        int n9 = Math.abs(n2) % 64;
        String string = world.getName() + "," + n4 + "," + n5 + "," + n6;
        if (!this.store.containsKey(string)) {
            this.loadChunklet(n4, n6, n5, world);
        }
        if ((chunkletStore = this.store.get(string)) == null) {
            chunkletStore = ChunkletStoreFactory.getChunkletStore();
            this.store.put(world.getName() + "," + n4 + "," + n5 + "," + n6, chunkletStore);
        }
        chunkletStore.setTrue(n7, n9, n8);
    }

    @Override
    public void setTrue(Block block) {
        this.setTrue(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public void setFalse(int n, int n2, int n3, World world) {
        ChunkletStore chunkletStore;
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        int n6 = n2 >> 6;
        int n7 = Math.abs(n) % 16;
        int n8 = Math.abs(n3) % 16;
        int n9 = Math.abs(n2) % 64;
        String string = world.getName() + "," + n4 + "," + n5 + "," + n6;
        if (!this.store.containsKey(string)) {
            this.loadChunklet(n4, n6, n5, world);
        }
        if ((chunkletStore = this.store.get(string)) == null) {
            return;
        }
        chunkletStore.setFalse(n7, n9, n8);
    }

    @Override
    public void setFalse(Block block) {
        this.setFalse(block.getX(), block.getY(), block.getZ(), block.getWorld());
    }

    @Override
    public void cleanUp() {
        for (String string : this.store.keySet()) {
            File file;
            if (!this.store.get(string).isEmpty()) continue;
            String[] stringArray = string.split(",");
            File file2 = new File(McRPG.getInstance().getServer().getWorld(stringArray[0]).getWorldFolder(), "mcmmo_data");
            File file3 = new File(file2, "" + stringArray[1]);
            if (!file3.exists() || !(file = new File(file3, "" + stringArray[2])).exists()) continue;
            File file4 = new File(file, "" + stringArray[3]);
            file4.delete();
            if (file.list().length == 0) {
                file.delete();
            }
            if (file3.list().length != 0) continue;
            file3.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeChunkletStore(ChunkletStore chunkletStore, File file) {
        FileOutputStream fileOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            fileOutputStream = new FileOutputStream(file);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(chunkletStore);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.flush();
                    objectOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkletStore deserializeChunkletStore(File file) {
        ChunkletStore chunkletStore = null;
        FileInputStream fileInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            objectInputStream = new ObjectInputStream(fileInputStream);
            chunkletStore = (ChunkletStore)objectInputStream.readObject();
        }
        catch (IOException iOException) {
            if (iOException instanceof EOFException) {
                ChunkletStore chunkletStore2 = ChunkletStoreFactory.getChunkletStore();
                return chunkletStore2;
            }
            if (iOException instanceof StreamCorruptedException) {
                ChunkletStore chunkletStore3 = ChunkletStoreFactory.getChunkletStore();
                return chunkletStore3;
            }
            if (iOException instanceof UTFDataFormatException) {
                ChunkletStore chunkletStore4 = ChunkletStoreFactory.getChunkletStore();
                return chunkletStore4;
            }
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return chunkletStore;
    }
}

