/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util;

import us.eunoians.mcrpg.util.EvaluationException;
import us.eunoians.mcrpg.util.ExpressionNode;

public class VariableNode
implements ExpressionNode {
    protected double value;
    protected boolean error;
    protected String name;
    protected ExpressionNode[] children = new ExpressionNode[0];

    public VariableNode(String string, boolean bl) {
        this.name = string;
        this.value = 0.0;
        this.error = bl;
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    public int getDepth() {
        return 1;
    }

    @Override
    public String getSubtype() {
        return this.name;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public double getValue() {
        if (!this.error) {
            return this.value;
        }
        throw new EvaluationException("Variable '" + this.name + "' was not initialized.");
    }

    @Override
    public void setVariable(String string, double d) {
        if (this.name.equals(string)) {
            this.value = d;
            this.error = false;
        }
    }

    @Override
    public ExpressionNode[] getChildrenNodes() {
        return this.children;
    }

    @Override
    public Object clone() {
        VariableNode variableNode = new VariableNode(this.name, this.error);
        variableNode.value = this.value;
        return variableNode;
    }

    @Override
    public String toString() {
        return this.getSubtype();
    }
}

