/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util;

public class Sfun {
    public static final double EPSILON_SMALL = 1.1102230246252E-16;
    public static final double EPSILON_LARGE = 2.2204460492503E-16;
    private static final double[] COT_COEF = new double[]{0.2402591609829563, -0.016533031601500228, -4.299839193172402E-5, -1.5928322332754105E-7, -6.191093135129349E-10, -2.430197415072646E-12, -9.56093675880008E-15, -3.763537981945806E-17, -1.4816657464674657E-19};
    private static final double[] SINH_COEF = new double[]{0.1730421940471796, 0.08759422192276048, 0.00107947777456713, 6.37484926075E-6, 2.202366404E-8, 4.98794E-11, 7.973E-14, 9.0E-17};
    private static final double[] TANH_COEF = new double[]{-0.2582875664363471, -0.11836106330053497, 0.009869442648006398, -8.35798662344582E-4, 7.0904321198943E-5, -6.01642431812E-6, 5.105241908E-7, -4.3320729077E-8, 3.675999055E-9, -3.11928496E-10, 2.6468828E-11, -2.246023E-12, 1.90587E-13, -1.6172E-14, 1.372E-15, -1.16E-16, 9.0E-18};
    private static final double[] ASINH_COEF = new double[]{-0.12820039911738187, -0.05881176118995177, 0.004727465432212481, -4.938363162653618E-4, 5.850620705855741E-5, -7.466998328931368E-6, 1.00116935835582E-6, -1.3903543858708333E-7, 1.9823169483172795E-8, -2.8847468417848845E-9, 4.2672965467159937E-10, -6.397608465436636E-11, 9.699168608906471E-12, -1.4844276972043772E-12, 2.290373793902745E-13, -3.5588395132732646E-14, 5.563969408005679E-15, -8.746250959962468E-16, 1.381524884452669E-16, -2.1916688282900364E-17, 3.490465852482756E-18};
    private static final double[] ATANH_COEF = new double[]{0.0943951023931955, 0.04919843705578616, 0.002102593522455433, 1.0735544497761166E-4, 5.978267249293031E-6, 3.505062030889135E-7, 2.1263743437653402E-8, 1.3216945357155272E-9, 8.36587550117807E-11, 5.370503749311002E-12, 3.4866594701571077E-13, 2.284549509603433E-14, 1.508407105944793E-15, 1.0024188168041091E-16, 6.69867473816507E-18, 4.497954546494931E-19};
    private static final double[] GAMMA_COEF = new double[]{0.00857119559098933, 0.004415381324841007, 0.05685043681599363, -0.00421983539641856, 0.0013268081812124603, -1.8930245297988805E-4, 3.606925327441245E-5, -6.056761904460864E-6, 1.0558295463022833E-6, -1.811967365542384E-7, 3.117724964715322E-8, -5.354219639019687E-9, 9.193275519859589E-10, -1.5779412802883398E-10, 2.7079806229349544E-11, -4.64681865382573E-12, 7.97335019200742E-13, -1.368078209830916E-13, 2.3473194865638007E-14, -4.027432614949067E-15, 6.910051747372101E-16, -1.185584500221993E-16, 2.034148542496374E-17, -3.490054341717406E-18, 5.987993856485306E-19, -1.027378057872228E-19};
    private static final double[] R9LGMC_COEF = new double[]{0.16663894804518634, -1.384948176067564E-5, 9.81082564692473E-9, -1.809129475572494E-11, 6.221098041892606E-14, -3.399615005417722E-16, 2.683181998482699E-18};
    private static final double[] ALNRCS_COEF = new double[]{1.037869356274377, -0.13364301504908918, 0.019408249135520562, -0.0030107551127535777, 4.869461479715485E-4, -8.105488189317536E-5, 1.3778847799559525E-5, -2.380221089435897E-6, 4.1640416213865184E-7, -7.359582837807599E-8, 1.3117611876241675E-8, -2.3546709317742423E-9, 4.2522773276035E-10, -7.71908941348408E-11, 1.407574648135907E-11, -2.5769072058024682E-12, 4.734240666629442E-13, -8.724901267474264E-14, 1.612461490274055E-14, -2.9875652015665774E-15, 5.548070120908289E-16, -1.0324619158271569E-16, 1.9250239203049852E-17, -3.595507346526515E-18, 6.726454253787686E-19, -1.260262416873522E-19};
    private static final double[] ERFC_COEF = new double[]{-0.049046121234691806, -0.14226120510371365, 0.010035582187599796, -5.768764699767485E-4, 2.741993125219606E-5, -1.1043175507344507E-6, 3.8488755420345036E-8, -1.1808582533875466E-9, 3.2334215826050907E-11, -7.991015947004549E-13, 1.7990725113961456E-14, -3.718635487818693E-16, 7.103599003714253E-18, -1.2612455119155226E-19};
    private static final double[] ERFC2_COEF = new double[]{-0.0696013466023095, -0.04110133936262089, 0.003914495866689627, -4.906395650548979E-4, 7.157479001377036E-5, -1.1530716341312328E-5, 1.9946705902019974E-6, -3.642666471599223E-7, 6.944372610005012E-8, -1.371220902104366E-8, 2.7883896610071373E-9, -5.814164724331161E-10, 1.2389204917527532E-10, -2.6906391453067435E-11, 5.942614350847911E-12, -1.3323867357581197E-12, 3.0280468061771323E-13, -6.966648814941033E-14, 1.620854541053923E-14, -3.809934465250492E-15, 9.040487815978831E-16, -2.1640061950896072E-16, 5.222102233995855E-17, -1.2697296023645554E-17, 3.1091455042761977E-18, -7.663762920320386E-19, 1.9008192513627452E-19};
    private static final double[] ERFCC_COEF = new double[]{0.07151793102029248, -0.026532434337606717, 0.0017111539779208558, -1.6375166345851787E-4, 1.9871293500552038E-5, -2.843712412766555E-6, 4.6061613089631305E-7, -8.227753025879209E-8, 1.5921418727709012E-8, -3.295071362252843E-9, 7.223439760400556E-10, -1.6648558133987297E-10, 4.010392588237665E-11, -1.004816214425731E-11, 2.608275913300334E-12, -6.991110560404025E-13, 1.9294923332617072E-13, -5.470131188754331E-14, 1.5896633097626975E-14, -4.726893980197555E-15, 1.4358733767849847E-15, -4.449510561817358E-16, 1.4048108847682335E-16, -4.5138183877642106E-17, 1.474521541045133E-17, -4.8926214069457765E-18, 1.6476121414106467E-18, -5.626817176329408E-19, 1.9474433822320786E-19};

    private Sfun() {
    }

    public static double acosh(double d) {
        double d2 = Double.isNaN(d) || d < 1.0 ? Double.NaN : (d < 9.490626562E7 ? Math.log(d + Math.sqrt(d * d - 1.0)) : 0.6931471805599453 + Math.log(d));
        return d2;
    }

    public static double asinh(double d) {
        double d2 = Math.abs(d);
        double d3 = Double.isNaN(d) ? Double.NaN : (d2 <= 1.05367E-8 ? d : (d2 <= 1.0 ? d * (1.0 + Sfun.csevl(2.0 * d * d - 1.0, ASINH_COEF)) : (d2 < 9.490626562E7 ? Math.log(d2 + Math.sqrt(d2 * d2 + 1.0)) : 0.6931471805599453 + Math.log(d2))));
        if (d < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public static double atanh(double d) {
        double d2 = Math.abs(d);
        double d3 = Double.isNaN(d) ? Double.NaN : (d2 < 1.82501E-8 ? d : (d2 <= 0.5 ? d * (1.0 + Sfun.csevl(8.0 * d * d - 1.0, ATANH_COEF)) : (d2 < 1.0 ? 0.5 * Math.log((1.0 + d) / (1.0 - d)) : (d2 == 1.0 ? d * Double.POSITIVE_INFINITY : Double.NaN))));
        return d3;
    }

    public static double cosh(double d) {
        double d2 = Math.exp(Math.abs(d));
        double d3 = Double.isNaN(d) ? Double.NaN : (Double.isInfinite(d) ? d : (d2 < 9.490626562E7 ? 0.5 * (d2 + 1.0 / d2) : 0.5 * d2));
        return d3;
    }

    public static double cot(double d) {
        double d2;
        double d3 = 0.011619772367581343;
        double d4 = Math.abs(d);
        if (d4 > 4.5036E15) {
            return Double.NaN;
        }
        double d5 = (int)d4;
        double d6 = d4 - d5;
        double d7 = 0.625 * d5;
        d5 = (int)d7;
        d4 = d7 - d5 + 0.625 * d6 + d4 * d3;
        double d8 = (int)d4;
        d4 -= d8;
        int n = (int)((d5 += d8) % 2.0);
        if (n == 1) {
            d4 = 1.0 - d4;
        }
        if (d4 == 0.0) {
            d2 = Double.POSITIVE_INFINITY;
        } else if (d4 <= 1.82501E-8) {
            d2 = 1.0 / d4;
        } else if (d4 <= 0.25) {
            d2 = (0.5 + Sfun.csevl(32.0 * d4 * d4 - 1.0, COT_COEF)) / d4;
        } else if (d4 <= 0.5) {
            d2 = (0.5 + Sfun.csevl(8.0 * d4 * d4 - 1.0, COT_COEF)) / (0.5 * d4);
            d2 = (d2 * d2 - 1.0) * 0.5 / d2;
        } else {
            d2 = (0.5 + Sfun.csevl(2.0 * d4 * d4 - 1.0, COT_COEF)) / (0.25 * d4);
            d2 = (d2 * d2 - 1.0) * 0.5 / d2;
            d2 = (d2 * d2 - 1.0) * 0.5 / d2;
        }
        if (d != 0.0) {
            d2 = Sfun.sign(d2, d);
        }
        if (n == 1) {
            d2 = -d2;
        }
        return d2;
    }

    static double csevl(double d, double[] dArray) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 2.0 * d;
        for (int i = dArray.length - 1; i >= 0; --i) {
            d4 = d2;
            d2 = d3;
            d3 = d5 * d2 - d4 + dArray[i];
        }
        return 0.5 * (d3 - d4);
    }

    private static double dlnrel(double d) {
        double d2 = d <= -1.0 ? Double.NaN : (Math.abs(d) <= 0.375 ? d * (1.0 - d * Sfun.csevl(d / 0.375, ALNRCS_COEF)) : Math.log(1.0 + d));
        return d2;
    }

    public static double erf(double d) {
        double d2 = Math.abs(d);
        double d3 = d2 <= 1.49012E-8 ? 2.0 * d / 1.772453850905516 : (d2 <= 1.0 ? d * (1.0 + Sfun.csevl(2.0 * d * d - 1.0, ERFC_COEF)) : (d2 < 6.013687357 ? Sfun.sign(1.0 - Sfun.erfc(d2), d) : Sfun.sign(1.0, d)));
        return d3;
    }

    public static double erfc(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d <= -6.013687357) {
            d2 = 2.0;
        } else if (d3 < 1.49012E-8) {
            d2 = 1.0 - 2.0 * d / 1.772453850905516;
        } else {
            double d4 = d3 * d3;
            if (d3 < 1.0) {
                d2 = 1.0 - d * (1.0 + Sfun.csevl(2.0 * d4 - 1.0, ERFC_COEF));
            } else if (d3 <= 4.0) {
                d2 = Math.exp(-d4) / d3 * (0.5 + Sfun.csevl((8.0 / d4 - 5.0) / 3.0, ERFC2_COEF));
                if (d < 0.0) {
                    d2 = 2.0 - d2;
                }
                if (d < 0.0) {
                    d2 = 2.0 - d2;
                }
                if (d < 0.0) {
                    d2 = 2.0 - d2;
                }
            } else {
                d2 = Math.exp(-d4) / d3 * (0.5 + Sfun.csevl(8.0 / d4 - 1.0, ERFCC_COEF));
                if (d < 0.0) {
                    d2 = 2.0 - d2;
                }
            }
        }
        return d2;
    }

    public static double fact(int n) {
        double d = 1.0;
        if (Double.isNaN(n) || n < 0) {
            d = Double.NaN;
        } else if (n > 170) {
            d = Double.POSITIVE_INFINITY;
        } else {
            for (int i = 2; i <= n; ++i) {
                d *= (double)i;
            }
        }
        return d;
    }

    public static double gamma(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (d3 <= 10.0) {
            int n = (int)d;
            if (d < 0.0) {
                --n;
            }
            d3 = d - (double)n;
            d2 = 0.9375 + Sfun.csevl(2.0 * d3 - 1.0, GAMMA_COEF);
            if (--n != 0) {
                if (n < 0) {
                    n = -n;
                    if (d == 0.0) {
                        d2 = Double.NaN;
                    } else if (d3 < 5.562684646268003E-309) {
                        d2 = Double.POSITIVE_INFINITY;
                    } else {
                        double d4 = n - 2;
                        if (d < 0.0 && d + d4 == 0.0) {
                            d2 = Double.NaN;
                        } else {
                            for (int i = 0; i < n; ++i) {
                                d2 /= d + (double)i;
                            }
                        }
                    }
                } else {
                    for (int i = 1; i <= n; ++i) {
                        d2 *= d3 + (double)i;
                    }
                }
            }
        } else if (d > 171.614) {
            d2 = Double.POSITIVE_INFINITY;
        } else if (d < -170.56) {
            d2 = 0.0;
        } else {
            d2 = Math.exp((d3 - 0.5) * Math.log(d3) - d3 + 0.9189385332046727 + Sfun.r9lgmc(d3));
            if (d < 0.0) {
                double d5 = Math.sin(Math.PI * d3);
                d2 = d5 == 0.0 || (double)Math.round(d3) == d3 ? Double.NaN : -Math.PI / (d3 * d5 * d2);
            }
        }
        return d2;
    }

    public static double log10(double d) {
        return 0.4342944819032518 * Math.log(d);
    }

    public static double logBeta(double d, double d2) {
        double d3;
        double d4 = Math.min(d, d2);
        double d5 = Math.max(d, d2);
        if (d4 <= 0.0) {
            d3 = Double.NaN;
        } else if (d4 >= 10.0) {
            double d6 = Sfun.r9lgmc(d4) + Sfun.r9lgmc(d5) - Sfun.r9lgmc(d4 + d5);
            double d7 = Sfun.dlnrel(-d4 / (d4 + d5));
            d3 = -0.5 * Math.log(d5) + 0.9189385332046728 + d6 + (d4 - 0.5) * Math.log(d4 / (d4 + d5)) + d5 * d7;
        } else if (d5 >= 10.0) {
            double d8 = Sfun.r9lgmc(d5) - Sfun.r9lgmc(d4 + d5);
            d3 = Sfun.logGamma(d4) + d8 + d4 - d4 * Math.log(d4 + d5) + (d5 - 0.5) * Sfun.dlnrel(-d4 / (d4 + d5));
        } else {
            d3 = Math.log(Sfun.gamma(d4) * (Sfun.gamma(d5) / Sfun.gamma(d4 + d5)));
        }
        return d3;
    }

    public static double logGamma(double d) {
        double d2;
        double d3 = Math.abs(d);
        double d4 = d3 <= 10.0 ? Math.log(Math.abs(Sfun.gamma(d))) : (d > 0.0 ? 0.9189385332046727 + (d - 0.5) * Math.log(d) - d + Sfun.r9lgmc(d3) : ((d2 = Math.abs(Math.sin(Math.PI * d3))) == 0.0 || (double)Math.round(d3) == d3 ? Double.NaN : 0.22579135264472744 + (d - 0.5) * Math.log(d3) - d - Math.log(d2) - Sfun.r9lgmc(d3)));
        return d4;
    }

    static double r9lgmc(double d) {
        double d2;
        if (d < 10.0) {
            d2 = Double.NaN;
        } else if (d < 9.490626562E7) {
            double d3 = 10.0 / d;
            d2 = Sfun.csevl(2.0 * d3 * d3 - 1.0, R9LGMC_COEF) / d;
        } else {
            d2 = d < 1.39118E11 ? 1.0 / (12.0 * d) : 0.0;
        }
        return d2;
    }

    private static double sign(double d, double d2) {
        double d3 = d < 0.0 ? -d : d;
        return d2 < 0.0 ? -d3 : d3;
    }

    public static double sinh(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (Double.isNaN(d)) {
            d2 = Double.NaN;
        } else {
            if (Double.isInfinite(d3)) {
                return d;
            }
            d2 = d3 < 2.58096E-8 ? d : (d3 <= 1.0 ? d * (1.0 + Sfun.csevl(2.0 * d * d - 1.0, SINH_COEF)) : ((d3 = Math.exp(d3)) >= 9.490626562E7 ? Sfun.sign(0.5 * d3, d) : Sfun.sign(0.5 * (d3 - 1.0 / d3), d)));
        }
        return d2;
    }

    public static double tanh(double d) {
        double d2;
        double d3 = Math.abs(d);
        if (Double.isNaN(d)) {
            d2 = Double.NaN;
        } else if (d3 < 1.82501E-8) {
            d2 = d;
        } else if (d3 <= 1.0) {
            d2 = d * (1.0 + Sfun.csevl(2.0 * d * d - 1.0, TANH_COEF));
        } else if (d3 < 7.977294885) {
            d3 = Math.exp(d3);
            d2 = Sfun.sign((d3 - 1.0 / d3) / (d3 + 1.0 / d3), d);
        } else {
            d2 = Sfun.sign(1.0, d);
        }
        return d2;
    }
}

