/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util;

import java.util.HashSet;
import us.eunoians.mcrpg.util.ConstantNode;
import us.eunoians.mcrpg.util.ExpressionNode;
import us.eunoians.mcrpg.util.FunctionNode;
import us.eunoians.mcrpg.util.OperatorNode;
import us.eunoians.mcrpg.util.ParseError;
import us.eunoians.mcrpg.util.VariableNode;

public class Parser {
    private static final char TERM = '@';
    private static final char NUM = 'n';
    private static final char FUNC = 'f';
    private static final char VAR = 'x';
    private static final char OP_BRACKET = '(';
    private static final char CL_BRACKET = ')';
    private char[] input;
    private boolean error;
    private int inp_cur;
    private Element cc;
    private ExpressionNode root;
    private HashSet<String> functions;
    private HashSet<String> variables;

    public Parser(String string) {
        this(string, false);
    }

    public Parser(String string, boolean bl) {
        this.input = this.convertInput(string);
        this.root = null;
        this.inp_cur = 0;
        this.error = bl;
        this.functions = new HashSet();
        this.variables = new HashSet();
    }

    protected char[] convertInput(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length + 1];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (!this.isNumber(c) && !this.isOperator(c) && !this.isText(c) && !this.isBracket(c)) continue;
            cArray2[n++] = c;
        }
        cArray2[n++] = 64;
        return cArray2;
    }

    public ExpressionNode getTree() {
        if (this.root == null) {
            this.cc = this.parse();
            this.root = this.S();
            if (!this.isEndOfExpression(this.cc.getToken())) {
                throw new ParseError("Expecting operator or end of input", this.inp_cur);
            }
            return this.root;
        }
        return this.root;
    }

    private boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    private boolean isOperator(char c) {
        for (int i = 0; i < OperatorNode.OPERATIONS.length; ++i) {
            if (c != OperatorNode.OPERATIONS[i]) continue;
            return true;
        }
        return false;
    }

    private boolean isText(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    private boolean isBracket(char c) {
        return c == '(' || c == ')';
    }

    private boolean isEndOfExpression(char c) {
        return c == '@';
    }

    private Element parse() {
        if (this.detectImplicitMult()) {
            return new Element('*');
        }
        if (this.isOperator(this.input[this.inp_cur]) || this.isBracket(this.input[this.inp_cur]) || this.isEndOfExpression(this.input[this.inp_cur])) {
            return new Element(this.input[this.inp_cur++]);
        }
        if (this.isNumber(this.input[this.inp_cur])) {
            double d;
            int n = this.inp_cur++;
            while (this.isNumber(this.input[this.inp_cur])) {
                ++this.inp_cur;
            }
            if (Character.toLowerCase(this.input[this.inp_cur]) == 'e') {
                if (this.input[this.inp_cur + 1] == '-' || this.isNumber(this.input[this.inp_cur + 1])) {
                    this.inp_cur += 2;
                }
                while (this.isNumber(this.input[this.inp_cur])) {
                    ++this.inp_cur;
                }
            }
            String string = new String(this.input, n, this.inp_cur - n);
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseError("Invalid number: " + string, this.inp_cur);
            }
            return new Element('n', d);
        }
        if (this.isText(this.input[this.inp_cur])) {
            int n;
            int n2 = this.inp_cur++;
            while (this.isText(this.input[this.inp_cur]) || this.isNumber(this.input[this.inp_cur])) {
                ++this.inp_cur;
            }
            String string = new String(this.input, n2, this.inp_cur - n2);
            String string2 = string.toLowerCase();
            for (n = 0; n < FunctionNode.FUNCTIONS.length; ++n) {
                if (!string2.equals(FunctionNode.FUNCTIONS[n])) continue;
                this.functions.add(FunctionNode.FUNCTIONS[n]);
                return new Element('f', n);
            }
            for (n = 0; n < ConstantNode.CONSTANTS.length; ++n) {
                if (!string2.equals(ConstantNode.CONSTANTS[n])) continue;
                return new Element('n', n);
            }
            this.variables.add(string);
            return new Element('x', string);
        }
        throw new ParseError("Unrecognized identifier", this.inp_cur);
    }

    private boolean detectImplicitMult() {
        if (this.cc != null && this.cc.getToken() == 'n') {
            this.cc = null;
            int n = this.inp_cur;
            Element element = this.parse();
            this.inp_cur = n;
            if (element.getToken() == 'x' || element.getToken() == 'f') {
                return true;
            }
        }
        return false;
    }

    private ExpressionNode S() {
        ExpressionNode expressionNode = this.E();
        while (this.cc.getToken() == '+' || this.cc.getToken() == '-') {
            char c = this.cc.getToken();
            this.cc = this.parse();
            expressionNode = new OperatorNode(expressionNode, this.E(), c);
        }
        return expressionNode;
    }

    private ExpressionNode E() {
        ExpressionNode expressionNode = this.G();
        while (this.cc.getToken() == '*') {
            this.cc = this.parse();
            expressionNode = new OperatorNode(expressionNode, this.G(), '*');
        }
        return expressionNode;
    }

    private ExpressionNode G() {
        ExpressionNode expressionNode = this.H();
        while (this.cc.getToken() == '/') {
            this.cc = this.parse();
            expressionNode = new OperatorNode(expressionNode, this.H(), '/');
        }
        return expressionNode;
    }

    private ExpressionNode H() {
        ExpressionNode expressionNode = this.T();
        while (this.cc.getToken() == '%') {
            this.cc = this.parse();
            expressionNode = new OperatorNode(expressionNode, this.T(), '%');
        }
        return expressionNode;
    }

    private ExpressionNode T() {
        if (this.cc.getToken() == '-') {
            this.cc = this.parse();
            return new FunctionNode(this.F(), "-");
        }
        return this.F();
    }

    private ExpressionNode F() {
        ExpressionNode expressionNode = this.U();
        if (this.cc.getToken() == '^') {
            this.cc = this.parse();
            return new OperatorNode(expressionNode, this.F(), '^');
        }
        return expressionNode;
    }

    private ExpressionNode U() {
        switch (this.cc.getToken()) {
            case 'n': {
                double d = this.cc.number;
                int n = this.cc.position;
                this.cc = this.parse();
                if (n >= 0) {
                    return new ConstantNode(n);
                }
                return new ConstantNode(d);
            }
            case 'x': {
                String string = this.cc.name;
                this.cc = this.parse();
                return new VariableNode(string, this.error);
            }
            case '(': {
                this.cc = this.parse();
                ExpressionNode expressionNode = this.S();
                if (this.cc.getToken() == ')') {
                    this.cc = this.parse();
                    return expressionNode;
                }
                throw new ParseError("Semantic Error, expected ')'", this.inp_cur);
            }
            case 'f': {
                int n = this.cc.position;
                this.cc = this.parse();
                if (this.cc.getToken() != '(') {
                    throw new ParseError("Semantic Error, expected '('", this.inp_cur);
                }
                this.cc = this.parse();
                ExpressionNode expressionNode = this.S();
                if (this.cc.getToken() != ')') {
                    throw new ParseError("Semantic Error, expected ')'", this.inp_cur);
                }
                this.cc = this.parse();
                return new FunctionNode(expressionNode, n);
            }
        }
        throw new ParseError("Semantic Error, expected function or variable or constant or '('", this.inp_cur);
    }

    public void setVariable(String string, double d) {
        this.getTree();
        this.root.setVariable(string, d);
    }

    public double getValue() {
        this.getTree();
        return this.root.getValue();
    }

    public String getExpression() {
        this.getTree();
        return this.root.toString();
    }

    public HashSet<String> getParsedFunctions() {
        this.getTree();
        return this.functions;
    }

    public HashSet<String> getParsedVariables() {
        this.getTree();
        return this.variables;
    }

    public String getInputString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.input.length && this.input[i] != '@'; ++i) {
            stringBuffer.append(this.input[i]);
        }
        return stringBuffer.toString();
    }

    private class Element {
        private char token;
        public double number = Double.NaN;
        public int position = -1;
        public String name = null;

        public Element(char c) {
            this.token = c;
        }

        public Element(char c, double d) {
            this.token = c;
            this.number = d;
        }

        public Element(char c, String string) {
            this.token = c;
            this.name = string;
        }

        public Element(char c, int n) {
            this.token = c;
            this.position = n;
        }

        public char getToken() {
            return this.token;
        }
    }
}

