/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util;

import us.eunoians.mcrpg.util.ExpressionNode;

public class OperatorNode
implements ExpressionNode {
    public static final char[] OPERATIONS = new char[]{'+', '-', '*', '/', '%', '^'};
    protected ExpressionNode left;
    protected ExpressionNode right;
    protected char operation;
    protected ExpressionNode[] children;

    public OperatorNode(ExpressionNode expressionNode, ExpressionNode expressionNode2, char c) {
        this.operation = c;
        this.left = expressionNode;
        this.right = expressionNode2;
        this.children = new ExpressionNode[]{expressionNode, expressionNode2};
    }

    @Override
    public int count() {
        return 1 + this.left.count() + this.right.count();
    }

    @Override
    public int getDepth() {
        return 1 + Math.max(this.left.getDepth(), this.right.getDepth());
    }

    @Override
    public String getSubtype() {
        return Character.toString(this.operation);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public double getValue() {
        switch (this.operation) {
            case '+': {
                return this.left.getValue() + this.right.getValue();
            }
            case '-': {
                return this.left.getValue() - this.right.getValue();
            }
            case '*': {
                return this.left.getValue() * this.right.getValue();
            }
            case '/': {
                return this.left.getValue() / this.right.getValue();
            }
            case '%': {
                return this.left.getValue() % this.right.getValue();
            }
            case '^': {
                return Math.pow(this.left.getValue(), this.right.getValue());
            }
        }
        return 0.0;
    }

    @Override
    public void setVariable(String string, double d) {
        this.left.setVariable(string, d);
        this.right.setVariable(string, d);
    }

    @Override
    public ExpressionNode[] getChildrenNodes() {
        return this.children;
    }

    @Override
    public Object clone() {
        ExpressionNode expressionNode = (ExpressionNode)this.left.clone();
        ExpressionNode expressionNode2 = (ExpressionNode)this.right.clone();
        return new OperatorNode(expressionNode, expressionNode2, this.operation);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.needBrackets(this.left, true)) {
            stringBuffer.append('(');
        }
        stringBuffer.append(this.left);
        if (this.needBrackets(this.left, true)) {
            stringBuffer.append(')');
        }
        stringBuffer.append(this.getSubtype());
        if (this.needBrackets(this.right, false)) {
            stringBuffer.append('(');
        }
        stringBuffer.append(this.right);
        if (this.needBrackets(this.right, false)) {
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    private boolean needBrackets(ExpressionNode expressionNode, boolean bl) {
        char c = expressionNode.getSubtype().charAt(0);
        if (expressionNode.getType() == 0 || expressionNode.getType() == 1) {
            return false;
        }
        if (expressionNode.getType() == 3) {
            return c == '-';
        }
        switch (this.getSubtype().charAt(0)) {
            case '+': {
                return false;
            }
            case '-': {
                return (c == '+' || c == '-') && !bl;
            }
            case '*': {
                return c == '+' || c == '-' || c == '%';
            }
            case '/': {
                return c != '*' || !bl;
            }
            case '%': {
                return true;
            }
            case '^': {
                return true;
            }
        }
        return true;
    }
}

