/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.util;

import us.eunoians.mcrpg.util.ExpressionNode;

public class ConstantNode
implements ExpressionNode {
    public static final String[] CONSTANTS = new String[]{"pi", "e"};
    public static final double[] VALUES = new double[]{Math.PI, Math.E};
    protected double constant;
    protected String name;
    protected ExpressionNode[] children = new ExpressionNode[0];

    public ConstantNode(double d) {
        this.constant = d;
        this.name = null;
    }

    public ConstantNode(String string) {
        this.name = string;
        for (int i = 0; i < CONSTANTS.length; ++i) {
            if (!CONSTANTS[i].equals(string)) continue;
            this.constant = VALUES[i];
            return;
        }
        throw new IllegalArgumentException("Unrecognized constant");
    }

    public ConstantNode(int n) {
        this.name = CONSTANTS[n];
        this.constant = VALUES[n];
    }

    @Override
    public int count() {
        return 1;
    }

    @Override
    public int getDepth() {
        return 1;
    }

    @Override
    public String getSubtype() {
        if (Math.floor(this.constant) == this.constant) {
            return Long.toString(Math.round(this.constant));
        }
        return Double.toString(this.constant);
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public double getValue() {
        return this.constant;
    }

    @Override
    public void setVariable(String string, double d) {
    }

    @Override
    public ExpressionNode[] getChildrenNodes() {
        return this.children;
    }

    @Override
    public Object clone() {
        return new ConstantNode(this.constant);
    }

    @Override
    public String toString() {
        if (this.name == null) {
            return this.getSubtype();
        }
        return this.name;
    }
}

