/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.types;

import java.io.File;
import java.util.Arrays;
import org.bukkit.configuration.file.YamlConfiguration;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.abilities.archery.BlessingOfApollo;
import us.eunoians.mcrpg.abilities.archery.BlessingOfArtemis;
import us.eunoians.mcrpg.abilities.archery.Combo;
import us.eunoians.mcrpg.abilities.archery.CurseOfHades;
import us.eunoians.mcrpg.abilities.archery.Puncture;
import us.eunoians.mcrpg.abilities.archery.TippedArrows;
import us.eunoians.mcrpg.abilities.axes.AresBlessing;
import us.eunoians.mcrpg.abilities.axes.BloodFrenzy;
import us.eunoians.mcrpg.abilities.axes.CripplingBlow;
import us.eunoians.mcrpg.abilities.axes.HeavyStrike;
import us.eunoians.mcrpg.abilities.axes.SharperAxe;
import us.eunoians.mcrpg.abilities.axes.WhirlwindStrike;
import us.eunoians.mcrpg.abilities.excavation.BuriedTreasure;
import us.eunoians.mcrpg.abilities.excavation.FrenzyDig;
import us.eunoians.mcrpg.abilities.excavation.HandDigging;
import us.eunoians.mcrpg.abilities.excavation.LargerSpade;
import us.eunoians.mcrpg.abilities.excavation.ManaDeposit;
import us.eunoians.mcrpg.abilities.excavation.PansShrine;
import us.eunoians.mcrpg.abilities.fishing.MagicTouch;
import us.eunoians.mcrpg.abilities.fishing.PoseidonsFavor;
import us.eunoians.mcrpg.abilities.fishing.SeaGodsBlessing;
import us.eunoians.mcrpg.abilities.fishing.Shake;
import us.eunoians.mcrpg.abilities.fishing.SunkenArmory;
import us.eunoians.mcrpg.abilities.fishing.SuperRod;
import us.eunoians.mcrpg.abilities.fitness.BulletProof;
import us.eunoians.mcrpg.abilities.fitness.DivineEscape;
import us.eunoians.mcrpg.abilities.fitness.Dodge;
import us.eunoians.mcrpg.abilities.fitness.IronMuscles;
import us.eunoians.mcrpg.abilities.fitness.RunnersDiet;
import us.eunoians.mcrpg.abilities.fitness.ThickSkin;
import us.eunoians.mcrpg.abilities.herbalism.DiamondFlowers;
import us.eunoians.mcrpg.abilities.herbalism.FarmersDiet;
import us.eunoians.mcrpg.abilities.herbalism.MassHarvest;
import us.eunoians.mcrpg.abilities.herbalism.NaturesWrath;
import us.eunoians.mcrpg.abilities.herbalism.PansBlessing;
import us.eunoians.mcrpg.abilities.herbalism.Replanting;
import us.eunoians.mcrpg.abilities.mining.BlastMining;
import us.eunoians.mcrpg.abilities.mining.ItsATriple;
import us.eunoians.mcrpg.abilities.mining.OreScanner;
import us.eunoians.mcrpg.abilities.mining.RemoteTransfer;
import us.eunoians.mcrpg.abilities.mining.RicherOres;
import us.eunoians.mcrpg.abilities.mining.SuperBreaker;
import us.eunoians.mcrpg.abilities.sorcery.CircesProtection;
import us.eunoians.mcrpg.abilities.sorcery.CircesRecipes;
import us.eunoians.mcrpg.abilities.sorcery.CircesShrine;
import us.eunoians.mcrpg.abilities.sorcery.HadesDomain;
import us.eunoians.mcrpg.abilities.sorcery.ManaAffinity;
import us.eunoians.mcrpg.abilities.sorcery.PotionAffinity;
import us.eunoians.mcrpg.abilities.swords.BleedPlus;
import us.eunoians.mcrpg.abilities.swords.DeeperWound;
import us.eunoians.mcrpg.abilities.swords.RageSpike;
import us.eunoians.mcrpg.abilities.swords.SerratedStrikes;
import us.eunoians.mcrpg.abilities.swords.TaintedBlade;
import us.eunoians.mcrpg.abilities.swords.Vampire;
import us.eunoians.mcrpg.abilities.unarmed.Berserk;
import us.eunoians.mcrpg.abilities.unarmed.DenseImpact;
import us.eunoians.mcrpg.abilities.unarmed.Disarm;
import us.eunoians.mcrpg.abilities.unarmed.IronArm;
import us.eunoians.mcrpg.abilities.unarmed.SmitingFist;
import us.eunoians.mcrpg.abilities.unarmed.TighterGrip;
import us.eunoians.mcrpg.abilities.woodcutting.DemetersShrine;
import us.eunoians.mcrpg.abilities.woodcutting.DryadsGift;
import us.eunoians.mcrpg.abilities.woodcutting.HeavySwing;
import us.eunoians.mcrpg.abilities.woodcutting.HesperidesApples;
import us.eunoians.mcrpg.abilities.woodcutting.NymphsVitality;
import us.eunoians.mcrpg.abilities.woodcutting.TemporalHarvest;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.types.AbilityType;
import us.eunoians.mcrpg.types.GenericAbility;
import us.eunoians.mcrpg.types.Skills;

public enum UnlockedAbilities implements GenericAbility
{
    ARES_BLESSING("AresBlessing", AresBlessing.class, AbilityType.ACTIVE, FileManager.Files.AXES_CONFIG, true),
    BERSERK("Berserk", Berserk.class, AbilityType.ACTIVE, FileManager.Files.UNARMED_CONFIG, true),
    BLAST_MINING("BlastMining", BlastMining.class, AbilityType.ACTIVE, FileManager.Files.MINING_CONFIG, true),
    BLEED_PLUS("Bleed+", BleedPlus.class, AbilityType.PASSIVE, FileManager.Files.SWORDS_CONFIG, false),
    BLESSING_OF_APOLLO("BlessingOfApollo", BlessingOfApollo.class, AbilityType.ACTIVE, FileManager.Files.ARCHERY_CONFIG, true),
    BLESSING_OF_ARTEMIS("BlessingOfArtemis", BlessingOfArtemis.class, AbilityType.ACTIVE, FileManager.Files.ARCHERY_CONFIG, true),
    BLOOD_FRENZY("BloodFrenzy", BloodFrenzy.class, AbilityType.PASSIVE, FileManager.Files.AXES_CONFIG, false),
    BULLET_PROOF("BulletProof", BulletProof.class, AbilityType.PASSIVE, FileManager.Files.FITNESS_CONFIG, false),
    BURIED_TREASURE("BuriedTreasure", BuriedTreasure.class, AbilityType.PASSIVE, FileManager.Files.EXCAVATION_CONFIG, false),
    CIRCES_PROTECTION("CircesProtection", CircesProtection.class, AbilityType.PASSIVE, FileManager.Files.SORCERY_CONFIG, false),
    CIRCES_RECIPES("CircesRecipes", CircesRecipes.class, AbilityType.PASSIVE, FileManager.Files.SORCERY_CONFIG, false),
    CIRCES_SHRINE("CircesShrine", CircesShrine.class, AbilityType.ACTIVE, FileManager.Files.SORCERY_CONFIG, false),
    COMBO("Combo", Combo.class, AbilityType.PASSIVE, FileManager.Files.ARCHERY_CONFIG, false),
    CRIPPLING_BLOW("CripplingBlow", CripplingBlow.class, AbilityType.ACTIVE, FileManager.Files.AXES_CONFIG, true),
    CURSE_OF_HADES("CurseOfHades", CurseOfHades.class, AbilityType.ACTIVE, FileManager.Files.ARCHERY_CONFIG, true),
    DEEPER_WOUND("DeeperWound", DeeperWound.class, AbilityType.PASSIVE, FileManager.Files.SWORDS_CONFIG, false),
    DEMETERS_SHRINE("DemetersShrine", DemetersShrine.class, AbilityType.ACTIVE, FileManager.Files.WOODCUTTING_CONFIG, true),
    DENSE_IMPACT("DenseImpact", DenseImpact.class, AbilityType.ACTIVE, FileManager.Files.UNARMED_CONFIG, true),
    DIAMOND_FLOWERS("DiamondFlowers", DiamondFlowers.class, AbilityType.PASSIVE, FileManager.Files.HERBALISM_CONFIG, false),
    DISARM("Disarm", Disarm.class, AbilityType.PASSIVE, FileManager.Files.UNARMED_CONFIG, false),
    DIVINE_ESCAPE("DivineEscape", DivineEscape.class, AbilityType.PASSIVE, FileManager.Files.FITNESS_CONFIG, true),
    DODGE("Dodge", Dodge.class, AbilityType.PASSIVE, FileManager.Files.FITNESS_CONFIG, false),
    DRYADS_GIFT("DryadsGift", DryadsGift.class, AbilityType.PASSIVE, FileManager.Files.WOODCUTTING_CONFIG, false),
    FARMERS_DIET("FarmersDiet", FarmersDiet.class, AbilityType.PASSIVE, FileManager.Files.HERBALISM_CONFIG, false),
    FRENZY_DIG("FrenzyDig", FrenzyDig.class, AbilityType.ACTIVE, FileManager.Files.EXCAVATION_CONFIG, true),
    HADES_DOMAIN("HadesDomain", HadesDomain.class, AbilityType.PASSIVE, FileManager.Files.SORCERY_CONFIG, false),
    HAND_DIGGING("HandDigging", HandDigging.class, AbilityType.ACTIVE, FileManager.Files.EXCAVATION_CONFIG, true),
    HEAVY_STRIKE("HeavyStrike", HeavyStrike.class, AbilityType.PASSIVE, FileManager.Files.AXES_CONFIG, false),
    HEAVY_SWING("HeavySwing", HeavySwing.class, AbilityType.PASSIVE, FileManager.Files.WOODCUTTING_CONFIG, false),
    HESPERIDES_APPLES("HesperidesApples", HesperidesApples.class, AbilityType.ACTIVE, FileManager.Files.WOODCUTTING_CONFIG, true),
    IRON_ARM("IronArm", IronArm.class, AbilityType.PASSIVE, FileManager.Files.UNARMED_CONFIG, false),
    IRON_MUSCLES("IronMuscles", IronMuscles.class, AbilityType.PASSIVE, FileManager.Files.FITNESS_CONFIG, false),
    ITS_A_TRIPLE("ItsATriple", ItsATriple.class, AbilityType.PASSIVE, FileManager.Files.MINING_CONFIG, false),
    LARGER_SPADE("LargerSpade", LargerSpade.class, AbilityType.PASSIVE, FileManager.Files.EXCAVATION_CONFIG, false),
    MAGIC_TOUCH("MagicTouch", MagicTouch.class, AbilityType.PASSIVE, FileManager.Files.FISHING_CONFIG, false),
    MANA_AFFINITY("ManaAffinity", ManaAffinity.class, AbilityType.PASSIVE, FileManager.Files.SORCERY_CONFIG, false),
    MANA_DEPOSIT("ManaDeposit", ManaDeposit.class, AbilityType.PASSIVE, FileManager.Files.EXCAVATION_CONFIG, false),
    MASS_HARVEST("MassHarvest", MassHarvest.class, AbilityType.ACTIVE, FileManager.Files.HERBALISM_CONFIG, true),
    NATURES_WRATH("NaturesWrath", NaturesWrath.class, AbilityType.ACTIVE, FileManager.Files.HERBALISM_CONFIG, false),
    NYMPHS_VITALITY("NymphsVitality", NymphsVitality.class, AbilityType.PASSIVE, FileManager.Files.WOODCUTTING_CONFIG, false),
    ORE_SCANNER("OreScanner", OreScanner.class, AbilityType.ACTIVE, FileManager.Files.MINING_CONFIG, true),
    PANS_BLESSING("PansBlessing", PansBlessing.class, AbilityType.ACTIVE, FileManager.Files.HERBALISM_CONFIG, true),
    PANS_SHRINE("PansShrine", PansShrine.class, AbilityType.ACTIVE, FileManager.Files.EXCAVATION_CONFIG, true),
    POSEIDONS_FAVOR("PoseidonsFavor", PoseidonsFavor.class, AbilityType.PASSIVE, FileManager.Files.FISHING_CONFIG, false),
    POTION_AFFINITY("PotionAffinity", PotionAffinity.class, AbilityType.PASSIVE, FileManager.Files.SORCERY_CONFIG, false),
    PUNCTURE("Puncture", Puncture.class, AbilityType.PASSIVE, FileManager.Files.ARCHERY_CONFIG, false),
    RAGE_SPIKE("RageSpike", RageSpike.class, AbilityType.ACTIVE, FileManager.Files.SWORDS_CONFIG, true),
    REMOTE_TRANSFER("RemoteTransfer", RemoteTransfer.class, AbilityType.PASSIVE, FileManager.Files.MINING_CONFIG, false),
    REPLANTING("Replanting", Replanting.class, AbilityType.PASSIVE, FileManager.Files.HERBALISM_CONFIG, false),
    RICHER_ORES("RicherOres", RicherOres.class, AbilityType.PASSIVE, FileManager.Files.MINING_CONFIG, false),
    RUNNERS_DIET("RunnersDiet", RunnersDiet.class, AbilityType.PASSIVE, FileManager.Files.FITNESS_CONFIG, false),
    SEA_GODS_BLESSING("SeaGodsBlessing", SeaGodsBlessing.class, AbilityType.PASSIVE, FileManager.Files.FISHING_CONFIG, false),
    SERRATED_STRIKES("SerratedStrikes", SerratedStrikes.class, AbilityType.ACTIVE, FileManager.Files.SWORDS_CONFIG, true),
    SHAKE("Shake", Shake.class, AbilityType.PASSIVE, FileManager.Files.FISHING_CONFIG, false),
    SHARPER_AXE("SharperAxe", SharperAxe.class, AbilityType.PASSIVE, FileManager.Files.AXES_CONFIG, false),
    SMITING_FIST("SmitingFist", SmitingFist.class, AbilityType.ACTIVE, FileManager.Files.UNARMED_CONFIG, true),
    SUNKEN_ARMORY("SunkenArmory", SunkenArmory.class, AbilityType.PASSIVE, FileManager.Files.FISHING_CONFIG, false),
    SUPER_BREAKER("SuperBreaker", SuperBreaker.class, AbilityType.ACTIVE, FileManager.Files.MINING_CONFIG, true),
    SUPER_ROD("SuperRod", SuperRod.class, AbilityType.PASSIVE, FileManager.Files.FISHING_CONFIG, false),
    TAINTED_BLADE("TaintedBlade", TaintedBlade.class, AbilityType.ACTIVE, FileManager.Files.SWORDS_CONFIG, true),
    TEMPORAL_HARVEST("TemporalHarvest", TemporalHarvest.class, AbilityType.ACTIVE, FileManager.Files.WOODCUTTING_CONFIG, true),
    THICK_SKIN("ThickSkin", ThickSkin.class, AbilityType.PASSIVE, FileManager.Files.FITNESS_CONFIG, false),
    TIGHTER_GRIP("TighterGrip", TighterGrip.class, AbilityType.PASSIVE, FileManager.Files.UNARMED_CONFIG, false),
    TIPPED_ARROWS("TippedArrows", TippedArrows.class, AbilityType.PASSIVE, FileManager.Files.ARCHERY_CONFIG, false),
    VAMPIRE("Vampire", Vampire.class, AbilityType.PASSIVE, FileManager.Files.SWORDS_CONFIG, false),
    WHIRLWIND_STRIKE("WhirlwindStrike", WhirlwindStrike.class, AbilityType.ACTIVE, FileManager.Files.AXES_CONFIG, true);

    private String name;
    private Class<? extends BaseAbility> clazz;
    private AbilityType abilityType;
    private FileManager.Files file;
    private boolean cooldown;

    private UnlockedAbilities(String string2, Class<? extends BaseAbility> clazz, AbilityType abilityType, FileManager.Files files, boolean bl) {
        this.name = string2;
        this.clazz = clazz;
        this.abilityType = abilityType;
        this.file = files;
        this.cooldown = bl;
    }

    @Override
    public Skills getSkill() {
        return Arrays.stream(Skills.values()).filter(skills -> Arrays.asList(skills.getUnlockedAbilities()).contains(this)).findFirst().orElse(null);
    }

    public boolean isPassiveAbility() {
        return this.abilityType.equals((Object)AbilityType.PASSIVE);
    }

    @Override
    public boolean isEnabled() {
        return this.file.getFile().getBoolean("EnabledAbilities." + this.name);
    }

    public static UnlockedAbilities fromString(String string) {
        if (string.contains("bleed") && string.contains("plus")) {
            return BLEED_PLUS;
        }
        return Arrays.stream(UnlockedAbilities.values()).filter(unlockedAbilities -> unlockedAbilities.getName().equalsIgnoreCase(string)).findAny().orElse(null);
    }

    public int getUnlockLevel() {
        return this.file.getFile().getInt("UnlockLevelForAbility." + this.name);
    }

    public boolean usePerm() {
        return YamlConfiguration.loadConfiguration((File)new File(McRPG.getInstance().getDataFolder(), File.separator + "skills" + File.separator + this.getSkill().getName() + ".yml")).getBoolean("UsePermsForAbility." + this.name);
    }

    public int getMaxTier() {
        return this.file.getFile().getInt(this.name + "Config.TierAmount");
    }

    public int tierUnlockLevel(int n) {
        return this.file.getFile().getInt(this.name + "Config.TierUpgrade.Tier" + Methods.convertToNumeral(n));
    }

    public static boolean isAbility(String string) {
        return Arrays.stream(UnlockedAbilities.values()).anyMatch(unlockedAbilities -> unlockedAbilities.getName().equalsIgnoreCase(string));
    }

    public String getDisplayName() {
        char[] cArray = this.name.toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (char c : cArray) {
            if (!bl) {
                if (Character.isUpperCase(c)) {
                    stringBuilder.append(" ");
                }
            } else {
                bl = false;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public String getLocalizedName() {
        return "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? extends BaseAbility> getClazz() {
        return this.clazz;
    }

    @Override
    public AbilityType getAbilityType() {
        return this.abilityType;
    }

    @Override
    public boolean isCooldown() {
        return this.cooldown;
    }
}

