/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.types;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.skills.Archery;
import us.eunoians.mcrpg.skills.Axes;
import us.eunoians.mcrpg.skills.Excavation;
import us.eunoians.mcrpg.skills.Fishing;
import us.eunoians.mcrpg.skills.Fitness;
import us.eunoians.mcrpg.skills.Herbalism;
import us.eunoians.mcrpg.skills.Mining;
import us.eunoians.mcrpg.skills.Skill;
import us.eunoians.mcrpg.skills.Sorcery;
import us.eunoians.mcrpg.skills.Swords;
import us.eunoians.mcrpg.skills.Unarmed;
import us.eunoians.mcrpg.skills.Woodcutting;
import us.eunoians.mcrpg.types.DefaultAbilities;
import us.eunoians.mcrpg.types.GenericAbility;
import us.eunoians.mcrpg.types.UnlockedAbilities;
import us.eunoians.mcrpg.util.Parser;

public enum Skills {
    ARCHERY("Archery", Archery.class, DefaultAbilities.DAZE, UnlockedAbilities.COMBO, UnlockedAbilities.PUNCTURE, UnlockedAbilities.TIPPED_ARROWS, UnlockedAbilities.BLESSING_OF_APOLLO, UnlockedAbilities.BLESSING_OF_ARTEMIS, UnlockedAbilities.CURSE_OF_HADES),
    AXES("Axes", Axes.class, DefaultAbilities.SHRED, UnlockedAbilities.HEAVY_STRIKE, UnlockedAbilities.BLOOD_FRENZY, UnlockedAbilities.SHARPER_AXE, UnlockedAbilities.WHIRLWIND_STRIKE, UnlockedAbilities.ARES_BLESSING, UnlockedAbilities.CRIPPLING_BLOW),
    EXCAVATION("Excavation", Excavation.class, DefaultAbilities.EXTRACTION, UnlockedAbilities.BURIED_TREASURE, UnlockedAbilities.LARGER_SPADE, UnlockedAbilities.MANA_DEPOSIT, UnlockedAbilities.HAND_DIGGING, UnlockedAbilities.FRENZY_DIG, UnlockedAbilities.PANS_SHRINE),
    FISHING("Fishing", Fishing.class, DefaultAbilities.GREAT_ROD, UnlockedAbilities.POSEIDONS_FAVOR, UnlockedAbilities.MAGIC_TOUCH, UnlockedAbilities.SEA_GODS_BLESSING, UnlockedAbilities.SUNKEN_ARMORY, UnlockedAbilities.SHAKE, UnlockedAbilities.SUPER_ROD),
    FITNESS("Fitness", Fitness.class, DefaultAbilities.ROLL, UnlockedAbilities.THICK_SKIN, UnlockedAbilities.BULLET_PROOF, UnlockedAbilities.DODGE, UnlockedAbilities.IRON_MUSCLES, UnlockedAbilities.RUNNERS_DIET, UnlockedAbilities.DIVINE_ESCAPE),
    HERBALISM("Herbalism", Herbalism.class, DefaultAbilities.TOO_MANY_PLANTS, UnlockedAbilities.REPLANTING, UnlockedAbilities.FARMERS_DIET, UnlockedAbilities.DIAMOND_FLOWERS, UnlockedAbilities.MASS_HARVEST, UnlockedAbilities.PANS_BLESSING, UnlockedAbilities.NATURES_WRATH),
    MINING("Mining", Mining.class, DefaultAbilities.DOUBLE_DROP, UnlockedAbilities.RICHER_ORES, UnlockedAbilities.ITS_A_TRIPLE, UnlockedAbilities.REMOTE_TRANSFER, UnlockedAbilities.SUPER_BREAKER, UnlockedAbilities.BLAST_MINING, UnlockedAbilities.ORE_SCANNER),
    SORCERY("Sorcery", Sorcery.class, DefaultAbilities.HASTY_BREW, UnlockedAbilities.CIRCES_RECIPES, UnlockedAbilities.POTION_AFFINITY, UnlockedAbilities.MANA_AFFINITY, UnlockedAbilities.CIRCES_PROTECTION, UnlockedAbilities.HADES_DOMAIN, UnlockedAbilities.CIRCES_SHRINE),
    SWORDS("Swords", Swords.class, DefaultAbilities.BLEED, UnlockedAbilities.DEEPER_WOUND, UnlockedAbilities.BLEED_PLUS, UnlockedAbilities.VAMPIRE, UnlockedAbilities.SERRATED_STRIKES, UnlockedAbilities.RAGE_SPIKE, UnlockedAbilities.TAINTED_BLADE),
    UNARMED("Unarmed", Unarmed.class, DefaultAbilities.STICKY_FINGERS, UnlockedAbilities.TIGHTER_GRIP, UnlockedAbilities.DISARM, UnlockedAbilities.IRON_ARM, UnlockedAbilities.BERSERK, UnlockedAbilities.SMITING_FIST, UnlockedAbilities.DENSE_IMPACT),
    WOODCUTTING("Woodcutting", Woodcutting.class, DefaultAbilities.EXTRA_LUMBER, UnlockedAbilities.HEAVY_SWING, UnlockedAbilities.NYMPHS_VITALITY, UnlockedAbilities.DRYADS_GIFT, UnlockedAbilities.HESPERIDES_APPLES, UnlockedAbilities.TEMPORAL_HARVEST, UnlockedAbilities.DEMETERS_SHRINE);

    private String name;
    private Class<? extends Skill> clazz;
    private DefaultAbilities defaultAbility;
    private UnlockedAbilities[] unlockedAbilities;

    private Skills(String string2, Class<? extends Skill> clazz, DefaultAbilities defaultAbilities, UnlockedAbilities ... unlockedAbilitiesArray) {
        this.name = string2;
        this.clazz = clazz;
        this.defaultAbility = defaultAbilities;
        this.unlockedAbilities = unlockedAbilitiesArray;
    }

    public Parser getExpEquation() {
        FileManager.Files files2 = Arrays.stream(FileManager.Files.values()).filter(files -> files.getFileName().contains(this.name.toLowerCase())).findFirst().orElse(FileManager.Files.SWORDS_CONFIG);
        return new Parser(McRPG.getInstance().getFileManager().getFile(files2).getString("ExpEquation"));
    }

    public String getDisplayName() {
        return McRPG.getInstance().getLangFile().getString("SkillNames." + this.name);
    }

    public boolean isEnabled() {
        FileManager.Files files2 = Arrays.stream(FileManager.Files.values()).filter(files -> files.getFileName().contains(this.name.toLowerCase())).findFirst().orElse(FileManager.Files.SWORDS_CONFIG);
        return McRPG.getInstance().getFileManager().getFile(files2).getBoolean(this.name + "Enabled");
    }

    public List<GenericAbility> getAllAbilities() {
        return Stream.concat(Stream.of(this.defaultAbility), Arrays.stream(this.unlockedAbilities)).collect(Collectors.toList());
    }

    public List<String> getEnabledAbilities() {
        FileManager.Files files2 = Arrays.stream(FileManager.Files.values()).filter(files -> files.getFileName().contains(this.name.toLowerCase())).findFirst().orElse(FileManager.Files.SWORDS_CONFIG);
        return McRPG.getInstance().getFileManager().getFile(files2).getConfigurationSection("EnabledAbilities").getKeys(false).stream().filter(string -> files2.getFile().getBoolean("EnabledAbilities." + string)).collect(Collectors.toList());
    }

    public static Skills fromString(String string) {
        return Arrays.stream(Skills.values()).filter(skills -> skills.getDisplayName().equalsIgnoreCase(string) || skills.getName().equalsIgnoreCase(string)).findAny().orElse(null);
    }

    public static boolean isSkill(String string) {
        return Arrays.stream(Skills.values()).map(skills -> skills.getName().toLowerCase()).collect(Collectors.toList()).contains(string.toLowerCase()) || Arrays.stream(Skills.values()).map(skills -> skills.getDisplayName().toLowerCase()).collect(Collectors.toList()).contains(string.toLowerCase());
    }

    public boolean usePerm() {
        FileManager.Files files2 = Arrays.stream(FileManager.Files.values()).filter(files -> files.getFileName().contains(this.name.toLowerCase())).findFirst().orElse(FileManager.Files.SWORDS_CONFIG);
        return McRPG.getInstance().getFileManager().getFile(files2).getBoolean("RequirePermission", false);
    }

    public int getMaxLevel() {
        FileManager.Files files2 = Arrays.stream(FileManager.Files.values()).filter(files -> files.getFileName().contains(this.name.toLowerCase())).findFirst().orElse(FileManager.Files.SWORDS_CONFIG);
        return files2.getFile().getInt("MaxLevel");
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Skill> getClazz() {
        return this.clazz;
    }

    public DefaultAbilities getDefaultAbility() {
        return this.defaultAbility;
    }

    public UnlockedAbilities[] getUnlockedAbilities() {
        return this.unlockedAbilities;
    }
}

