/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.types;

import java.util.Arrays;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;

public enum PartyUpgrades {
    MEMBER_COUNT("Member Count"),
    EXP_SHARE_RANGE("Exp Share Range"),
    EXP_SHARE_AMOUNT("Exp Share Amount"),
    PRIVATE_BANK_SIZE("Private Bank Size");

    private String name;

    private PartyUpgrades(String string2) {
        this.name = string2;
    }

    public static PartyUpgrades getPartyUpgrades(String string) {
        return Arrays.stream(PartyUpgrades.values()).filter(partyUpgrades -> partyUpgrades.getName().replace(" ", "").equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public static int getMaxTier(PartyUpgrades partyUpgrades) {
        switch (partyUpgrades) {
            case MEMBER_COUNT: {
                return PartyUpgrades.getMaxMemberUpgradeTier();
            }
            case EXP_SHARE_RANGE: {
                return PartyUpgrades.getMaxExpRangeTier();
            }
            case EXP_SHARE_AMOUNT: {
                return PartyUpgrades.getMaxExpShareTier();
            }
            case PRIVATE_BANK_SIZE: {
                return PartyUpgrades.getMaxPrivateBankUpgradeTier();
            }
        }
        return 0;
    }

    public static int getMemberCountAtTier(int n) {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("MemberCountUpgrade.MembersPerTier." + n, 5);
    }

    public static int getMaxMemberUpgradeTier() {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("MemberCountUpgrade.MaxTier", 5);
    }

    public static int getPrivateBankSizeAtTier(int n) {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("PrivateBankSize.SlotsPerTier." + n, 5);
    }

    public static int getMaxPrivateBankUpgradeTier() {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("PrivateBankSize.MaxTier", 5);
    }

    public static double getExpShareRangeAtTier(int n) {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getDouble("ExpShareRange.RangePerTier." + n, 10.0);
    }

    public static int getMaxExpRangeTier() {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("ExpShareRange.MaxTier", 5);
    }

    public static double getExpShareAmountAtTier(int n) {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getDouble("ExpSharePercent.ShareAmountPerTier." + n, 5.0);
    }

    public static int getMaxExpShareTier() {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("ExpSharePercent.MaxTier", 5);
    }

    public static double getExpHolderPercent() {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getDouble("ExpSharePercent.PercentGivenToEarner", 70.0);
    }

    public String getName() {
        return this.name;
    }
}

