/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.types;

import java.util.Arrays;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.abilities.archery.Daze;
import us.eunoians.mcrpg.abilities.axes.Shred;
import us.eunoians.mcrpg.abilities.excavation.Extraction;
import us.eunoians.mcrpg.abilities.fishing.GreatRod;
import us.eunoians.mcrpg.abilities.fitness.Roll;
import us.eunoians.mcrpg.abilities.herbalism.TooManyPlants;
import us.eunoians.mcrpg.abilities.mining.DoubleDrop;
import us.eunoians.mcrpg.abilities.sorcery.HastyBrew;
import us.eunoians.mcrpg.abilities.swords.Bleed;
import us.eunoians.mcrpg.abilities.unarmed.StickyFingers;
import us.eunoians.mcrpg.abilities.woodcutting.ExtraLumber;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.types.AbilityType;
import us.eunoians.mcrpg.types.GenericAbility;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.util.Parser;

public enum DefaultAbilities implements GenericAbility
{
    BLEED("Bleed", Bleed.class, AbilityType.PASSIVE, FileManager.Files.SWORDS_CONFIG),
    DAZE("Daze", Daze.class, AbilityType.PASSIVE, FileManager.Files.ARCHERY_CONFIG),
    DOUBLE_DROP("Double Drop", DoubleDrop.class, AbilityType.PASSIVE, FileManager.Files.MINING_CONFIG),
    STICKY_FINGERS("Sticky Fingers", StickyFingers.class, AbilityType.PASSIVE, FileManager.Files.UNARMED_CONFIG),
    TOO_MANY_PLANTS("Too Many Plants", TooManyPlants.class, AbilityType.PASSIVE, FileManager.Files.HERBALISM_CONFIG),
    EXTRA_LUMBER("Extra Lumber", ExtraLumber.class, AbilityType.PASSIVE, FileManager.Files.WOODCUTTING_CONFIG),
    SHRED("Shred", Shred.class, AbilityType.PASSIVE, FileManager.Files.AXES_CONFIG),
    ROLL("Roll", Roll.class, AbilityType.PASSIVE, FileManager.Files.FITNESS_CONFIG),
    EXTRACTION("Extraction", Extraction.class, AbilityType.PASSIVE, FileManager.Files.EXCAVATION_CONFIG),
    GREAT_ROD("Great Rod", GreatRod.class, AbilityType.PASSIVE, FileManager.Files.FISHING_CONFIG),
    HASTY_BREW("Hasty Brew", HastyBrew.class, AbilityType.PASSIVE, FileManager.Files.SORCERY_CONFIG);

    private String name;
    private Class<? extends BaseAbility> clazz;
    private AbilityType abilityType;
    private FileManager.Files file;
    private boolean cooldown = false;

    private DefaultAbilities(String string2, Class<? extends BaseAbility> clazz, AbilityType abilityType, FileManager.Files files) {
        this.name = string2;
        this.clazz = clazz;
        this.abilityType = abilityType;
        this.file = files;
    }

    @Override
    public Skills getSkill() {
        return Arrays.stream(Skills.values()).filter(skills -> skills.getDefaultAbility().equals(this)).findFirst().orElse(null);
    }

    @Override
    public boolean isEnabled() {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.getSkillFile(this.getSkill())).getBoolean("EnabledAbilities." + this.name.replace(" ", "").replace("_", ""));
    }

    public static DefaultAbilities getSkillsDefaultAbility(Skills skills) {
        return Arrays.stream(DefaultAbilities.values()).filter(defaultAbilities -> defaultAbilities.getSkill().equals((Object)skills)).findFirst().orElse(null);
    }

    public Parser getActivationEquation() {
        return new Parser(McRPG.getInstance().getFileManager().getFile(this.file).getString(this.name.replaceAll(" ", "") + "Config." + this.name.replaceAll(" ", "") + "ChanceEquation"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<? extends BaseAbility> getClazz() {
        return this.clazz;
    }

    @Override
    public AbilityType getAbilityType() {
        return this.abilityType;
    }

    public FileManager.Files getFile() {
        return this.file;
    }

    @Override
    public boolean isCooldown() {
        return this.cooldown;
    }
}

