/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.types;

import java.util.Arrays;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import us.eunoians.mcrpg.McRPG;

public enum BasePotionType {
    WATER("Water", true, "", PotionType.WATER, null),
    AWKWARD("Awkward", true, "", PotionType.AWKWARD, null),
    FAST_DIGGING("Haste", false, "217:192:67", PotionType.UNCRAFTABLE, PotionEffectType.FAST_DIGGING),
    SLOW_DIGGING("Mining Fatigue", false, "74:66:23", PotionType.UNCRAFTABLE, PotionEffectType.SLOW_DIGGING),
    SPEED("Speed", true, "124:175:198", PotionType.SPEED, PotionEffectType.SPEED),
    SLOW("Slowness", true, "90:108:129", PotionType.SLOWNESS, PotionEffectType.SLOW),
    LEAPING("Leaping", true, "34:255:76", PotionType.JUMP, PotionEffectType.JUMP),
    CONFUSION("Nausea", false, "85:29:74", PotionType.UNCRAFTABLE, PotionEffectType.CONFUSION),
    REGENERATION("Regeneration", true, "205:92:171", PotionType.REGEN, PotionEffectType.REGENERATION),
    WATER_BREATHING("Water Breathing", true, "46:82:153", PotionType.WATER_BREATHING, PotionEffectType.WATER_BREATHING),
    INVISIBILITY("Invisibility", true, "127:131:146", PotionType.INVISIBILITY, PotionEffectType.INVISIBILITY),
    BLINDNESS("Blindness", false, "31:31:35", PotionType.UNCRAFTABLE, PotionEffectType.BLINDNESS),
    NIGHT_VISION("Night Vision", true, "31:31:161", PotionType.NIGHT_VISION, PotionEffectType.NIGHT_VISION),
    HUNGER("Hunger", false, "88:118:83", PotionType.UNCRAFTABLE, PotionEffectType.HUNGER),
    SATURATION("Saturation", false, "248:36:35", PotionType.UNCRAFTABLE, PotionEffectType.SATURATION),
    HEAL("Instant Health", true, "248:36:35", PotionType.INSTANT_HEAL, PotionEffectType.HEAL),
    HARM("Instant Damage", true, "67:10:9", PotionType.INSTANT_DAMAGE, PotionEffectType.HARM),
    WITHER("Wither", false, "53:42:39", PotionType.UNCRAFTABLE, PotionEffectType.WITHER),
    HEALTH_BOOST("Health Boost", false, "248:125:35", PotionType.UNCRAFTABLE, PotionEffectType.HEALTH_BOOST),
    ABSORPTION("Absorption", false, "37:82:165", PotionType.UNCRAFTABLE, PotionEffectType.ABSORPTION),
    GLOWING("Glowing", false, "148:160:97", PotionType.UNCRAFTABLE, PotionEffectType.GLOWING),
    LUCK("Luck", false, "51:153:0", PotionType.UNCRAFTABLE, PotionEffectType.LUCK),
    UNLUCK("Unluck", false, "18:98:73", PotionType.UNCRAFTABLE, PotionEffectType.UNLUCK),
    DOLPHINS_GRACE("Dolphins Grace", false, "136:163:190", PotionType.UNCRAFTABLE, PotionEffectType.DOLPHINS_GRACE),
    INCREASE_DAMAGE("Strength", true, "147:36:35", PotionType.STRENGTH, PotionEffectType.INCREASE_DAMAGE),
    WEAKNESS("Weakness", true, "72:77:72", PotionType.WEAKNESS, PotionEffectType.WEAKNESS),
    RESISTANCE("Resistance", false, "153:69:58", PotionType.UNCRAFTABLE, PotionEffectType.DAMAGE_RESISTANCE),
    FIRE_RESISTANCE("Fire Resistance", true, "228:154:58", PotionType.FIRE_RESISTANCE, PotionEffectType.FIRE_RESISTANCE),
    LEVITATION("Levitation", false, "206:255:255", PotionType.UNCRAFTABLE, PotionEffectType.LEVITATION),
    SLOW_FALLING("Slow Falling", true, "255:239:209", PotionType.SLOW_FALLING, PotionEffectType.SLOW_FALLING),
    POISON("Poison", true, "78:147:49", PotionType.POISON, PotionEffectType.POISON);

    private boolean isVanilla;
    private String name;
    private String customColour;
    private PotionType potionType;
    private PotionEffectType effectType;

    private BasePotionType(String string2, boolean bl, String string3, PotionType potionType, PotionEffectType potionEffectType) {
        this.isVanilla = bl;
        this.name = string2;
        this.customColour = string3;
        this.potionType = potionType;
        this.effectType = potionEffectType;
    }

    public String getDisplayName() {
        return McRPG.getInstance().getLangFile().getString("Potions.PotionNames." + this.name.replace(" ", ""), "");
    }

    public String getName() {
        return this.effectType != null ? this.effectType.getName() : (this.potionType == PotionType.WATER ? "WATER" : "AWKWARD");
    }

    public static BasePotionType getFromPotionType(PotionType potionType) {
        if (potionType == PotionType.WATER) {
            return WATER;
        }
        return Arrays.stream(BasePotionType.values()).filter(basePotionType -> basePotionType.getPotionType() == potionType).findFirst().orElse(AWKWARD);
    }

    public static BasePotionType getFromPotionEffect(PotionEffectType potionEffectType) {
        return Arrays.stream(BasePotionType.values()).filter(basePotionType -> basePotionType.getEffectType() != null).filter(basePotionType -> basePotionType.getEffectType().equals((Object)potionEffectType)).findFirst().orElse(AWKWARD);
    }

    public String toString() {
        return "[" + (this.effectType != null ? this.effectType.toString() : "null") + "-" + this.customColour + "-" + (this.potionType != null ? this.potionType.toString() : "null") + "]";
    }

    public boolean isVanilla() {
        return this.isVanilla;
    }

    public String getCustomColour() {
        return this.customColour;
    }

    public PotionType getPotionType() {
        return this.potionType;
    }

    public PotionEffectType getEffectType() {
        return this.effectType;
    }
}

