/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.skills;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.api.displays.ExpDisplayFactory;
import us.eunoians.mcrpg.api.displays.ExpDisplayType;
import us.eunoians.mcrpg.api.displays.GenericDisplay;
import us.eunoians.mcrpg.api.events.mcrpg.McRPGPlayerExpGainEvent;
import us.eunoians.mcrpg.api.events.mcrpg.McRPGPlayerLevelChangeEvent;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.DefaultAbilities;
import us.eunoians.mcrpg.types.DisplayType;
import us.eunoians.mcrpg.types.GainReason;
import us.eunoians.mcrpg.types.GenericAbility;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.util.Parser;

public abstract class Skill {
    private Skills type;
    private int currentLevel;
    private int currentExp;
    private int expToLevel;
    private HashMap<GenericAbility, BaseAbility> abilityMap;
    private McRPGPlayer player;

    public Skill(Skills skills, HashMap<GenericAbility, BaseAbility> hashMap, int n, int n2, McRPGPlayer mcRPGPlayer) {
        this.type = skills;
        this.currentLevel = n;
        this.currentExp = n2;
        this.abilityMap = hashMap;
        this.player = mcRPGPlayer;
        Parser parser = skills.getExpEquation();
        parser.setVariable("skill_level", n);
        parser.setVariable("power_level", mcRPGPlayer.getPowerLevel());
        this.expToLevel = (int)parser.getValue();
    }

    public BaseAbility getAbility(GenericAbility genericAbility) {
        return this.abilityMap.getOrDefault(genericAbility, null);
    }

    public GenericAbility getGenericAbility(String string) {
        return this.abilityMap.keySet().stream().filter(genericAbility -> genericAbility.getName().equalsIgnoreCase(string)).findFirst().orElse(null);
    }

    public BaseAbility getDefaultAbility() {
        return this.getAbility(DefaultAbilities.getSkillsDefaultAbility(this.getType()));
    }

    public Collection<BaseAbility> getAbilities() {
        return this.abilityMap.values();
    }

    public Set<GenericAbility> getAbilityKeys() {
        return this.abilityMap.keySet();
    }

    public String getName() {
        return this.type.getName();
    }

    public void updateExpToLevel() {
        Parser parser = this.type.getExpEquation();
        parser.setVariable("skill_level", this.currentLevel);
        parser.setVariable("power_level", this.player.getPowerLevel());
        Party party = this.player.getPartyID() == null ? null : McRPG.getInstance().getPartyManager().getParty(this.player.getPartyID());
        int n = party == null ? 0 : party.getPartyLevel();
        parser.setVariable("party_level", n);
        this.expToLevel = (int)parser.getValue();
    }

    public void giveExp(McRPGPlayer mcRPGPlayer, int n, GainReason gainReason) {
        Object object;
        Object object2;
        if (!mcRPGPlayer.isOnline()) {
            return;
        }
        McRPGPlayerExpGainEvent mcRPGPlayerExpGainEvent = new McRPGPlayerExpGainEvent(mcRPGPlayer, n, this, gainReason);
        Bukkit.getPluginManager().callEvent((Event)mcRPGPlayerExpGainEvent);
        if (mcRPGPlayerExpGainEvent.isCancelled()) {
            return;
        }
        n = mcRPGPlayerExpGainEvent.getExpGained();
        int n2 = this.currentLevel++;
        if (n + this.currentExp >= this.expToLevel) {
            int n3 = this.currentExp + n - this.expToLevel;
            object2 = this.type.getExpEquation();
            ((Parser)object2).setVariable("skill_level", this.currentLevel);
            ((Parser)object2).setVariable("power_level", mcRPGPlayer.getPowerLevel());
            this.expToLevel = (int)((Parser)object2).getValue();
            this.currentExp = n3;
            while (this.currentExp >= this.expToLevel) {
                if (this.currentLevel >= this.type.getMaxLevel()) {
                    this.expToLevel = 0;
                    this.currentExp = 0;
                    n3 = 0;
                    break;
                }
                n3 = this.currentExp - this.expToLevel;
                ++this.currentLevel;
                ((Parser)object2).setVariable("skill_level", this.currentLevel);
                ((Parser)object2).setVariable("power_level", mcRPGPlayer.getPowerLevel());
                this.expToLevel = (int)((Parser)object2).getValue();
                this.currentExp = n3;
            }
            object = new McRPGPlayerLevelChangeEvent(mcRPGPlayer, n2, this.currentLevel, this);
            Bukkit.getPluginManager().callEvent((Event)object);
        } else {
            this.currentExp += n;
        }
        if (McRPG.getInstance().getFileManager().getFile(FileManager.Files.CONFIG).getBoolean("Configuration.ConstantExpUpdates.Enabled")) {
            if (McRPG.getInstance().getDisplayManager().doesPlayerHaveDisplay(mcRPGPlayer.getPlayer())) {
                ExpDisplayType expDisplayType;
                if (McRPG.getInstance().getDisplayManager().getDisplay(mcRPGPlayer.getPlayer()) instanceof ExpDisplayType && (expDisplayType = (ExpDisplayType)((Object)McRPG.getInstance().getDisplayManager().getDisplay(mcRPGPlayer.getPlayer()))).getSkill() == this.type) {
                    expDisplayType.sendUpdate(this.currentExp, this.expToLevel, this.currentLevel, n);
                    return;
                }
            } else {
                DisplayType displayType = DisplayType.fromString(McRPG.getInstance().getFileManager().getFile(FileManager.Files.CONFIG).getString("Configuration.ConstantExpUpdates.DisplayType"));
                int n4 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.CONFIG).getInt("Configuration.ConstantExpUpdates.DisplayDuration");
                object = ExpDisplayFactory.createDisplay(displayType, mcRPGPlayer, this.type, n4);
                McRPG.getInstance().getDisplayManager().setGenericDisplay((GenericDisplay)object);
                ((ExpDisplayType)object).sendUpdate(this.currentExp, this.expToLevel, this.currentLevel, n);
            }
        } else {
            if (!McRPG.getInstance().getDisplayManager().doesPlayerHaveDisplay(mcRPGPlayer.getPlayer())) {
                return;
            }
            GenericDisplay genericDisplay = McRPG.getInstance().getDisplayManager().getDisplay(mcRPGPlayer.getPlayer());
            if (genericDisplay instanceof ExpDisplayType && (object2 = (ExpDisplayType)((Object)genericDisplay)).getSkill().equals((Object)this.getType())) {
                object2.sendUpdate(this.currentExp, this.expToLevel, this.currentLevel, n);
            }
        }
    }

    public void giveLevels(McRPGPlayer mcRPGPlayer, int n, boolean bl) {
        int n2 = this.currentLevel;
        this.currentLevel += n;
        if (this.currentLevel > this.type.getMaxLevel()) {
            this.currentLevel = this.type.getMaxLevel();
        }
        McRPGPlayerLevelChangeEvent mcRPGPlayerLevelChangeEvent = new McRPGPlayerLevelChangeEvent(mcRPGPlayer, n2, this.currentLevel, this);
        Bukkit.getPluginManager().callEvent((Event)mcRPGPlayerLevelChangeEvent);
        Parser parser = this.type.getExpEquation();
        parser.setVariable("skill_level", this.currentLevel);
        parser.setVariable("power_level", mcRPGPlayer.getPowerLevel());
        this.expToLevel = (int)parser.getValue();
        if (bl) {
            this.currentExp = 0;
        }
    }

    public void resetSkill() {
        this.expToLevel = 0;
        this.currentLevel = 0;
        this.currentExp = 0;
        for (BaseAbility baseAbility : this.getAbilities()) {
            baseAbility.setToggled(true);
            baseAbility.setCurrentTier(0);
            baseAbility.setUnlocked(false);
        }
        this.updateExpToLevel();
    }

    public Skills getType() {
        return this.type;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public void setCurrentLevel(int n) {
        this.currentLevel = n;
    }

    public int getCurrentExp() {
        return this.currentExp;
    }

    public void setCurrentExp(int n) {
        this.currentExp = n;
    }

    public int getExpToLevel() {
        return this.expToLevel;
    }

    public McRPGPlayer getPlayer() {
        return this.player;
    }
}

