/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.players;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.TipType;

public class PlayerManager {
    private static HashMap<UUID, McRPGPlayer> players = new HashMap();
    private static ArrayList<UUID> playersFrozen = new ArrayList();
    private static McRPG plugin;
    private static BukkitTask saveTask;

    public PlayerManager(McRPG mcRPG) {
        plugin = mcRPG;
    }

    public static void addMcRPGPlayer(Player player, boolean bl) {
        if (players.containsKey(player.getUniqueId())) {
            return;
        }
        final UUID uUID = player.getUniqueId();
        if (bl) {
            playersFrozen.add(uUID);
        }
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                final McRPGPlayer mcRPGPlayer = new McRPGPlayer(uUID);
                mcRPGPlayer.getUsedTips().add(TipType.LOGIN_TIP);
                if (mcRPGPlayer.isOnline()) {
                    if (!McRPG.getInstance().getFileManager().getFile(FileManager.Files.CONFIG).getBoolean("Configuration.DisableTips") && !mcRPGPlayer.isIgnoreTips()) {
                        final List list = McRPG.getInstance().getLangFile().getStringList("Messages.Tips.LoginTips");
                        Random random = new Random();
                        final int n = random.nextInt(list.size());
                        new BukkitRunnable(){

                            public void run() {
                                if (mcRPGPlayer.isOnline()) {
                                    mcRPGPlayer.getPlayer().sendMessage(Methods.color(mcRPGPlayer.getPlayer(), (String)list.get(n)));
                                }
                            }
                        }.runTaskLater((Plugin)McRPG.getInstance(), 40L);
                    }
                    players.put(uUID, mcRPGPlayer);
                }
                playersFrozen.remove(uUID);
            }
        }.runTaskAsynchronously((Plugin)plugin);
    }

    public static boolean isPlayerFrozen(UUID uUID) {
        if (PlayerManager.isPlayerStored(uUID)) {
            playersFrozen.remove(uUID);
        }
        return playersFrozen.contains(uUID);
    }

    public static McRPGPlayer getPlayer(UUID uUID) {
        if (players.containsKey(uUID)) {
            return players.get(uUID);
        }
        throw new McRPGPlayerNotFoundException("Player is not found or loaded yet.");
    }

    public static boolean isPlayerStored(UUID uUID) {
        return players.containsKey(uUID);
    }

    public static void removePlayer(UUID uUID) {
        players.remove(uUID).saveData();
    }

    public static void startSave(Plugin plugin) {
        PlayerManager.plugin = (McRPG)plugin;
        if (saveTask != null) {
            System.out.println(Methods.color(PlayerManager.plugin.getPluginPrefix() + "&eRestarting player saving task...."));
            saveTask.cancel();
        }
        saveTask = new BukkitRunnable(){

            public void run() {
                PlayerManager.run();
            }
        }.runTaskTimerAsynchronously(plugin, 500L, (long)(((McRPG)plugin).getFileManager().getFile(FileManager.Files.CONFIG).getInt("Configuration.SaveInterval") * 1200));
        System.out.println(Methods.color(PlayerManager.plugin.getPluginPrefix() + "&aPlayer saving task has been started!"));
        new BukkitRunnable(){

            public void run() {
                Collection collection = ((HashMap)players.clone()).values();
                for (McRPGPlayer mcRPGPlayer : collection) {
                    if (PlayerManager.isPlayerFrozen(mcRPGPlayer.getUuid())) continue;
                    mcRPGPlayer.updateCooldowns();
                }
            }
        }.runTaskTimer(plugin, 0L, 20L);
    }

    private static void run() {
        HashMap hashMap = (HashMap)players.clone();
        if (players.values() != null && !players.values().isEmpty()) {
            hashMap.values().forEach(McRPGPlayer::saveData);
        }
    }

    public static void saveAll() {
        PlayerManager.run();
    }

    public static void shutDownManager() {
        PlayerManager.saveAll();
        if (saveTask != null) {
            saveTask.cancel();
        }
    }
}

