/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.players;

import com.cyr1en.flatdb.Database;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import sun.misc.Queue;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.abilities.mining.RemoteTransfer;
import us.eunoians.mcrpg.api.events.mcrpg.axes.CripplingBlowEvent;
import us.eunoians.mcrpg.api.events.mcrpg.unarmed.SmitingFistEvent;
import us.eunoians.mcrpg.api.leaderboards.PlayerRank;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.RedeemBit;
import us.eunoians.mcrpg.party.AcceptedTeleportRequest;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.party.PartyInvite;
import us.eunoians.mcrpg.party.TeleportRequest;
import us.eunoians.mcrpg.players.PlayerReadyBit;
import us.eunoians.mcrpg.skills.Skill;
import us.eunoians.mcrpg.types.AbilityType;
import us.eunoians.mcrpg.types.DefaultAbilities;
import us.eunoians.mcrpg.types.DisplayType;
import us.eunoians.mcrpg.types.GainReason;
import us.eunoians.mcrpg.types.GenericAbility;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.types.TipType;
import us.eunoians.mcrpg.types.UnlockedAbilities;
import us.eunoians.mcrpg.util.mcmmo.MobHealthbarUtils;

public class McRPGPlayer {
    private UUID uuid;
    private int powerLevel;
    private int abilityPoints;
    private final List<Skill> skills = new ArrayList<Skill>();
    private final List<UnlockedAbilities> pendingUnlockAbilities = new ArrayList<UnlockedAbilities>();
    private final Map<UnlockedAbilities, Long> abilitiesOnCooldown = new HashMap<UnlockedAbilities, Long>();
    private final List<UnlockedAbilities> abilityLoadout = new ArrayList<UnlockedAbilities>();
    private long endTimeForReplaceCooldown;
    private final List<UnlockedAbilities> activeAbilities = new ArrayList<UnlockedAbilities>();
    private PlayerRank powerRank;
    private final Map<Skills, PlayerRank> skillRanks = new HashMap<Skills, PlayerRank>();
    private boolean isLoadingRankData = false;
    private boolean hasBleedImmunity = false;
    private boolean hasDazeImmunity = false;
    private boolean canSmite;
    private SmitingFistEvent smitingFistData;
    private CripplingBlowEvent cripplingBlowData;
    private boolean isLinkedToRemoteTransfer = false;
    private boolean canDenseImpact;
    private int armourDmg;
    private double divineEscapeExpDebuff;
    private double divineEscapeDamageDebuff;
    private long divineEscapeExpEnd;
    private long divineEscapeDamageEnd;
    private boolean isHandDigging = false;
    private Set<Material> handDiggingBlocks;
    private boolean isReadying = false;
    private PlayerReadyBit readyingAbilityBit = null;
    private MobHealthbarUtils.MobHealthbarType healthbarType = MobHealthbarUtils.MobHealthbarType.BAR;
    private boolean keepHandEmpty = false;
    private DisplayType displayType = DisplayType.SCOREBOARD;
    private boolean autoDeny = false;
    private boolean requireEmptyOffHand = false;
    private boolean ignoreTips;
    private int unarmedIgnoreSlot;
    private Set<TipType> usedTips = new HashSet<TipType>();
    private int redeemableExp;
    private int redeemableLevels;
    private boolean listenForCustomExpInput = false;
    private RedeemBit redeemBit;
    private double guardianSummonChance;
    private Location lastFishCaughtLoc = null;
    private final List<Location> lastFallLocation = new ArrayList<Location>();
    private long magnetArtifactCooldownTime = 0L;
    private long cooldownResetArtifactCooldownTime = 0L;
    private int boostedExp;
    private Queue<PartyInvite> partyInvites = new Queue();
    private UUID partyID;
    private boolean usePartyChat = false;
    private List<TeleportRequest> teleportRequests = new ArrayList<TeleportRequest>();
    private Map<UUID, TeleportRequest> teleportRequestMap = new HashMap<UUID, TeleportRequest>();
    private boolean spyPartyChat = false;
    private AcceptedTeleportRequest acceptedTeleportRequest = null;

    public McRPGPlayer(UUID uUID) {
        Object object;
        this.uuid = uUID;
        this.guardianSummonChance = McRPG.getInstance().getConfig().getDouble("PlayerConfiguration.PoseidonsGuardian.DefaultSummonChance");
        Database database = McRPG.getInstance().getMcRPGDb().getDatabase();
        Optional optional = database.executeQuery("SELECT * FROM mcrpg_player_data WHERE uuid = '" + uUID.toString() + "'", new String[0]);
        boolean bl = false;
        try {
            bl = optional.isPresent() ? !((ResultSet)optional.get()).next() : true;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        if (bl) {
            for (Skills object32 : Skills.values()) {
                String string = "INSERT INTO mcrpg_" + object32.getName() + "_data (uuid) VALUES ('" + uUID.toString() + "')";
                database.executeUpdate(string, new String[0]);
            }
            object = "INSERT INTO MCRPG_PLAYER_SETTINGS (UUID) VALUES ('" + uUID.toString() + "')";
            database.executeUpdate((String)object, new String[0]);
            object = "INSERT INTO MCRPG_PLAYER_DATA (UUID) VALUES ('" + uUID.toString() + "')";
            database.executeUpdate((String)object, new String[0]);
            object = "INSERT INTO MCRPG_LOADOUT (UUID) VALUES ('" + uUID.toString() + "')";
            database.executeUpdate((String)object, new String[0]);
            optional = database.executeQuery("SELECT * FROM mcrpg_player_data WHERE uuid = '" + uUID.toString() + "'", new String[0]);
            try {
                ((ResultSet)optional.get()).next();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        optional.ifPresent(resultSet -> {
            try {
                Comparable<Calendar> comparable;
                Object object;
                this.abilityPoints = resultSet.getInt("ability_points");
                this.redeemableExp = resultSet.getInt("redeemable_exp");
                this.redeemableLevels = resultSet.getInt("redeemable_levels");
                long l = resultSet.getLong("replace_ability_cooldown_time");
                this.boostedExp = resultSet.getInt("boosted_exp");
                this.divineEscapeExpDebuff = resultSet.getDouble("divine_escape_exp_debuff");
                this.divineEscapeDamageDebuff = resultSet.getDouble("divine_escape_damage_debuff");
                this.divineEscapeExpEnd = resultSet.getLong("divine_escape_exp_end_time");
                this.divineEscapeDamageEnd = resultSet.getInt("divine_escape_damage_end_time");
                String string = resultSet.getString("party_uuid");
                if (string.equalsIgnoreCase("nu")) {
                    this.partyID = null;
                } else {
                    this.partyID = UUID.fromString(string);
                    object = McRPG.getInstance().getPartyManager().getParty(this.partyID);
                    comparable = new StringBuilder();
                    if (object == null) {
                        this.partyID = null;
                        ((StringBuilder)comparable).append("&cYour party no longer exists.");
                    } else if (!((Party)object).isPlayerInParty(uUID)) {
                        this.partyID = null;
                        ((StringBuilder)comparable).append("&cYou were removed from your party whilst offline.");
                    }
                    if (((StringBuilder)comparable).length() != 0) {
                        new BukkitRunnable((StringBuilder)comparable){
                            final /* synthetic */ StringBuilder val$nullPartyMessage;
                            {
                                this.val$nullPartyMessage = stringBuilder;
                            }

                            public void run() {
                                OfflinePlayer offlinePlayer = McRPGPlayer.this.getOfflineMcRPGPlayer();
                                if (offlinePlayer.isOnline()) {
                                    ((Player)offlinePlayer).sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + this.val$nullPartyMessage.toString()));
                                }
                            }
                        }.runTaskLater((Plugin)McRPG.getInstance(), 40L);
                    }
                }
                object = Calendar.getInstance();
                comparable = Calendar.getInstance();
                ((Calendar)object).setTimeInMillis(l);
                if (((Calendar)comparable).getTimeInMillis() < ((Calendar)object).getTimeInMillis()) {
                    this.endTimeForReplaceCooldown = ((Calendar)object).getTimeInMillis();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        });
        object = database.executeQuery("SELECT * FROM mcrpg_player_settings WHERE uuid = '" + uUID.toString() + "'", new String[0]);
        ((Optional)object).ifPresent(resultSet -> {
            try {
                if (resultSet.next()) {
                    this.healthbarType = MobHealthbarUtils.MobHealthbarType.fromString(resultSet.getString("health_type"));
                    this.keepHandEmpty = resultSet.getBoolean("keep_hand");
                    this.displayType = DisplayType.fromString(resultSet.getString("display_type"));
                    this.autoDeny = resultSet.getBoolean("auto_deny");
                    this.ignoreTips = resultSet.getBoolean("ignore_tips");
                    this.requireEmptyOffHand = resultSet.getBoolean("require_empty_offhand");
                    this.unarmedIgnoreSlot = resultSet.getInt("unarmed_ignore_slot");
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        });
        Arrays.stream(Skills.values()).forEach(skills -> {
            HashMap hashMap = new HashMap();
            Optional optional = database.executeQuery("SELECT * FROM mcrpg_" + skills.getName().toLowerCase() + "_data WHERE uuid = '" + uUID.toString() + "'", new String[0]);
            try {
                if (!optional.isPresent() || !((ResultSet)optional.get()).next()) {
                    String string = "INSERT INTO mcrpg_" + skills.getName().toLowerCase() + "_data (uuid) VALUES ('" + uUID.toString() + "')";
                    database.executeUpdate(string, new String[0]);
                    optional = database.executeQuery("SELECT * FROM mcrpg_" + skills.getName().toLowerCase() + "_data WHERE uuid = '" + uUID.toString() + "'", new String[0]);
                    ((ResultSet)optional.get()).next();
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            optional.ifPresent(resultSet -> {
                try {
                    Class<? extends Skill> clazz = skills.getClazz();
                    skills.getAllAbilities().forEach(genericAbility -> {
                        Class<? extends BaseAbility> clazz = genericAbility.getClazz();
                        BaseAbility baseAbility = null;
                        try {
                            boolean bl = resultSet.getBoolean("is_" + genericAbility.name().toLowerCase() + "_toggled");
                            if (genericAbility instanceof DefaultAbilities) {
                                baseAbility = clazz.getConstructor(Boolean.TYPE).newInstance(bl);
                            } else if (genericAbility instanceof UnlockedAbilities) {
                                int n;
                                int n2 = resultSet.getInt(genericAbility.name().toLowerCase() + "_tier");
                                if (genericAbility.equals(UnlockedAbilities.REMOTE_TRANSFER)) {
                                    baseAbility = clazz.getConstructor(UUID.class, Boolean.TYPE, Integer.TYPE).newInstance(uUID, bl, n2);
                                    this.isLinkedToRemoteTransfer = ((RemoteTransfer)baseAbility).isAbilityLinked();
                                } else {
                                    baseAbility = clazz.getConstructor(Boolean.TYPE, Integer.TYPE).newInstance(bl, n2);
                                }
                                if (genericAbility.isCooldown() && (n = resultSet.getInt(genericAbility.name().toLowerCase() + "_cooldown")) > 0) {
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.add(13, n);
                                    this.abilitiesOnCooldown.put((UnlockedAbilities)genericAbility, calendar.getTimeInMillis());
                                }
                                if (resultSet.getBoolean("is_" + genericAbility.name().toLowerCase() + "_pending")) {
                                    this.pendingUnlockAbilities.add((UnlockedAbilities)genericAbility);
                                }
                            }
                        }
                        catch (ReflectiveOperationException | SQLException exception) {
                            exception.printStackTrace();
                        }
                        hashMap.put(genericAbility, baseAbility);
                    });
                    Skill skill = clazz.getConstructor(Integer.TYPE, Integer.TYPE, HashMap.class, McRPGPlayer.class).newInstance(resultSet.getInt("current_level"), resultSet.getInt("current_exp"), hashMap, this);
                    this.skills.add(skill);
                }
                catch (ReflectiveOperationException | SQLException exception) {
                    exception.printStackTrace();
                }
            });
        });
        Optional optional2 = database.executeQuery("SELECT * FROM mcrpg_loadout WHERE uuid = '" + uUID.toString() + "'", new String[0]);
        optional2.ifPresent(resultSet -> {
            try {
                if (resultSet.next()) {
                    for (int i = 1; i <= McRPG.getInstance().getConfig().getInt("PlayerConfiguration.AmountOfTotalAbilities"); ++i) {
                        String string = resultSet.getString("Slot" + i);
                        if (string == null || string.equalsIgnoreCase("null")) continue;
                        UnlockedAbilities unlockedAbilities = UnlockedAbilities.fromString(string);
                        this.abilityLoadout.add(unlockedAbilities);
                    }
                }
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        });
        this.updatePowerLevel();
        for (Skill skill : this.skills) {
            skill.updateExpToLevel();
        }
        ArrayList arrayList = new ArrayList();
        for (UnlockedAbilities unlockedAbilities : this.abilityLoadout) {
            BaseAbility baseAbility = this.getBaseAbility(unlockedAbilities);
            if (baseAbility.getCurrentTier() >= 1) continue;
            baseAbility.setUnlocked(false);
            arrayList.add(unlockedAbilities);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            UnlockedAbilities unlockedAbilities = (UnlockedAbilities)iterator.next();
            this.abilityLoadout.remove(unlockedAbilities);
        }
    }

    public OfflinePlayer getOfflineMcRPGPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public boolean isReadying() {
        if (this.readyingAbilityBit == null || this.readyingAbilityBit.getAbilityReady() == null) {
            this.isReadying = false;
        }
        return this.isReadying;
    }

    public int updatePowerLevel() {
        if (this.skills.isEmpty()) {
            this.powerLevel = 0;
        } else {
            AtomicInteger atomicInteger = new AtomicInteger(0);
            this.skills.forEach(skill -> atomicInteger.addAndGet(skill.getCurrentLevel()));
            this.powerLevel = atomicInteger.get();
        }
        return this.powerLevel;
    }

    public Skill getSkill(String string) {
        return this.skills.stream().filter(skill -> skill.getName().equalsIgnoreCase(string)).findAny().orElse(null);
    }

    public Skill getSkill(Skills skills) {
        return this.skills.stream().filter(skill -> skill.getType().equals((Object)skills)).findFirst().orElse(null);
    }

    public BaseAbility getBaseAbility(GenericAbility genericAbility) {
        return genericAbility != null ? this.getSkill(genericAbility.getSkill()).getAbility(genericAbility) : null;
    }

    public void giveExp(Skills skills, int n, GainReason gainReason) {
        this.getSkill(skills).giveExp(this, n, gainReason);
    }

    public long getCooldown(GenericAbility genericAbility) {
        if (this.abilitiesOnCooldown.containsKey(genericAbility)) {
            return TimeUnit.MILLISECONDS.toSeconds(this.abilitiesOnCooldown.get(genericAbility) - Calendar.getInstance().getTimeInMillis());
        }
        return -1L;
    }

    public long getCooldown(Skills skills) {
        for (UnlockedAbilities unlockedAbilities : this.abilitiesOnCooldown.keySet()) {
            if (!unlockedAbilities.getSkill().equals((Object)skills)) continue;
            return TimeUnit.MILLISECONDS.toSeconds(this.abilitiesOnCooldown.get(unlockedAbilities) - Calendar.getInstance().getTimeInMillis());
        }
        return -1L;
    }

    public void addAbilityOnCooldown(UnlockedAbilities unlockedAbilities, long l) {
        this.abilitiesOnCooldown.put(unlockedAbilities, l);
    }

    public void removeAbilityOnCooldown(UnlockedAbilities unlockedAbilities) {
        this.abilitiesOnCooldown.replace(unlockedAbilities, 0L);
    }

    public void removeAbilityOnCooldown(Skills skills) {
        UnlockedAbilities unlockedAbilities = null;
        for (UnlockedAbilities unlockedAbilities2 : this.abilitiesOnCooldown.keySet()) {
            if (!unlockedAbilities2.getSkill().equals((Object)skills)) continue;
            unlockedAbilities = unlockedAbilities2;
            break;
        }
        if (unlockedAbilities != null) {
            this.abilitiesOnCooldown.remove(unlockedAbilities);
        }
    }

    public void updateCooldowns() {
        ArrayList<UnlockedAbilities> arrayList = new ArrayList<UnlockedAbilities>();
        if (this.abilitiesOnCooldown.isEmpty() && this.endTimeForReplaceCooldown == 0L) {
            return;
        }
        for (UnlockedAbilities object : this.abilitiesOnCooldown.keySet()) {
            if (!this.abilityLoadout.contains(object)) {
                arrayList.add(object);
                continue;
            }
            long unlockedAbilities = this.abilitiesOnCooldown.get(object);
            if (Calendar.getInstance().getTimeInMillis() >= unlockedAbilities) {
                if (Bukkit.getOfflinePlayer((UUID)this.uuid).isOnline()) {
                    this.getPlayer().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Players.CooldownExpire").replace("%Ability%", object.getName())));
                }
                arrayList.add(object);
                continue;
            }
            if (unlockedAbilities > 0L) continue;
            arrayList.add(object);
        }
        Database database = McRPG.getInstance().getMcRPGDb().getDatabase();
        if (!arrayList.isEmpty()) {
            for (UnlockedAbilities unlockedAbilities : arrayList) {
                database.executeUpdate("UPDATE mcrpg_" + unlockedAbilities.getSkill().getName().toLowerCase() + "_data SET " + Methods.convertNameToSQL(unlockedAbilities.getName().replace(" ", "").replace("_", "").replace("+", "Plus")) + "_cooldown = 0 WHERE uuid = '" + this.uuid.toString() + "'", new String[0]);
                this.abilitiesOnCooldown.remove(unlockedAbilities);
            }
        }
        if (this.endTimeForReplaceCooldown != 0L && Calendar.getInstance().getTimeInMillis() >= this.endTimeForReplaceCooldown) {
            this.endTimeForReplaceCooldown = 0L;
            if (Bukkit.getOfflinePlayer((UUID)this.uuid).isOnline()) {
                this.getPlayer().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Players.ReplaceCooldownExpire")));
            }
            database.executeUpdate("UPDATE mcrpg_player_data SET replace_ability_cooldown_time = 0 WHERE uuid = '" + this.uuid.toString() + "'", new String[0]);
        }
        if (this.divineEscapeExpEnd != 0L && this.divineEscapeExpEnd <= Calendar.getInstance().getTimeInMillis()) {
            this.divineEscapeExpEnd = 0L;
            this.divineEscapeExpDebuff = 0.0;
            if (Bukkit.getOfflinePlayer((UUID)this.uuid).isOnline()) {
                this.getPlayer().sendMessage(Methods.color(this.getPlayer(), McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.DivineEscape.ExpDebuffExpire")));
            }
        }
        if (this.divineEscapeDamageEnd != 0L && this.divineEscapeDamageEnd <= Calendar.getInstance().getTimeInMillis()) {
            this.divineEscapeDamageEnd = 0L;
            this.divineEscapeDamageDebuff = 0.0;
            if (Bukkit.getOfflinePlayer((UUID)this.uuid).isOnline()) {
                this.getPlayer().sendMessage(Methods.color(this.getPlayer(), McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.DivineEscape.DamageDebuffExpire")));
            }
        }
    }

    public void resetCooldowns() {
        Database database = McRPG.getInstance().getMcRPGDb().getDatabase();
        for (UnlockedAbilities unlockedAbilities : this.abilitiesOnCooldown.keySet()) {
            long l = this.abilitiesOnCooldown.get(unlockedAbilities);
            if (Calendar.getInstance().getTimeInMillis() < l) continue;
            if (Bukkit.getOfflinePlayer((UUID)this.uuid).isOnline()) {
                this.getPlayer().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Players.CooldownExpire").replace("%Ability%", unlockedAbilities.getName())));
            }
            database.executeUpdate("UPDATE mcrpg_" + unlockedAbilities.getSkill().getName().toLowerCase() + "_data SET " + Methods.convertNameToSQL(unlockedAbilities.getName().replace(" ", "").replace("_", "").replace("+", "Plus")) + "_cooldown = 0 WHERE uuid = '" + this.uuid.toString() + "'", new String[0]);
        }
        this.abilitiesOnCooldown.clear();
        this.endTimeForReplaceCooldown = 0L;
        database.executeUpdate("UPDATE mcrpg_player_data SET replace_ability_cooldown_time = 0 WHERE uuid = `" + this.uuid.toString() + "`", new String[0]);
        if (Bukkit.getOfflinePlayer((UUID)this.uuid).isOnline()) {
            this.getPlayer().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Players.ReplaceCooldownExpire")));
        }
    }

    public void saveData() {
        Skill skill;
        Object object;
        int n;
        Database database = McRPG.getInstance().getMcRPGDb().getDatabase();
        Skills[] object4 = Skills.values();
        int n2 = object4.length;
        for (n = 0; n < n2; ++n) {
            object = object4[n];
            skill = this.getSkill((Skills)((Object)object));
            Object object2 = "UPDATE mcrpg_" + skill.getName().toLowerCase() + "_data SET current_level = " + skill.getCurrentLevel() + ", current_exp = " + skill.getCurrentExp();
            for (GenericAbility genericAbility : skill.getAbilityKeys()) {
                if (genericAbility instanceof DefaultAbilities) {
                    object2 = (String)object2 + ", is_" + Methods.convertNameToSQL(genericAbility.getName().replace(" ", "").replace("_", "").replace("+", "Plus")) + "_toggled = " + Methods.convertBool(skill.getAbility(genericAbility).isToggled());
                }
                if (genericAbility instanceof UnlockedAbilities) {
                    object2 = (String)object2 + ", is_" + Methods.convertNameToSQL(genericAbility.getName().replace(" ", "").replace("_", "").replace("+", "Plus")) + "_toggled = " + Methods.convertBool(skill.getAbility(genericAbility).isToggled());
                    object2 = (String)object2 + ", is_" + Methods.convertNameToSQL(genericAbility.getName().replace(" ", "").replace("_", "").replace("+", "Plus")) + "_pending = " + Methods.convertBool(this.pendingUnlockAbilities.contains(genericAbility));
                    object2 = (String)object2 + ", " + Methods.convertNameToSQL(genericAbility.getName().replace(" ", "").replace("_", "").replace("+", "Plus")) + "_tier = " + skill.getAbility(genericAbility).getCurrentTier();
                }
                Calendar calendar = Calendar.getInstance();
                if (!this.abilitiesOnCooldown.containsKey(genericAbility)) continue;
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTimeInMillis(this.abilitiesOnCooldown.get(genericAbility));
                int n3 = (int)(calendar2.getTimeInMillis() - calendar.getTimeInMillis()) / 1000;
                object2 = (String)object2 + ", " + Methods.convertNameToSQL(genericAbility.getName().replace(" ", "").replace("_", "").replace("+", "Plus")) + "_cooldown = " + n3;
            }
            object2 = (String)object2 + " WHERE uuid = '" + this.uuid.toString() + "'";
            database.executeUpdate((String)object2, new String[0]);
        }
        if (this.endTimeForReplaceCooldown != 0L) {
            database.executeUpdate("UPDATE mcrpg_player_data SET replace_ability_cooldown_time = " + this.endTimeForReplaceCooldown + " WHERE uuid = '" + this.uuid.toString() + "'", new String[0]);
        }
        database.executeUpdate("UPDATE mcrpg_player_data SET ability_points = " + this.abilityPoints + ", power_level = " + this.powerLevel + ", redeemable_exp = " + this.redeemableExp + ", redeemable_levels = " + this.redeemableLevels + ", boosted_exp = " + this.boostedExp + ", divine_escape_exp_debuff = " + this.divineEscapeExpDebuff + ", divine_escape_damage_debuff = " + this.divineEscapeDamageDebuff + ", divine_escape_exp_end_time = " + this.divineEscapeExpEnd + ", divine_escape_damage_end_time = " + this.divineEscapeDamageEnd + ", party_uuid = '" + (this.partyID == null ? "nu" : this.partyID.toString()) + "' WHERE uuid = '" + this.uuid.toString() + "'", new String[0]);
        String string = "UPDATE mcrpg_player_settings SET require_empty_offhand = " + Methods.convertBool(this.requireEmptyOffHand) + ", keep_hand = " + Methods.convertBool(this.keepHandEmpty) + ", ignore_tips = " + Methods.convertBool(this.ignoreTips) + ", auto_deny = " + Methods.convertBool(this.autoDeny) + ", display_type = '" + this.displayType.getName() + "', health_type = '" + this.healthbarType.getName() + "', unarmed_ignore_slot = " + this.unarmedIgnoreSlot + " WHERE uuid = '" + this.uuid.toString() + "'";
        database.executeUpdate(string, new String[0]);
        for (UnlockedAbilities unlockedAbilities : this.pendingUnlockAbilities) {
            String string2 = "UPDATE mcrpg_" + unlockedAbilities.getSkill().getName().toLowerCase() + "_data SET is_" + Methods.convertNameToSQL(unlockedAbilities.getName().replace(" ", "").replace("_", "").replace("+", "Plus")) + "_pending = 1 WHERE uuid = '" + this.uuid.toString() + "'";
            database.executeUpdate(string2, new String[0]);
        }
        Object object3 = "UPDATE mcrpg_loadout SET";
        for (n = 1; n <= McRPG.getInstance().getConfig().getInt("PlayerConfiguration.AmountOfTotalAbilities"); ++n) {
            if (n != 1) {
                object3 = (String)object3 + ",";
            }
            object = "null";
            object3 = (String)object3 + " Slot" + n + " = '" + (String)(this.abilityLoadout.size() >= n ? this.abilityLoadout.get(n - 1).getName() : object) + "'";
        }
        object3 = (String)object3 + " WHERE uuid = '" + this.uuid.toString() + "'";
        database.executeUpdate((String)object3, new String[0]);
        RemoteTransfer remoteTransfer = (RemoteTransfer)this.getBaseAbility(UnlockedAbilities.REMOTE_TRANSFER);
        if (remoteTransfer.isUnlocked()) {
            object = new File(McRPG.getInstance().getDataFolder(), File.separator + "remote_transfer_data" + File.separator + this.uuid.toString() + ".yml");
            skill = YamlConfiguration.loadConfiguration((File)object);
            for (Material material : remoteTransfer.getItemsToSync().keySet()) {
                skill.set("RemoteTransferBlocks." + material.toString(), remoteTransfer.getItemsToSync().get(material));
            }
            try {
                skill.save((File)object);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void addPendingAbilityUnlock(UnlockedAbilities unlockedAbilities) {
        this.pendingUnlockAbilities.add(unlockedAbilities);
    }

    public void removePendingAbilityUnlock(UnlockedAbilities unlockedAbilities) {
        this.pendingUnlockAbilities.remove(unlockedAbilities);
    }

    public boolean hasPendingAbility() {
        return !this.pendingUnlockAbilities.isEmpty();
    }

    public boolean isOnline() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).isOnline();
    }

    public Player getPlayer() {
        return (Player)Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public boolean isPlayerOnline() {
        return Bukkit.getOfflinePlayer((UUID)this.uuid).isOnline();
    }

    public void addAbilityToLoadout(UnlockedAbilities unlockedAbilities) {
        this.abilityLoadout.add(unlockedAbilities);
        this.saveData();
    }

    public boolean doesPlayerHaveAbilityInLoadout(UnlockedAbilities unlockedAbilities) {
        return this.abilityLoadout.stream().filter(unlockedAbilities2 -> unlockedAbilities2.getName().equalsIgnoreCase(unlockedAbilities.getName())).findFirst().orElse(null) != null;
    }

    public boolean doesPlayerHaveActiveAbilityFromSkill(Skills skills) {
        return this.abilityLoadout.stream().filter(unlockedAbilities -> unlockedAbilities.getSkill().equals((Object)skills)).filter(unlockedAbilities -> unlockedAbilities.getAbilityType() == AbilityType.ACTIVE).findFirst().orElse(null) != null;
    }

    public UnlockedAbilities getActiveAbilityForSkill(Skills skills) {
        return this.abilityLoadout.stream().filter(unlockedAbilities -> unlockedAbilities.getSkill().equals((Object)skills)).filter(unlockedAbilities -> unlockedAbilities.getAbilityType() == AbilityType.ACTIVE).findFirst().orElse(null);
    }

    public void replaceAbility(UnlockedAbilities unlockedAbilities, UnlockedAbilities unlockedAbilities2) {
        for (int i = 0; i < this.abilityLoadout.size(); ++i) {
            if (!this.abilityLoadout.get(i).equals(unlockedAbilities)) continue;
            this.abilityLoadout.set(i, unlockedAbilities2);
            return;
        }
    }

    public void giveRedeemableExp(int n) {
        this.redeemableExp += n;
    }

    public void giveRedeemableLevels(int n) {
        this.redeemableLevels += n;
    }

    public void addTeleportRequest(TeleportRequest teleportRequest) {
        this.teleportRequests.add(teleportRequest);
        this.teleportRequestMap.put(teleportRequest.getSender(), teleportRequest);
    }

    public void emptyTeleportRequests() {
        this.teleportRequestMap = new HashMap<UUID, TeleportRequest>();
        this.teleportRequests = new ArrayList<TeleportRequest>();
    }

    public boolean equals(Object object) {
        if (object instanceof McRPGPlayer) {
            return this.uuid.equals(((McRPGPlayer)object).getUuid());
        }
        if (object instanceof Player) {
            return this.uuid.equals(((Player)object).getUniqueId());
        }
        if (object instanceof UUID) {
            return this.uuid.equals(object);
        }
        return false;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getPowerLevel() {
        return this.powerLevel;
    }

    public int getAbilityPoints() {
        return this.abilityPoints;
    }

    public void setAbilityPoints(int n) {
        this.abilityPoints = n;
    }

    public List<UnlockedAbilities> getPendingUnlockAbilities() {
        return this.pendingUnlockAbilities;
    }

    public List<UnlockedAbilities> getAbilityLoadout() {
        return this.abilityLoadout;
    }

    public long getEndTimeForReplaceCooldown() {
        return this.endTimeForReplaceCooldown;
    }

    public void setEndTimeForReplaceCooldown(long l) {
        this.endTimeForReplaceCooldown = l;
    }

    public List<UnlockedAbilities> getActiveAbilities() {
        return this.activeAbilities;
    }

    public PlayerRank getPowerRank() {
        return this.powerRank;
    }

    public void setPowerRank(PlayerRank playerRank) {
        this.powerRank = playerRank;
    }

    public Map<Skills, PlayerRank> getSkillRanks() {
        return this.skillRanks;
    }

    public boolean isLoadingRankData() {
        return this.isLoadingRankData;
    }

    public boolean isHasBleedImmunity() {
        return this.hasBleedImmunity;
    }

    public void setHasBleedImmunity(boolean bl) {
        this.hasBleedImmunity = bl;
    }

    public boolean isHasDazeImmunity() {
        return this.hasDazeImmunity;
    }

    public void setHasDazeImmunity(boolean bl) {
        this.hasDazeImmunity = bl;
    }

    public void setCanSmite(boolean bl) {
        this.canSmite = bl;
    }

    public boolean isCanSmite() {
        return this.canSmite;
    }

    public SmitingFistEvent getSmitingFistData() {
        return this.smitingFistData;
    }

    public void setSmitingFistData(SmitingFistEvent smitingFistEvent) {
        this.smitingFistData = smitingFistEvent;
    }

    public CripplingBlowEvent getCripplingBlowData() {
        return this.cripplingBlowData;
    }

    public void setCripplingBlowData(CripplingBlowEvent cripplingBlowEvent) {
        this.cripplingBlowData = cripplingBlowEvent;
    }

    public boolean isLinkedToRemoteTransfer() {
        return this.isLinkedToRemoteTransfer;
    }

    public void setLinkedToRemoteTransfer(boolean bl) {
        this.isLinkedToRemoteTransfer = bl;
    }

    public boolean isCanDenseImpact() {
        return this.canDenseImpact;
    }

    public void setCanDenseImpact(boolean bl) {
        this.canDenseImpact = bl;
    }

    public int getArmourDmg() {
        return this.armourDmg;
    }

    public void setArmourDmg(int n) {
        this.armourDmg = n;
    }

    public double getDivineEscapeExpDebuff() {
        return this.divineEscapeExpDebuff;
    }

    public void setDivineEscapeExpDebuff(double d) {
        this.divineEscapeExpDebuff = d;
    }

    public double getDivineEscapeDamageDebuff() {
        return this.divineEscapeDamageDebuff;
    }

    public void setDivineEscapeDamageDebuff(double d) {
        this.divineEscapeDamageDebuff = d;
    }

    public long getDivineEscapeExpEnd() {
        return this.divineEscapeExpEnd;
    }

    public void setDivineEscapeExpEnd(long l) {
        this.divineEscapeExpEnd = l;
    }

    public long getDivineEscapeDamageEnd() {
        return this.divineEscapeDamageEnd;
    }

    public void setDivineEscapeDamageEnd(long l) {
        this.divineEscapeDamageEnd = l;
    }

    public boolean isHandDigging() {
        return this.isHandDigging;
    }

    public void setHandDigging(boolean bl) {
        this.isHandDigging = bl;
    }

    public Set<Material> getHandDiggingBlocks() {
        return this.handDiggingBlocks;
    }

    public void setHandDiggingBlocks(Set<Material> set) {
        this.handDiggingBlocks = set;
    }

    public void setReadying(boolean bl) {
        this.isReadying = bl;
    }

    public PlayerReadyBit getReadyingAbilityBit() {
        return this.readyingAbilityBit;
    }

    public void setReadyingAbilityBit(PlayerReadyBit playerReadyBit) {
        this.readyingAbilityBit = playerReadyBit;
    }

    public MobHealthbarUtils.MobHealthbarType getHealthbarType() {
        return this.healthbarType;
    }

    public void setHealthbarType(MobHealthbarUtils.MobHealthbarType mobHealthbarType) {
        this.healthbarType = mobHealthbarType;
    }

    public boolean isKeepHandEmpty() {
        return this.keepHandEmpty;
    }

    public void setKeepHandEmpty(boolean bl) {
        this.keepHandEmpty = bl;
    }

    public DisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(DisplayType displayType) {
        this.displayType = displayType;
    }

    public boolean isAutoDeny() {
        return this.autoDeny;
    }

    public void setAutoDeny(boolean bl) {
        this.autoDeny = bl;
    }

    public boolean isRequireEmptyOffHand() {
        return this.requireEmptyOffHand;
    }

    public void setRequireEmptyOffHand(boolean bl) {
        this.requireEmptyOffHand = bl;
    }

    public boolean isIgnoreTips() {
        return this.ignoreTips;
    }

    public void setIgnoreTips(boolean bl) {
        this.ignoreTips = bl;
    }

    public int getUnarmedIgnoreSlot() {
        return this.unarmedIgnoreSlot;
    }

    public void setUnarmedIgnoreSlot(int n) {
        this.unarmedIgnoreSlot = n;
    }

    public Set<TipType> getUsedTips() {
        return this.usedTips;
    }

    public int getRedeemableExp() {
        return this.redeemableExp;
    }

    public void setRedeemableExp(int n) {
        this.redeemableExp = n;
    }

    public int getRedeemableLevels() {
        return this.redeemableLevels;
    }

    public void setRedeemableLevels(int n) {
        this.redeemableLevels = n;
    }

    public boolean isListenForCustomExpInput() {
        return this.listenForCustomExpInput;
    }

    public void setListenForCustomExpInput(boolean bl) {
        this.listenForCustomExpInput = bl;
    }

    public RedeemBit getRedeemBit() {
        return this.redeemBit;
    }

    public void setRedeemBit(RedeemBit redeemBit) {
        this.redeemBit = redeemBit;
    }

    public double getGuardianSummonChance() {
        return this.guardianSummonChance;
    }

    public void setGuardianSummonChance(double d) {
        this.guardianSummonChance = d;
    }

    public Location getLastFishCaughtLoc() {
        return this.lastFishCaughtLoc;
    }

    public void setLastFishCaughtLoc(Location location) {
        this.lastFishCaughtLoc = location;
    }

    public List<Location> getLastFallLocation() {
        return this.lastFallLocation;
    }

    public long getMagnetArtifactCooldownTime() {
        return this.magnetArtifactCooldownTime;
    }

    public void setMagnetArtifactCooldownTime(long l) {
        this.magnetArtifactCooldownTime = l;
    }

    public long getCooldownResetArtifactCooldownTime() {
        return this.cooldownResetArtifactCooldownTime;
    }

    public void setCooldownResetArtifactCooldownTime(long l) {
        this.cooldownResetArtifactCooldownTime = l;
    }

    public int getBoostedExp() {
        return this.boostedExp;
    }

    public void setBoostedExp(int n) {
        this.boostedExp = n;
    }

    public Queue<PartyInvite> getPartyInvites() {
        return this.partyInvites;
    }

    public UUID getPartyID() {
        return this.partyID;
    }

    public void setPartyID(UUID uUID) {
        this.partyID = uUID;
    }

    public boolean isUsePartyChat() {
        return this.usePartyChat;
    }

    public void setUsePartyChat(boolean bl) {
        this.usePartyChat = bl;
    }

    public List<TeleportRequest> getTeleportRequests() {
        return this.teleportRequests;
    }

    public Map<UUID, TeleportRequest> getTeleportRequestMap() {
        return this.teleportRequestMap;
    }

    public boolean isSpyPartyChat() {
        return this.spyPartyChat;
    }

    public void setSpyPartyChat(boolean bl) {
        this.spyPartyChat = bl;
    }

    public AcceptedTeleportRequest getAcceptedTeleportRequest() {
        return this.acceptedTeleportRequest;
    }

    public void setAcceptedTeleportRequest(AcceptedTeleportRequest acceptedTeleportRequest) {
        this.acceptedTeleportRequest = acceptedTeleportRequest;
    }
}

