/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.party;

import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.party.AcceptedTeleportRequest;
import us.eunoians.mcrpg.party.TeleportFunction;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;

public class TeleportRequest {
    private UUID sender;
    private UUID recipient;
    private long timeSent;
    private boolean toRecipient;

    public TeleportRequest(UUID uUID, UUID uUID2, boolean bl) {
        this.recipient = uUID;
        this.sender = uUID2;
        this.toRecipient = bl;
        this.timeSent = Calendar.getInstance().getTimeInMillis();
    }

    public boolean accept() {
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)this.sender);
        OfflinePlayer offlinePlayer2 = Bukkit.getOfflinePlayer((UUID)this.recipient);
        if (offlinePlayer2.isOnline() && offlinePlayer.isOnline()) {
            final Player player3 = (Player)offlinePlayer;
            final Player player4 = (Player)offlinePlayer2;
            final TeleportFunction teleportFunction = this.toRecipient ? (player, player2) -> {
                if (player.isOnline() && player2.isOnline()) {
                    player2.teleport((Entity)player);
                    return true;
                }
                return false;
            } : (player, player2) -> {
                if (player.isOnline() && player2.isOnline()) {
                    player.teleport((Entity)player2);
                    return true;
                }
                return false;
            };
            final AtomicInteger atomicInteger = new AtomicInteger(0);
            BukkitTask bukkitTask = new BukkitRunnable(){

                public void run() {
                    if (atomicInteger.get() == 0) {
                        if (!TeleportRequest.this.toRecipient) {
                            player3.sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Commands.Parties.TpWasAccepted").replace("%Player%", player4.getName())));
                            player4.sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Commands.Parties.TpAcceptedAndStandStill")));
                        } else {
                            player4.sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Commands.Parties.TpAccepted")));
                            player3.sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Commands.Parties.TpWasAcceptedAndStandStill").replace("%Player%", player4.getName())));
                        }
                    } else {
                        if (!player4.isOnline() || !player3.isOnline()) {
                            if (!player4.isOnline()) {
                                if (player3.isOnline()) {
                                    player3.sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Commands.Parties.TeleportationCanceled")));
                                    this.cancel();
                                    return;
                                }
                            } else if (player4.isOnline()) {
                                player4.sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Commands.Parties.TeleportationCanceled")));
                                this.cancel();
                                return;
                            }
                        }
                        if (atomicInteger.get() < 6) {
                            if (TeleportRequest.this.toRecipient) {
                                player3.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Methods.color("&c" + (5 - atomicInteger.get()))));
                            } else {
                                player4.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)Methods.color("&c" + (5 - atomicInteger.get()))));
                            }
                        } else {
                            teleportFunction.teleportPlayer(player4, player3);
                            this.cancel();
                            try {
                                McRPGPlayer mcRPGPlayer = TeleportRequest.this.toRecipient ? PlayerManager.getPlayer(TeleportRequest.this.sender) : PlayerManager.getPlayer(TeleportRequest.this.recipient);
                                mcRPGPlayer.setAcceptedTeleportRequest(null);
                            }
                            catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                                // empty catch block
                            }
                        }
                    }
                    atomicInteger.incrementAndGet();
                }
            }.runTaskTimer((Plugin)McRPG.getInstance(), 10L, 20L);
            AcceptedTeleportRequest acceptedTeleportRequest = new AcceptedTeleportRequest(bukkitTask, this);
            try {
                McRPGPlayer mcRPGPlayer = this.toRecipient ? PlayerManager.getPlayer(this.sender) : PlayerManager.getPlayer(this.recipient);
                mcRPGPlayer.setAcceptedTeleportRequest(acceptedTeleportRequest);
                return true;
            }
            catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                return false;
            }
        }
        return false;
    }

    public boolean equals(Object object) {
        TeleportRequest teleportRequest;
        return object instanceof TeleportRequest && (teleportRequest = (TeleportRequest)object).getRecipient().equals(this.recipient) && teleportRequest.getSender().equals(this.sender) && teleportRequest.getTimeSent() == this.getTimeSent();
    }

    public UUID getSender() {
        return this.sender;
    }

    public UUID getRecipient() {
        return this.recipient;
    }

    public long getTimeSent() {
        return this.timeSent;
    }

    public boolean isToRecipient() {
        return this.toRecipient;
    }
}

