/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.party;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.util.Parser;

public class PartyManager {
    private Map<UUID, Party> partyMap = new HashMap<UUID, Party>();
    private File partyFolder = new File(McRPG.getInstance().getDataFolder(), "parties");

    public PartyManager() {
        if (!this.partyFolder.exists()) {
            this.partyFolder.mkdirs();
        }
    }

    public void init() {
        if (this.partyFolder.listFiles() != null && this.partyFolder.listFiles().length > 0) {
            for (File file : this.partyFolder.listFiles()) {
                final Party party = new Party(file);
                if (party.getAllMemberUUIDs() == null) {
                    new BukkitRunnable(){

                        public void run() {
                            PartyManager.this.removeParty(party.getPartyID());
                        }
                    }.runTaskLater((Plugin)McRPG.getInstance(), 1L);
                }
                this.partyMap.put(party.getPartyID(), party);
            }
        }
    }

    public Party getParty(UUID uUID) {
        return this.partyMap.getOrDefault(uUID, null);
    }

    public boolean isPartyNameUsed(String string) {
        for (Party party : this.partyMap.values()) {
            if (!party.getName().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public Party addParty(String string, UUID uUID) {
        Party party = new Party(uUID, string);
        this.partyMap.put(party.getPartyID(), party);
        return party;
    }

    public Parser getExpEquation() {
        return new Parser(McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getString("PartyExp.ExpEquation"));
    }

    public int getMaxLevel() {
        return McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("PartyExp.MaxLevel", 10);
    }

    public void removeParty(UUID uUID) {
        this.partyMap.remove(uUID).disband(true);
    }

    public Collection<Party> getParties() {
        return this.partyMap.values();
    }

    public void saveAllParties() {
        for (Party party : this.partyMap.values()) {
            party.saveParty();
        }
    }
}

