/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.party;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.events.mcrpg.party.PartyDisbandEvent;
import us.eunoians.mcrpg.api.events.mcrpg.party.PartyExpGainEvent;
import us.eunoians.mcrpg.api.events.mcrpg.party.PartyLevelUpEvent;
import us.eunoians.mcrpg.api.events.mcrpg.party.PlayerJoinPartyEvent;
import us.eunoians.mcrpg.api.events.mcrpg.party.PlayerKickPartyEvent;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.nbtapi.NBTItem;
import us.eunoians.mcrpg.party.PartyInvite;
import us.eunoians.mcrpg.party.PartyMember;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.PartyPermissions;
import us.eunoians.mcrpg.types.PartyRoles;
import us.eunoians.mcrpg.types.PartyUpgrades;
import us.eunoians.mcrpg.util.Parser;

public class Party {
    private static ItemStack fillerGlass;
    private Map<PartyPermissions, PartyRoles> partyPermissions = new HashMap<PartyPermissions, PartyRoles>();
    private Map<PartyUpgrades, Integer> partyUpgrades = new HashMap<PartyUpgrades, Integer>();
    private Map<UUID, PartyMember> partyMembers = new HashMap<UUID, PartyMember>();
    private String name;
    private UUID partyID;
    private int partyUpgradePoints;
    private Inventory partyBank;
    private Inventory privateBank;
    private int partyLevel;
    private int partyExp;
    private int expToLevel;
    private FileConfiguration partyFileConfiguration;
    private File partyFile;

    Party(UUID uUID, String string) {
        this.partyID = UUID.randomUUID();
        File file = new File(McRPG.getInstance().getDataFolder(), "parties");
        if (!file.exists()) {
            file.mkdirs();
        }
        this.partyFile = new File(McRPG.getInstance().getDataFolder(), "parties" + File.separator + this.partyID.toString() + ".yml");
        if (!this.partyFile.exists()) {
            try {
                this.partyFile.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.partyFileConfiguration = YamlConfiguration.loadConfiguration((File)this.partyFile);
        PartyMember partyMember = new PartyMember(uUID);
        partyMember.setPartyRole(PartyRoles.OWNER);
        String string2 = "PartyMembers." + uUID.toString() + ".";
        this.partyFileConfiguration.set(string2 + "JoinDate", (Object)partyMember.getJoinDate());
        this.partyFileConfiguration.set(string2 + "Role", (Object)partyMember.getPartyRole().getId());
        this.partyMembers.put(uUID, partyMember);
        this.name = string;
        this.partyUpgradePoints = 0;
        this.partyExp = 0;
        this.partyLevel = 0;
        this.initPerms();
        this.initUpgrades();
        this.initBanks();
        this.calculateExpToLevel();
        this.saveParty();
    }

    Party(File file) {
        PartyMember partyMember;
        PartyRoles partyRoles;
        Object object;
        this.partyID = UUID.fromString(file.getName().replace(".yml", ""));
        this.partyFile = file;
        this.partyFileConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!this.partyFileConfiguration.contains("PartyMembers")) {
            this.partyMembers = null;
            return;
        }
        for (String object2 : this.partyFileConfiguration.getConfigurationSection("PartyMembers").getKeys(false)) {
            object = UUID.fromString(object2);
            partyRoles = PartyRoles.getRoleFromId(this.partyFileConfiguration.getInt("PartyMembers." + object2 + ".Role"));
            partyMember = new PartyMember((UUID)object, partyRoles, this.partyFileConfiguration.getLong("PartyMembers." + object2 + ".JoinDate"));
            this.partyMembers.put((UUID)object, partyMember);
        }
        this.name = this.partyFileConfiguration.getString("PartyName");
        this.partyUpgradePoints = this.partyFileConfiguration.getInt("PartyUpgradePoints");
        this.partyExp = this.partyFileConfiguration.getInt("PartyExp");
        this.partyLevel = this.partyFileConfiguration.getInt("PartyLevel");
        this.calculateExpToLevel();
        for (String string : this.partyFileConfiguration.getConfigurationSection("Permissions").getKeys(false)) {
            object = PartyPermissions.getPartyPermission(string);
            this.partyPermissions.put((PartyPermissions)((Object)object), PartyRoles.getRoleFromId(this.partyFileConfiguration.getInt("Permissions." + string)));
        }
        for (String string : this.partyFileConfiguration.getConfigurationSection("Upgrades").getKeys(false)) {
            this.partyUpgrades.put(PartyUpgrades.getPartyUpgrades(string), this.partyFileConfiguration.getInt("Upgrades." + string));
        }
        this.initBanks();
        if (this.partyFileConfiguration.contains("PartyBank")) {
            for (String string : this.partyFileConfiguration.getConfigurationSection("PartyBank").getKeys(false)) {
                int n = Integer.parseInt(string.replace("Item", ""));
                this.partyBank.setItem(n, this.partyFileConfiguration.getItemStack("PartyBank." + string));
            }
        }
        if (this.partyFileConfiguration.contains("PrivateBank")) {
            for (String string : this.partyFileConfiguration.getConfigurationSection("PrivateBank").getKeys(false)) {
                int n = Integer.parseInt(string.replace("Item", ""));
                this.privateBank.setItem(n, this.partyFileConfiguration.getItemStack("PrivateBank." + string));
            }
        }
        for (UUID uUID : this.getAllMemberUUIDs()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
            partyRoles = new ItemStack(Material.PLAYER_HEAD);
            partyMember = partyRoles.getItemMeta();
            SkullMeta skullMeta = (SkullMeta)partyMember;
            skullMeta.setOwningPlayer(offlinePlayer);
            partyRoles.setItemMeta((ItemMeta)skullMeta);
        }
    }

    private void initPerms() {
        this.partyPermissions.put(PartyPermissions.UPGRADE_PARTY, PartyRoles.OWNER);
        this.partyPermissions.put(PartyPermissions.PVP, PartyRoles.MEMBER);
        this.partyPermissions.put(PartyPermissions.PRIVATE_BANK, PartyRoles.MOD);
        this.partyPermissions.put(PartyPermissions.KICK_PLAYERS, PartyRoles.MOD);
        this.partyPermissions.put(PartyPermissions.INVITE_PLAYERS, PartyRoles.MOD);
    }

    private void initUpgrades() {
        this.partyUpgrades.put(PartyUpgrades.MEMBER_COUNT, 0);
        this.partyUpgrades.put(PartyUpgrades.EXP_SHARE_AMOUNT, 0);
        this.partyUpgrades.put(PartyUpgrades.EXP_SHARE_RANGE, 0);
        this.partyUpgrades.put(PartyUpgrades.PRIVATE_BANK_SIZE, 0);
    }

    private void initBanks() {
        int n;
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG);
        this.partyBank = Bukkit.createInventory(null, (int)fileConfiguration.getInt("PartyBank.Size"), (String)Methods.color(fileConfiguration.getString("PartyBank.Title")));
        this.privateBank = Bukkit.createInventory(null, (int)(n += (n = PartyUpgrades.getPrivateBankSizeAtTier(this.partyUpgrades.get((Object)PartyUpgrades.PRIVATE_BANK_SIZE))) % 9 != 0 ? 9 - n % 9 : 0), (String)Methods.color(fileConfiguration.getString("PrivateBank.Title", "&5Private Bank")));
        if (fillerGlass == null) {
            fillerGlass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
            ItemMeta itemMeta = fillerGlass.getItemMeta();
            itemMeta.setDisplayName(" ");
            fillerGlass.setItemMeta(itemMeta);
            NBTItem nBTItem = new NBTItem(fillerGlass);
            nBTItem.setBoolean("PlaceHolder", true);
            fillerGlass = nBTItem.getItem();
        }
        for (int i = PartyUpgrades.getPrivateBankSizeAtTier(this.partyUpgrades.get((Object)PartyUpgrades.PRIVATE_BANK_SIZE)); i < this.privateBank.getSize(); ++i) {
            this.privateBank.setItem(i, fillerGlass);
        }
    }

    public void addPlayer(UUID uUID) {
        PlayerJoinPartyEvent playerJoinPartyEvent = new PlayerJoinPartyEvent(uUID, this);
        Bukkit.getPluginManager().callEvent((Event)playerJoinPartyEvent);
        PartyMember partyMember = new PartyMember(uUID);
        this.partyMembers.put(uUID, partyMember);
    }

    public boolean kickPlayer(UUID uUID) {
        if (this.partyMembers.containsKey(uUID)) {
            PlayerKickPartyEvent playerKickPartyEvent = new PlayerKickPartyEvent(uUID, this);
            Bukkit.getPluginManager().callEvent((Event)playerKickPartyEvent);
            if (playerKickPartyEvent.isCancelled()) {
                return false;
            }
            PartyMember partyMember = this.partyMembers.remove(uUID);
            if (partyMember.getPartyRole() == PartyRoles.OWNER) {
                PartyMember partyMember2 = null;
                for (PartyMember partyMember3 : this.partyMembers.values()) {
                    if (partyMember2 == null) {
                        partyMember2 = partyMember3;
                        continue;
                    }
                    if (partyMember2.getPartyRole() == PartyRoles.MOD && partyMember3.getPartyRole() == PartyRoles.MEMBER) continue;
                    if (partyMember2.getPartyRole() == PartyRoles.MEMBER && partyMember3.getPartyRole() == PartyRoles.MOD) {
                        partyMember2 = partyMember3;
                        continue;
                    }
                    if (partyMember2.getJoinDate() > partyMember3.getJoinDate()) {
                        partyMember2 = partyMember3;
                        continue;
                    }
                    Bukkit.getLogger().log(Level.WARNING, Methods.color("&cThere was an issue with promoting a new player to owner"));
                }
                if (partyMember2 == null) {
                    McRPG.getInstance().getPartyManager().removeParty(this.partyID);
                    return true;
                }
                partyMember2.setPartyRole(PartyRoles.OWNER);
            }
            return true;
        }
        return false;
    }

    public boolean invitePlayer(UUID uUID) {
        try {
            McRPGPlayer mcRPGPlayer = PlayerManager.getPlayer(uUID);
            if (mcRPGPlayer.getPartyID() == null) {
                PartyInvite partyInvite = new PartyInvite(this.partyID, uUID);
                mcRPGPlayer.getPartyInvites().enqueue((Object)partyInvite);
                return true;
            }
            return false;
        }
        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
            return false;
        }
    }

    public void disband(boolean bl) {
        PartyDisbandEvent partyDisbandEvent = new PartyDisbandEvent(this);
        Bukkit.getPluginManager().callEvent((Event)partyDisbandEvent);
        if (this.partyMembers != null) {
            for (UUID uUID : this.partyMembers.keySet()) {
                McRPGPlayer mcRPGPlayer;
                try {
                    mcRPGPlayer = PlayerManager.getPlayer(uUID);
                    mcRPGPlayer.emptyTeleportRequests();
                }
                catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                    mcRPGPlayer = new McRPGPlayer(uUID);
                }
                mcRPGPlayer.setPartyID(null);
                mcRPGPlayer.saveData();
            }
        }
        if (bl) {
            this.partyFile.delete();
        }
    }

    public void giveExp(int n) {
        if (n <= 0) {
            return;
        }
        if (this.partyLevel >= McRPG.getInstance().getPartyManager().getMaxLevel()) {
            return;
        }
        PartyExpGainEvent partyExpGainEvent = new PartyExpGainEvent(this, n);
        Bukkit.getPluginManager().callEvent((Event)partyExpGainEvent);
        if (!partyExpGainEvent.isCancelled()) {
            this.partyExp += partyExpGainEvent.getExpGained();
            int n2 = 0;
            while (this.partyExp >= this.expToLevel) {
                ++this.partyLevel;
                ++n2;
                this.partyExp -= this.expToLevel;
                this.calculateExpToLevel();
            }
            if (n2 > 0) {
                PartyLevelUpEvent partyLevelUpEvent = new PartyLevelUpEvent(this, this.partyLevel - n2, this.partyLevel);
                Bukkit.getPluginManager().callEvent((Event)partyLevelUpEvent);
                for (int i = 1; i <= n2; ++i) {
                    if (this.partyLevel + i > McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("PartyExp.MaxLevelForUpgradePoints", 20) || (this.partyLevel + i) % McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("PartyExp.UpgradePointFactor", 1) != 0) continue;
                    ++this.partyUpgradePoints;
                }
                this.partyLevel = partyLevelUpEvent.getNewLevel();
            }
        }
    }

    public void reduceAbilityPoints(int n, int n2) {
        for (int i = 1; i < n2 - n; ++i) {
            if (n + i < 0 || (n + i) % McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("PartyExp.UpgradePointFactor", 1) != 0) continue;
            --this.partyUpgradePoints;
        }
    }

    private void calculateExpToLevel() {
        Parser parser = McRPG.getInstance().getPartyManager().getExpEquation();
        parser.setVariable("party_level", this.partyLevel);
        this.expToLevel = (int)parser.getValue();
    }

    public List<Player> getOnlinePlayers() {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        for (UUID uUID : this.partyMembers.keySet()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
            if (!offlinePlayer.isOnline()) continue;
            arrayList.add((Player)offlinePlayer);
        }
        return arrayList;
    }

    public int purgeInactive(int n) {
        HashSet<UUID> hashSet = new HashSet<UUID>();
        if (this.partyMembers == null) {
            return 0;
        }
        for (UUID uUID : this.partyMembers.keySet()) {
            if (Methods.findHoursDiffFromCurrent(Bukkit.getOfflinePlayer((UUID)uUID).getLastPlayed()) < n) continue;
            hashSet.add(uUID);
        }
        hashSet.forEach(this::kickPlayer);
        if (hashSet.size() > 0) {
            for (UUID uUID : this.partyMembers.keySet()) {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
                if (!offlinePlayer.isOnline()) continue;
                ((Player)offlinePlayer).sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + "&c" + hashSet.size() + " players were removed from your party due to inactivity"));
            }
        }
        this.saveParty();
        return hashSet.size();
    }

    public PartyRoles getRoleForPermission(PartyPermissions partyPermissions) {
        return this.partyPermissions.get((Object)partyPermissions);
    }

    public void setRoleForPermission(PartyPermissions partyPermissions, PartyRoles partyRoles) {
        this.partyPermissions.replace(partyPermissions, partyRoles);
    }

    public int getUpgradeTier(PartyUpgrades partyUpgrades) {
        return this.partyUpgrades.get((Object)partyUpgrades);
    }

    public void setUpgradeTier(PartyUpgrades partyUpgrades, int n) {
        this.partyUpgrades.replace(partyUpgrades, n);
        if (partyUpgrades == PartyUpgrades.PRIVATE_BANK_SIZE) {
            int n2;
            int n3;
            Inventory inventory = Bukkit.createInventory(null, (int)(n3 += (n3 = PartyUpgrades.getPrivateBankSizeAtTier(this.partyUpgrades.get((Object)PartyUpgrades.PRIVATE_BANK_SIZE))) % 9 != 0 ? 9 - n3 % 9 : 0), (String)Methods.color("&5Private Bank"));
            ItemStack[] itemStackArray = this.privateBank.getContents();
            for (n2 = 0; n2 < itemStackArray.length; ++n2) {
                if (itemStackArray[n2] == null || !itemStackArray[n2].equals((Object)fillerGlass)) continue;
                itemStackArray[n2] = null;
            }
            inventory.setContents(itemStackArray);
            for (n2 = PartyUpgrades.getPrivateBankSizeAtTier(this.partyUpgrades.get((Object)PartyUpgrades.PRIVATE_BANK_SIZE)); n2 < inventory.getSize(); ++n2) {
                inventory.setItem(n2, fillerGlass);
            }
            List list = this.privateBank.getViewers();
            this.privateBank = inventory;
            for (final HumanEntity humanEntity : list) {
                humanEntity.closeInventory();
                new BukkitRunnable(){

                    public void run() {
                        humanEntity.openInventory(Party.this.privateBank);
                    }
                }.runTaskLater((Plugin)McRPG.getInstance(), 1L);
            }
        }
    }

    public PartyMember getPartyMember(UUID uUID) {
        return this.partyMembers.get(uUID);
    }

    public boolean isPlayerInParty(UUID uUID) {
        return this.partyMembers.containsKey(uUID);
    }

    public Set<UUID> getAllMemberUUIDs() {
        return this.partyMembers == null ? null : this.partyMembers.keySet();
    }

    public Collection<PartyMember> getAllMembers() {
        return this.partyMembers.values();
    }

    /*
     * WARNING - void declaration
     */
    public void saveParty() {
        void var4_13;
        void var4_11;
        this.partyFileConfiguration.set("PartyMembers", null);
        String string = "PartyMembers.";
        for (UUID object2 : this.partyMembers.keySet()) {
            PartyMember iOException = this.partyMembers.get(object2);
            String string2 = string + object2.toString() + ".";
            this.partyFileConfiguration.set(string2 + "JoinDate", (Object)iOException.getJoinDate());
            this.partyFileConfiguration.set(string2 + "Role", (Object)iOException.getPartyRole().getId());
        }
        String string3 = "Permissions.";
        for (PartyPermissions partyPermissions : this.partyPermissions.keySet()) {
            this.partyFileConfiguration.set((String)string3 + partyPermissions.getName().replace(" ", ""), (Object)this.partyPermissions.get((Object)partyPermissions).getId());
        }
        String string4 = "Upgrades.";
        for (PartyUpgrades partyUpgrades : PartyUpgrades.values()) {
            this.partyFileConfiguration.set(string4 + partyUpgrades.getName().replace(" ", ""), (Object)this.partyUpgrades.get((Object)partyUpgrades));
        }
        this.partyFileConfiguration.set("PartyName", (Object)this.name);
        this.partyFileConfiguration.set("PartyUpgradePoints", (Object)this.partyUpgradePoints);
        this.partyFileConfiguration.set("PartyExp", (Object)this.partyExp);
        this.partyFileConfiguration.set("PartyLevel", (Object)this.partyLevel);
        boolean bl = false;
        while (var4_11 < McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getInt("PartyBank.Size", 27) && var4_11 < this.partyBank.getSize()) {
            ItemStack itemStack = this.partyBank.getItem((int)var4_11);
            if (itemStack != null && itemStack.getType() != Material.AIR) {
                this.partyFileConfiguration.set("PartyBank.Item" + (int)var4_11, (Object)itemStack);
            }
            ++var4_11;
        }
        boolean bl2 = false;
        while (var4_13 < PartyUpgrades.getPrivateBankSizeAtTier(this.getUpgradeTier(PartyUpgrades.PRIVATE_BANK_SIZE))) {
            if (var4_13 >= this.privateBank.getSize()) {
                Bukkit.getLogger().log(Level.WARNING, "Private bank size is mismatched");
                return;
            }
            ItemStack itemStack = this.privateBank.getItem((int)var4_13);
            if (itemStack != null && itemStack.getType() != Material.AIR) {
                this.partyFileConfiguration.set("PrivateBank.Item" + (int)var4_13, (Object)itemStack);
            }
            ++var4_13;
        }
        try {
            this.partyFileConfiguration.save(this.partyFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static ItemStack getFillerGlass() {
        return fillerGlass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public UUID getPartyID() {
        return this.partyID;
    }

    public int getPartyUpgradePoints() {
        return this.partyUpgradePoints;
    }

    public void setPartyUpgradePoints(int n) {
        this.partyUpgradePoints = n;
    }

    public Inventory getPartyBank() {
        return this.partyBank;
    }

    public Inventory getPrivateBank() {
        return this.privateBank;
    }

    public int getPartyLevel() {
        return this.partyLevel;
    }

    public void setPartyLevel(int n) {
        this.partyLevel = n;
    }

    public int getPartyExp() {
        return this.partyExp;
    }

    public void setPartyExp(int n) {
        this.partyExp = n;
    }

    public int getExpToLevel() {
        return this.expToLevel;
    }

    public void setExpToLevel(int n) {
        this.expToLevel = n;
    }
}

