/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.nbtapi.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import us.eunoians.mcrpg.nbtapi.NBTItem;
import us.eunoians.mcrpg.nbtapi.utils.MinecraftVersion;

public class VersionChecker {
    private static final String USER_AGENT = "nbt-api Version check";
    private static final String REQUEST_URL = "https://api.spiget.org/v2/resources/7939/versions?size=100";

    protected static void checkForUpdates() {
        URL uRL = new URL(REQUEST_URL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.addRequestProperty("User-Agent", USER_AGENT);
        InputStream inputStream = httpURLConnection.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        JsonElement jsonElement = new JsonParser().parse((Reader)inputStreamReader);
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            JsonObject jsonObject = (JsonObject)jsonArray.get(jsonArray.size() - 1);
            int n = VersionChecker.getVersionDifference(jsonObject.get("name").getAsString());
            if (n == -1) {
                MinecraftVersion.logger.log(Level.WARNING, "[NBTAPI] The NBT-API at '" + NBTItem.class.getPackage() + "' seems to be outdated!");
                MinecraftVersion.logger.log(Level.WARNING, "[NBTAPI] Current Version: '2.4.0-SNAPSHOT' Newest Version: " + jsonObject.get("name").getAsString() + "'");
                MinecraftVersion.logger.log(Level.WARNING, "[NBTAPI] Please update the nbt-api or the plugin that contains the api!");
            } else if (n == 0) {
                MinecraftVersion.logger.log(Level.INFO, "[NBTAPI] The NBT-API seems to be up-to-date!");
            } else if (n == 1) {
                MinecraftVersion.logger.log(Level.WARNING, "[NBTAPI] The NBT-API at '" + NBTItem.class.getPackage() + "' seems to be a future Version, not yet released on Spigot!");
                MinecraftVersion.logger.log(Level.WARNING, "[NBTAPI] Current Version: '2.4.0-SNAPSHOT' Newest Version: " + jsonObject.get("name").getAsString() + "'");
            }
        } else {
            MinecraftVersion.logger.log(Level.WARNING, "[NBTAPI] Error when looking for Updates! Got non Json Array: '" + jsonElement.toString() + "'");
        }
    }

    private static int getVersionDifference(String string) {
        int n;
        String string2 = "2.4.0-SNAPSHOT";
        if (string2.equals(string)) {
            return 0;
        }
        String string3 = "\\.";
        if (string2.split(string3).length != 3 || string.split(string3).length != 3) {
            return -1;
        }
        int n2 = Integer.parseInt(string2.split(string3)[0]);
        int n3 = Integer.parseInt(string2.split(string3)[1]);
        String string4 = string2.split(string3)[2];
        int n4 = Integer.parseInt(string.split(string3)[0]);
        int n5 = Integer.parseInt(string.split(string3)[1]);
        String string5 = string.split(string3)[2];
        if (n2 < n4) {
            return -1;
        }
        if (n2 > n4) {
            return 1;
        }
        if (n3 < n5) {
            return -1;
        }
        if (n3 > n5) {
            return 1;
        }
        int n6 = Integer.parseInt(string4.split("-")[0]);
        if (n6 < (n = Integer.parseInt(string5.split("-")[0]))) {
            return -1;
        }
        if (n6 > n) {
            return 1;
        }
        if (!string5.contains("-") && string4.contains("-")) {
            return -1;
        }
        if (string5.contains("-") && string4.contains("-")) {
            return 0;
        }
        return 1;
    }
}

