/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.nbtapi.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import us.eunoians.mcrpg.nbtapi.utils.MinecraftVersion;

public class ApiMetricsLite {
    private static final String PLUGINNAME = "ItemNBTAPI";
    public static final int B_STATS_VERSION = 1;
    public static final int NBT_BSTATS_VERSION = 1;
    private static final String URL = "https://bStats.org/submitData/bukkit";
    private boolean enabled;
    private static boolean logFailedRequests;
    private static boolean logSentData;
    private static boolean logResponseStatusText;
    private static String serverUUID;
    private Plugin plugin;

    public ApiMetricsLite() {
        Object object = Bukkit.getPluginManager().getPlugins();
        int n = ((Plugin[])object).length;
        for (int i = 0; i < n; ++i) {
            Plugin plugin;
            this.plugin = plugin = object[i];
            if (this.plugin != null) break;
        }
        if (this.plugin == null) {
            return;
        }
        object = new File(this.plugin.getDataFolder().getParentFile(), "bStats");
        File file = new File((File)object, "config.yml");
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!yamlConfiguration.isSet("serverUuid")) {
            yamlConfiguration.addDefault("enabled", (Object)true);
            yamlConfiguration.addDefault("serverUuid", (Object)UUID.randomUUID().toString());
            yamlConfiguration.addDefault("logFailedRequests", (Object)false);
            yamlConfiguration.addDefault("logSentData", (Object)false);
            yamlConfiguration.addDefault("logResponseStatusText", (Object)false);
            yamlConfiguration.options().header("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo honor their work, you should not disable it.\nThis has nearly no effect on the server performance!\nCheck out https://bStats.org/ to learn more :)").copyDefaults(true);
            try {
                yamlConfiguration.save(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        serverUUID = yamlConfiguration.getString("serverUuid");
        logFailedRequests = yamlConfiguration.getBoolean("logFailedRequests", false);
        this.enabled = yamlConfiguration.getBoolean("enabled", true);
        logSentData = yamlConfiguration.getBoolean("logSentData", false);
        logResponseStatusText = yamlConfiguration.getBoolean("logResponseStatusText", false);
        if (this.enabled) {
            boolean bl = false;
            for (Class clazz : Bukkit.getServicesManager().getKnownServices()) {
                try {
                    clazz.getField("NBT_BSTATS_VERSION");
                    return;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    try {
                        clazz.getField("B_STATS_VERSION");
                        bl = true;
                        break;
                    }
                    catch (NoSuchFieldException noSuchFieldException2) {
                    }
                }
            }
            boolean bl2 = bl;
            if (Bukkit.isPrimaryThread()) {
                Bukkit.getServicesManager().register(ApiMetricsLite.class, (Object)this, this.plugin, ServicePriority.Normal);
                if (!bl2) {
                    MinecraftVersion.logger.info("[NBTAPI] Using the plugin '" + this.plugin.getName() + "' to create a bStats instance!");
                    this.startSubmitting();
                }
            } else {
                Bukkit.getScheduler().runTask(this.plugin, () -> {
                    Bukkit.getServicesManager().register(ApiMetricsLite.class, (Object)this, this.plugin, ServicePriority.Normal);
                    if (!bl2) {
                        MinecraftVersion.logger.info("[NBTAPI] Using the plugin '" + this.plugin.getName() + "' to create a bStats instance!");
                        this.startSubmitting();
                    }
                });
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void startSubmitting() {
        final Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!ApiMetricsLite.this.plugin.isEnabled()) {
                    timer.cancel();
                    return;
                }
                Bukkit.getScheduler().runTask(ApiMetricsLite.this.plugin, () -> ApiMetricsLite.this.submitData());
            }
        }, 300000L, 1800000L);
    }

    public JsonObject getPluginData() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("pluginName", PLUGINNAME);
        jsonObject.addProperty("pluginVersion", "2.4.0-SNAPSHOT");
        jsonObject.add("customCharts", (JsonElement)new JsonArray());
        return jsonObject;
    }

    private JsonObject getServerData() {
        int n;
        try {
            Method method = Class.forName("org.bukkit.Server").getMethod("getOnlinePlayers", new Class[0]);
            n = method.getReturnType().equals(Collection.class) ? ((Collection)method.invoke((Object)Bukkit.getServer(), new Object[0])).size() : ((Player[])method.invoke((Object)Bukkit.getServer(), new Object[0])).length;
        }
        catch (Exception exception) {
            n = Bukkit.getOnlinePlayers().size();
        }
        int n2 = Bukkit.getOnlineMode() ? 1 : 0;
        String string = Bukkit.getVersion();
        String string2 = Bukkit.getName();
        String string3 = System.getProperty("java.version");
        String string4 = System.getProperty("os.name");
        String string5 = System.getProperty("os.arch");
        String string6 = System.getProperty("os.version");
        int n3 = Runtime.getRuntime().availableProcessors();
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("serverUUID", serverUUID);
        jsonObject.addProperty("playerAmount", (Number)n);
        jsonObject.addProperty("onlineMode", (Number)n2);
        jsonObject.addProperty("bukkitVersion", string);
        jsonObject.addProperty("bukkitName", string2);
        jsonObject.addProperty("javaVersion", string3);
        jsonObject.addProperty("osName", string4);
        jsonObject.addProperty("osArch", string5);
        jsonObject.addProperty("osVersion", string6);
        jsonObject.addProperty("coreCount", (Number)n3);
        return jsonObject;
    }

    private void submitData() {
        final JsonObject jsonObject = this.getServerData();
        JsonArray jsonArray = new JsonArray();
        for (Class clazz : Bukkit.getServicesManager().getKnownServices()) {
            try {
                clazz.getField("B_STATS_VERSION");
                for (RegisteredServiceProvider registeredServiceProvider : Bukkit.getServicesManager().getRegistrations(clazz)) {
                    try {
                        Object object = registeredServiceProvider.getService().getMethod("getPluginData", new Class[0]).invoke(registeredServiceProvider.getProvider(), new Object[0]);
                        if (object instanceof JsonObject) {
                            jsonArray.add((JsonElement)((JsonObject)object));
                            continue;
                        }
                        try {
                            Class<?> clazz2 = Class.forName("org.json.simple.JSONObject");
                            if (!object.getClass().isAssignableFrom(clazz2)) continue;
                            Method method = clazz2.getDeclaredMethod("toJSONString", new Class[0]);
                            method.setAccessible(true);
                            String string = (String)method.invoke(object, new Object[0]);
                            JsonObject jsonObject2 = new JsonParser().parse(string).getAsJsonObject();
                            jsonArray.add((JsonElement)jsonObject2);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (!logFailedRequests) continue;
                            MinecraftVersion.logger.log(Level.WARNING, "[NBTAPI][BSTATS] Encountered exception while posting request!", classNotFoundException);
                        }
                    }
                    catch (IllegalAccessException | NoSuchMethodException | NullPointerException | InvocationTargetException exception) {}
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
        }
        jsonObject.add("plugins", (JsonElement)jsonArray);
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        ApiMetricsLite.sendData(ApiMetricsLite.this.plugin, jsonObject);
                    }
                    catch (Exception exception) {
                        if (!logFailedRequests) break block2;
                        MinecraftVersion.logger.log(Level.WARNING, "[NBTAPI][BSTATS] Could not submit plugin stats of " + ApiMetricsLite.this.plugin.getName(), exception);
                    }
                }
            }
        }).start();
    }

    private static void sendData(Plugin plugin, JsonObject jsonObject) {
        String string;
        if (jsonObject == null) {
            throw new IllegalArgumentException("Data cannot be null!");
        }
        if (Bukkit.isPrimaryThread()) {
            throw new IllegalAccessException("This method must not be called from the main thread!");
        }
        if (logSentData) {
            System.out.println("[NBTAPI][BSTATS] Sending data to bStats: " + jsonObject.toString());
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] byArray = ApiMetricsLite.compress(jsonObject.toString());
        httpsURLConnection.setRequestMethod("POST");
        httpsURLConnection.addRequestProperty("Accept", "application/json");
        httpsURLConnection.addRequestProperty("Connection", "close");
        httpsURLConnection.addRequestProperty("Content-Encoding", "gzip");
        httpsURLConnection.addRequestProperty("Content-Length", String.valueOf(byArray.length));
        httpsURLConnection.setRequestProperty("Content-Type", "application/json");
        httpsURLConnection.setRequestProperty("User-Agent", "MC-Server/1");
        httpsURLConnection.setDoOutput(true);
        DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
        dataOutputStream.write(byArray);
        dataOutputStream.flush();
        dataOutputStream.close();
        InputStream inputStream = httpsURLConnection.getInputStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        bufferedReader.close();
        if (logResponseStatusText) {
            MinecraftVersion.logger.info("[NBTAPI][BSTATS] Sent data to bStats and received response: " + stringBuilder.toString());
        }
    }

    private static byte[] compress(String string) {
        if (string == null) {
            return new byte[0];
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
        gZIPOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }
}

