/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.nbtapi;

import org.bukkit.block.BlockState;
import us.eunoians.mcrpg.nbtapi.NBTCompound;
import us.eunoians.mcrpg.nbtapi.NBTContainer;
import us.eunoians.mcrpg.nbtapi.NBTReflectionUtil;
import us.eunoians.mcrpg.nbtapi.utils.MinecraftVersion;
import us.eunoians.mcrpg.nbtapi.utils.annotations.AvaliableSince;
import us.eunoians.mcrpg.nbtapi.utils.annotations.CheckUtil;
import us.eunoians.mcrpg.nbtapi.utils.annotations.FAUtil;

public class NBTTileEntity
extends NBTCompound {
    private final BlockState tile;

    public NBTTileEntity(BlockState blockState) {
        super(null, null);
        if (blockState == null || !blockState.isPlaced()) {
            throw new NullPointerException("Tile can't be null/not placed!");
        }
        this.tile = blockState;
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getTileEntityNBTTagCompound(this.tile);
    }

    @Override
    protected void setCompound(Object object) {
        NBTReflectionUtil.setTileEntityNBTTagCompound(this.tile, object);
    }

    @AvaliableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        if (this.hasKey("PublicBukkitValues").booleanValue()) {
            return this.getCompound("PublicBukkitValues");
        }
        NBTContainer nBTContainer = new NBTContainer();
        nBTContainer.addCompound("PublicBukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(nBTContainer);
        return this.getCompound("PublicBukkitValues");
    }
}

