/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.nbtapi;

import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import us.eunoians.mcrpg.nbtapi.NBTCompound;
import us.eunoians.mcrpg.nbtapi.NBTContainer;
import us.eunoians.mcrpg.nbtapi.NBTReflectionUtil;
import us.eunoians.mcrpg.nbtapi.utils.nmsmappings.ReflectionMethod;

public class NBTItem
extends NBTCompound {
    private ItemStack bukkitItem;

    public NBTItem(ItemStack itemStack) {
        super(null, null);
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            throw new NullPointerException("ItemStack can't be null/Air!");
        }
        this.bukkitItem = itemStack.clone();
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getItemRootNBTTagCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem));
    }

    @Override
    protected void setCompound(Object object) {
        Object object2 = ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, this.bukkitItem);
        ReflectionMethod.ITEMSTACK_SET_TAG.run(object2, object);
        this.bukkitItem = (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, object2);
    }

    public ItemStack getItem() {
        return this.bukkitItem;
    }

    protected void setItem(ItemStack itemStack) {
        this.bukkitItem = itemStack;
    }

    public boolean hasNBTData() {
        return this.getCompound() != null;
    }

    public static NBTContainer convertItemtoNBT(ItemStack itemStack) {
        return NBTReflectionUtil.convertNMSItemtoNBTCompound(ReflectionMethod.ITEMSTACK_NMSCOPY.run(null, itemStack));
    }

    public static ItemStack convertNBTtoItem(NBTCompound nBTCompound) {
        return (ItemStack)ReflectionMethod.ITEMSTACK_BUKKITMIRROR.run(null, NBTReflectionUtil.convertNBTCompoundtoNMSItem(nBTCompound));
    }
}

