/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.nbtapi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import us.eunoians.mcrpg.nbtapi.NBTCompound;
import us.eunoians.mcrpg.nbtapi.NBTReflectionUtil;
import us.eunoians.mcrpg.nbtapi.utils.nmsmappings.ObjectCreator;

public class NBTFile
extends NBTCompound {
    private final File file;
    private Object nbt;

    public NBTFile(File file) {
        super(null, null);
        if (file == null) {
            throw new NullPointerException("File can't be null!");
        }
        this.file = file;
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.nbt = NBTReflectionUtil.readNBT(fileInputStream);
        } else {
            this.nbt = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
            this.save();
        }
    }

    public void save() {
        try {
            this.getWriteLock().lock();
            if (!this.file.exists()) {
                this.file.getParentFile().mkdirs();
                if (!this.file.createNewFile()) {
                    throw new IOException("Unable to create file at " + this.file.getAbsolutePath());
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.file);
            NBTReflectionUtil.writeNBT(this.nbt, fileOutputStream);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public Object getCompound() {
        return this.nbt;
    }

    @Override
    protected void setCompound(Object object) {
        this.nbt = object;
    }
}

