/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.nbtapi;

import org.bukkit.entity.Entity;
import us.eunoians.mcrpg.nbtapi.NBTCompound;
import us.eunoians.mcrpg.nbtapi.NBTContainer;
import us.eunoians.mcrpg.nbtapi.NBTReflectionUtil;
import us.eunoians.mcrpg.nbtapi.utils.MinecraftVersion;
import us.eunoians.mcrpg.nbtapi.utils.annotations.AvaliableSince;
import us.eunoians.mcrpg.nbtapi.utils.annotations.CheckUtil;
import us.eunoians.mcrpg.nbtapi.utils.annotations.FAUtil;

public class NBTEntity
extends NBTCompound {
    private final Entity ent;

    public NBTEntity(Entity entity) {
        super(null, null);
        if (entity == null) {
            throw new NullPointerException("Entity can't be null!");
        }
        this.ent = entity;
    }

    @Override
    public Object getCompound() {
        return NBTReflectionUtil.getEntityNBTTagCompound(NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @Override
    protected void setCompound(Object object) {
        NBTReflectionUtil.setEntityNBTTag(object, NBTReflectionUtil.getNMSEntity(this.ent));
    }

    @AvaliableSince(version=MinecraftVersion.MC1_14_R1)
    public NBTCompound getPersistentDataContainer() {
        FAUtil.check(this::getPersistentDataContainer, CheckUtil::isAvaliable);
        if (this.hasKey("BukkitValues").booleanValue()) {
            return this.getCompound("BukkitValues");
        }
        NBTContainer nBTContainer = new NBTContainer();
        nBTContainer.addCompound("BukkitValues").setString("__nbtapi", "Marker to make the PersistentDataContainer have content");
        this.mergeCompound(nBTContainer);
        return this.getCompound("BukkitValues");
    }
}

