/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.nbtapi;

import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.inventory.ItemStack;
import us.eunoians.mcrpg.nbtapi.NBTCompoundList;
import us.eunoians.mcrpg.nbtapi.NBTItem;
import us.eunoians.mcrpg.nbtapi.NBTList;
import us.eunoians.mcrpg.nbtapi.NBTListCompound;
import us.eunoians.mcrpg.nbtapi.NBTReflectionUtil;
import us.eunoians.mcrpg.nbtapi.NBTType;
import us.eunoians.mcrpg.nbtapi.NbtApiException;
import us.eunoians.mcrpg.nbtapi.utils.MinecraftVersion;
import us.eunoians.mcrpg.nbtapi.utils.nmsmappings.ReflectionMethod;

public class NBTCompound {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private String compundName;
    private NBTCompound parent;

    protected NBTCompound(NBTCompound nBTCompound, String string) {
        this.compundName = string;
        this.parent = nBTCompound;
    }

    protected Lock getReadLock() {
        return this.readLock;
    }

    protected Lock getWriteLock() {
        return this.writeLock;
    }

    protected void saveCompound() {
        if (this.parent != null) {
            this.parent.saveCompound();
        }
    }

    public String getName() {
        return this.compundName;
    }

    public Object getCompound() {
        return this.parent.getCompound();
    }

    protected void setCompound(Object object) {
        this.parent.setCompound(object);
    }

    public NBTCompound getParent() {
        return this.parent;
    }

    public void mergeCompound(NBTCompound nBTCompound) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.mergeOtherNBTCompound(this, nBTCompound);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setString(String string, String string2) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_STRING, string, string2);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getString(String string) {
        try {
            this.readLock.lock();
            String string2 = (String)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_STRING, string);
            return string2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected String getContent(String string) {
        return NBTReflectionUtil.getContent(this, string);
    }

    public void setInteger(String string, Integer n) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INT, string, n);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Integer getInteger(String string) {
        try {
            this.readLock.lock();
            Integer n = (Integer)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INT, string);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setDouble(String string, Double d) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_DOUBLE, string, d);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Double getDouble(String string) {
        try {
            this.readLock.lock();
            Double d = (Double)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_DOUBLE, string);
            return d;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setByte(String string, Byte by) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTE, string, by);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Byte getByte(String string) {
        try {
            this.readLock.lock();
            Byte by = (Byte)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTE, string);
            return by;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setShort(String string, Short s) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_SHORT, string, s);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Short getShort(String string) {
        try {
            this.readLock.lock();
            Short s = (Short)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_SHORT, string);
            return s;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setLong(String string, Long l) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_LONG, string, l);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Long getLong(String string) {
        try {
            this.readLock.lock();
            Long l = (Long)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_LONG, string);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setFloat(String string, Float f) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_FLOAT, string, f);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Float getFloat(String string) {
        try {
            this.readLock.lock();
            Float f = (Float)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_FLOAT, string);
            return f;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setByteArray(String string, byte[] byArray) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTEARRAY, string, byArray);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public byte[] getByteArray(String string) {
        try {
            this.readLock.lock();
            byte[] byArray = (byte[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTEARRAY, string);
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setIntArray(String string, int[] nArray) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INTARRAY, string, nArray);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int[] getIntArray(String string) {
        try {
            this.readLock.lock();
            int[] nArray = (int[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INTARRAY, string);
            return nArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setBoolean(String string, Boolean bl) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BOOLEAN, string, bl);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void set(String string, Object object) {
        NBTReflectionUtil.set(this, string, object);
        this.saveCompound();
    }

    public Boolean getBoolean(String string) {
        try {
            this.readLock.lock();
            Boolean bl = (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BOOLEAN, string);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setObject(String string, Object object) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setObject(this, string, object);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getObject(String string, Class<T> clazz) {
        try {
            this.readLock.lock();
            T t = NBTReflectionUtil.getObject(this, string, clazz);
            return t;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setItemStack(String string, ItemStack itemStack) {
        try {
            this.writeLock.lock();
            this.removeKey(string);
            this.addCompound(string).mergeCompound(NBTItem.convertItemtoNBT(itemStack));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack getItemStack(String string) {
        try {
            this.readLock.lock();
            NBTCompound nBTCompound = this.getCompound(string);
            ItemStack itemStack = NBTItem.convertNBTtoItem(nBTCompound);
            return itemStack;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean hasKey(String string) {
        try {
            this.readLock.lock();
            Boolean bl = (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_HAS_KEY, string);
            if (bl == null) {
                Boolean bl2 = false;
                return bl2;
            }
            Boolean bl3 = bl;
            return bl3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void removeKey(String string) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.remove(this, string);
            this.saveCompound();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<String> getKeys() {
        try {
            this.readLock.lock();
            Set<String> set = NBTReflectionUtil.getKeys(this);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTCompound addCompound(String string) {
        try {
            this.writeLock.lock();
            if (this.getType(string) == NBTType.NBTTagCompound) {
                NBTCompound nBTCompound = this.getCompound(string);
                return nBTCompound;
            }
            NBTReflectionUtil.addNBTTagCompound(this, string);
            NBTCompound nBTCompound = this.getCompound(string);
            if (nBTCompound == null) {
                throw new NbtApiException("Error while adding Compound, got null!");
            }
            this.saveCompound();
            NBTCompound nBTCompound2 = nBTCompound;
            return nBTCompound2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTCompound getCompound(String string) {
        try {
            this.readLock.lock();
            if (this.getType(string) != NBTType.NBTTagCompound) {
                NBTCompound nBTCompound = null;
                return nBTCompound;
            }
            NBTCompound nBTCompound = new NBTCompound(this, string);
            if (NBTReflectionUtil.valideCompound(nBTCompound).booleanValue()) {
                NBTCompound nBTCompound2 = nBTCompound;
                return nBTCompound2;
            }
            NBTCompound nBTCompound3 = null;
            return nBTCompound3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<String> getStringList(String string) {
        try {
            this.writeLock.lock();
            NBTList<String> nBTList = NBTReflectionUtil.getList(this, string, NBTType.NBTTagString, String.class);
            this.saveCompound();
            NBTList<String> nBTList2 = nBTList;
            return nBTList2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<Integer> getIntegerList(String string) {
        try {
            this.writeLock.lock();
            NBTList<Integer> nBTList = NBTReflectionUtil.getList(this, string, NBTType.NBTTagInt, Integer.class);
            this.saveCompound();
            NBTList<Integer> nBTList2 = nBTList;
            return nBTList2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<Float> getFloatList(String string) {
        try {
            this.writeLock.lock();
            NBTList<Float> nBTList = NBTReflectionUtil.getList(this, string, NBTType.NBTTagFloat, Float.class);
            this.saveCompound();
            NBTList<Float> nBTList2 = nBTList;
            return nBTList2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<Double> getDoubleList(String string) {
        try {
            this.writeLock.lock();
            NBTList<Double> nBTList = NBTReflectionUtil.getList(this, string, NBTType.NBTTagDouble, Double.class);
            this.saveCompound();
            NBTList<Double> nBTList2 = nBTList;
            return nBTList2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTList<Long> getLongList(String string) {
        try {
            this.writeLock.lock();
            NBTList<Long> nBTList = NBTReflectionUtil.getList(this, string, NBTType.NBTTagLong, Long.class);
            this.saveCompound();
            NBTList<Long> nBTList2 = nBTList;
            return nBTList2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTCompoundList getCompoundList(String string) {
        try {
            this.writeLock.lock();
            NBTCompoundList nBTCompoundList = (NBTCompoundList)NBTReflectionUtil.getList(this, string, NBTType.NBTTagCompound, NBTListCompound.class);
            this.saveCompound();
            NBTCompoundList nBTCompoundList2 = nBTCompoundList;
            return nBTCompoundList2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NBTType getType(String string) {
        try {
            this.readLock.lock();
            if (MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
                NBTType nBTType = null;
                return nBTType;
            }
            Object object = NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_TYPE, string);
            if (object == null) {
                NBTType nBTType = null;
                return nBTType;
            }
            NBTType nBTType = NBTType.valueOf(((Byte)object).byteValue());
            return nBTType;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void writeCompound(OutputStream outputStream) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.writeApiNBT(this, outputStream);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String toString() {
        return this.asNBTString();
    }

    @Deprecated
    public String toString(String string) {
        return this.asNBTString();
    }

    @Deprecated
    public String asNBTString() {
        try {
            this.readLock.lock();
            Object object = NBTReflectionUtil.gettoCompount(this.getCompound(), this);
            if (object == null) {
                String string = "{}";
                return string;
            }
            String string = object.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.toString().equals(object.toString());
    }
}

