/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.abilities.mining.RemoteTransfer;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUIBuilder;
import us.eunoians.mcrpg.gui.GUIInventoryFunction;
import us.eunoians.mcrpg.gui.GUIItem;
import us.eunoians.mcrpg.gui.GUITracker;
import us.eunoians.mcrpg.players.McRPGPlayer;

public class RemoteTransferGUI
extends GUI {
    private RemoteTransfer remoteTransfer;
    private GUIInventoryFunction buildGUIFunction;

    public RemoteTransferGUI(McRPGPlayer mcRPGPlayer, BaseAbility baseAbility) {
        super(new GUIBuilder(mcRPGPlayer));
        this.remoteTransfer = (RemoteTransfer)baseAbility;
        if (!GUITracker.isPlayerTracked(mcRPGPlayer)) {
            GUITracker.trackPlayer(mcRPGPlayer, (GUI)this);
        }
        this.buildGUIFunction = gUIBuilder -> {
            ItemMeta itemMeta;
            String string2;
            FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.fromString(this.remoteTransfer.getGenericAbility().getSkill().getName()));
            FileConfiguration fileConfiguration2 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.REMOTE_TRANSFER_GUI);
            Inventory inventory = Bukkit.createInventory(null, (int)fileConfiguration.getInt("RemoteTransferConfig.Tier" + Methods.convertToNumeral(this.remoteTransfer.getCurrentTier()) + ".InvSize"), (String)Methods.color(this.getPlayer().getPlayer(), fileConfiguration2.getString("Title")));
            ArrayList<GUIItem> arrayList = new ArrayList<GUIItem>();
            HashMap<Material, Boolean> hashMap = this.remoteTransfer.getItemsToSync();
            int n = 0;
            for (String string2 : fileConfiguration.getStringList("RemoteTransferConfig.Tier" + Methods.convertToNumeral(this.remoteTransfer.getCurrentTier()) + ".Categories")) {
                itemMeta = fileConfiguration.getStringList("RemoteTransferConfig.Categories." + string2).stream().map(Material::getMaterial).collect(Collectors.toList());
                for (Material material : itemMeta) {
                    ItemMeta itemMeta2;
                    ItemStack itemStack;
                    if (hashMap.containsKey(material)) {
                        itemStack = new ItemStack(material, 1);
                        itemMeta2 = itemStack.getItemMeta();
                        itemMeta2.setLore(Methods.colorLore(fileConfiguration2.getStringList("ToggleLore")));
                        itemMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        itemStack.setItemMeta(itemMeta2);
                        if (hashMap.get(material).booleanValue()) {
                            itemStack.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
                        }
                        arrayList.add(new GUIItem(itemStack, n));
                    } else {
                        hashMap.put(material, true);
                        itemStack = new ItemStack(material, 1);
                        itemMeta2 = itemStack.getItemMeta();
                        itemMeta2.setLore(Methods.colorLore(fileConfiguration2.getStringList("ToggleLore")));
                        itemMeta2.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        itemStack.setItemMeta(itemMeta2);
                        itemStack.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
                        arrayList.add(new GUIItem(itemStack, n));
                    }
                    ++n;
                }
            }
            mcRPGPlayer.saveData();
            String string3 = baseAbility.getGenericAbility().getName() + "Config.Item.";
            string2 = new ItemStack(Material.getMaterial((String)fileConfiguration.getString((String)string3 + "Material")), fileConfiguration.getInt((String)string3 + "Amount"));
            itemMeta = string2.getItemMeta();
            itemMeta.setDisplayName(Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration.getString((String)string3 + "DisplayName")));
            itemMeta.setLore(Methods.colorLore(fileConfiguration2.getStringList("ToggleAbilityLore")));
            itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            string2.setItemMeta(itemMeta);
            if (this.remoteTransfer.isToggled()) {
                string2.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
            }
            arrayList.add(new GUIItem((ItemStack)string2, inventory.getSize() - 1));
            ItemStack itemStack = new ItemStack(Material.AIR);
            if (fileConfiguration2.contains("FillerItem")) {
                Material material;
                itemStack = new ItemStack(Material.valueOf((String)fileConfiguration2.getString("FillerItem.Material")), fileConfiguration2.getInt("FillerItem.Amount"));
                material = itemStack.getItemMeta();
                material.setDisplayName(Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration2.getString("FillerItem.DisplayName")));
                material.setLore(Methods.colorLore(fileConfiguration2.getStringList("FillerItem.Lore")));
                itemStack.setItemMeta((ItemMeta)material);
            }
            return Methods.fillInventory(inventory, itemStack, arrayList);
        };
        this.getGui().setBuildGUIFunction(this.buildGUIFunction);
        this.getGui().rebuildGUI();
    }

    public RemoteTransfer getRemoteTransfer() {
        return this.remoteTransfer;
    }
}

