/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.gui;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.PartyNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUIBuilder;
import us.eunoians.mcrpg.gui.GUIInventoryFunction;
import us.eunoians.mcrpg.gui.GUIItem;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.party.PartyManager;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.PartyUpgrades;

public class PartyUpgradesGUI
extends GUI {
    private Party party;
    private Map<Integer, PartyUpgrades> partyUpgradesMap = new HashMap<Integer, PartyUpgrades>();
    private GUIInventoryFunction buildFunction;

    public PartyUpgradesGUI(McRPGPlayer mcRPGPlayer) {
        super(new GUIBuilder(mcRPGPlayer));
        PartyManager partyManager = McRPG.getInstance().getPartyManager();
        if (mcRPGPlayer.getPartyID() == null || partyManager.getParty(mcRPGPlayer.getPartyID()) == null) {
            throw new PartyNotFoundException("The player is either no in a party or the party is invalid and as such could not be handled");
        }
        this.party = partyManager.getParty(mcRPGPlayer.getPartyID());
        FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_UPGRADES_GUI);
        this.buildFunction = gUIBuilder -> {
            int n;
            int n2;
            int n3;
            Object object;
            ItemMeta itemMeta;
            NumberFormat numberFormat;
            Inventory inventory = Bukkit.createInventory(null, (int)fileConfiguration.getInt("Size", 27), (String)Methods.color(fileConfiguration.getString("Title").replace("%Upgrade_Points%", Integer.toString(this.party.getPartyUpgradePoints()))));
            ArrayList<GUIItem> arrayList = new ArrayList<GUIItem>();
            if (fileConfiguration.contains("MemberCount")) {
                numberFormat = new ItemStack(Material.getMaterial((String)fileConfiguration.getString("MemberCount.Material")));
                itemMeta = numberFormat.getItemMeta();
                if (numberFormat.getType() == Material.PLAYER_HEAD) {
                    object = (SkullMeta)itemMeta;
                    if (fileConfiguration.contains("MemberCount.Owner")) {
                        if (fileConfiguration.getString("MemberCount.Owner").equalsIgnoreCase("%Player%")) {
                            object.setOwningPlayer(mcRPGPlayer.getOfflineMcRPGPlayer());
                        } else {
                            object.setOwningPlayer(Bukkit.getOfflinePlayer((String)fileConfiguration.getString("MemberCount.Owner")));
                        }
                    } else {
                        object.setOwningPlayer(mcRPGPlayer.getOfflineMcRPGPlayer());
                    }
                    numberFormat.setItemMeta((ItemMeta)object);
                    numberFormat = numberFormat.clone();
                    itemMeta = numberFormat.getItemMeta();
                }
                itemMeta.setDisplayName(Methods.color(fileConfiguration.getString("MemberCount.DisplayName")));
                object = new ArrayList();
                int n4 = this.party.getUpgradeTier(PartyUpgrades.MEMBER_COUNT);
                n3 = PartyUpgrades.getMaxMemberUpgradeTier();
                n2 = PartyUpgrades.getMemberCountAtTier(n4);
                for (Object object2 : fileConfiguration.getStringList("MemberCount.Lore")) {
                    object.add(Methods.color(((String)object2).replace("%Current_Level%", Integer.toString(n4)).replace("%Max_Level%", Integer.toString(n3)).replace("%Member_Limit%", Integer.toString(n2))));
                }
                itemMeta.setLore((List)object);
                numberFormat.setItemMeta(itemMeta);
                int n5 = fileConfiguration.getInt("MemberCount.Slot");
                arrayList.add(new GUIItem((ItemStack)numberFormat, n5));
                this.partyUpgradesMap.put(n5, PartyUpgrades.MEMBER_COUNT);
            }
            numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMinimumFractionDigits(2);
            numberFormat.setMaximumFractionDigits(2);
            if (fileConfiguration.contains("ExpShareAmount")) {
                itemMeta = new ItemStack(Material.getMaterial((String)fileConfiguration.getString("ExpShareAmount.Material")));
                object = itemMeta.getItemMeta();
                object.setDisplayName(Methods.color(fileConfiguration.getString("ExpShareAmount.DisplayName")));
                ArrayList<String> arrayList2 = new ArrayList<String>();
                n3 = this.party.getUpgradeTier(PartyUpgrades.EXP_SHARE_AMOUNT);
                n2 = PartyUpgrades.getMaxExpShareTier();
                double d = PartyUpgrades.getExpShareAmountAtTier(n3);
                for (String string : fileConfiguration.getStringList("ExpShareAmount.Lore")) {
                    arrayList2.add(Methods.color(string.replace("%Current_Level%", Integer.toString(n3)).replace("%Max_Level%", Integer.toString(n2)).replace("%Exp_Share_Amount%", numberFormat.format(d))));
                }
                object.setLore(arrayList2);
                itemMeta.setItemMeta((ItemMeta)object);
                n = fileConfiguration.getInt("ExpShareAmount.Slot");
                arrayList.add(new GUIItem((ItemStack)itemMeta, n));
                this.partyUpgradesMap.put(n, PartyUpgrades.EXP_SHARE_AMOUNT);
            }
            if (fileConfiguration.contains("ExpShareRange")) {
                itemMeta = new ItemStack(Material.getMaterial((String)fileConfiguration.getString("ExpShareRange.Material")));
                object = itemMeta.getItemMeta();
                object.setDisplayName(Methods.color(fileConfiguration.getString("ExpShareRange.DisplayName")));
                ArrayList<String> arrayList3 = new ArrayList<String>();
                n3 = this.party.getUpgradeTier(PartyUpgrades.EXP_SHARE_RANGE);
                n2 = PartyUpgrades.getMaxExpShareTier();
                double d = PartyUpgrades.getExpShareRangeAtTier(n3);
                for (String string : fileConfiguration.getStringList("ExpShareRange.Lore")) {
                    arrayList3.add(Methods.color(string.replace("%Current_Level%", Integer.toString(n3)).replace("%Max_Level%", Integer.toString(n2)).replace("%Exp_Share_Range%", numberFormat.format(d))));
                }
                object.setLore(arrayList3);
                itemMeta.setItemMeta((ItemMeta)object);
                n = fileConfiguration.getInt("ExpShareRange.Slot");
                arrayList.add(new GUIItem((ItemStack)itemMeta, n));
                this.partyUpgradesMap.put(n, PartyUpgrades.EXP_SHARE_RANGE);
            }
            if (fileConfiguration.contains("PrivateBankSize")) {
                itemMeta = new ItemStack(Material.getMaterial((String)fileConfiguration.getString("PrivateBankSize.Material")));
                object = itemMeta.getItemMeta();
                object.setDisplayName(Methods.color(fileConfiguration.getString("PrivateBankSize.DisplayName")));
                ArrayList<String> arrayList4 = new ArrayList<String>();
                n3 = this.party.getUpgradeTier(PartyUpgrades.PRIVATE_BANK_SIZE);
                n2 = PartyUpgrades.getMaxExpShareTier();
                int n6 = PartyUpgrades.getPrivateBankSizeAtTier(n3);
                for (String string : fileConfiguration.getStringList("PrivateBankSize.Lore")) {
                    arrayList4.add(Methods.color(string.replace("%Current_Level%", Integer.toString(n3)).replace("%Max_Level%", Integer.toString(n2)).replace("%Private_Bank_Size%", Integer.toString(n6))));
                }
                object.setLore(arrayList4);
                itemMeta.setItemMeta((ItemMeta)object);
                int n7 = fileConfiguration.getInt("PrivateBankSize.Slot");
                arrayList.add(new GUIItem((ItemStack)itemMeta, n7));
                this.partyUpgradesMap.put(n7, PartyUpgrades.PRIVATE_BANK_SIZE);
            }
            if (fileConfiguration.contains("BackButton")) {
                itemMeta = new ItemStack(Material.getMaterial((String)fileConfiguration.getString("BackButton.Material")));
                object = itemMeta.getItemMeta();
                object.setDisplayName(Methods.color(fileConfiguration.getString("BackButton.DisplayName")));
                object.setLore(Methods.colorLore(fileConfiguration.getStringList("BackButton.Lore")));
                itemMeta.setItemMeta((ItemMeta)object);
                arrayList.add(new GUIItem((ItemStack)itemMeta, fileConfiguration.getInt("BackButton.Slot")));
            }
            itemMeta = new ItemStack(Material.AIR);
            if (fileConfiguration.contains("FillerItem")) {
                object = Material.getMaterial((String)fileConfiguration.getString("FillerItem.Material"));
                itemMeta = new ItemStack((Material)object, 1);
                ItemMeta itemMeta2 = itemMeta.getItemMeta();
                itemMeta2.setDisplayName(Methods.color(fileConfiguration.getString("FillerItem.DisplayName", "")));
                itemMeta.setItemMeta(itemMeta2);
                if (fileConfiguration.contains("FillerItem.Lore")) {
                    itemMeta2.setLore(Methods.colorLore(fileConfiguration.getStringList("FillerItem.Lore")));
                    itemMeta.setItemMeta(itemMeta2);
                }
            }
            return Methods.fillInventory(inventory, (ItemStack)itemMeta, arrayList);
        };
        this.getGui().setBuildGUIFunction(this.buildFunction);
        this.getGui().rebuildGUI();
    }

    public Party getParty() {
        return this.party;
    }

    public Map<Integer, PartyUpgrades> getPartyUpgradesMap() {
        return this.partyUpgradesMap;
    }
}

