/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUIBuilder;
import us.eunoians.mcrpg.gui.GUIInventoryFunction;
import us.eunoians.mcrpg.gui.GUIItem;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.PartyPermissions;

public class PartyRoleGUI
extends GUI {
    private Party party;
    private Map<Integer, PartyPermissions> partyPermissionsMap = new HashMap<Integer, PartyPermissions>();
    private GUIInventoryFunction buildFunction;

    public PartyRoleGUI(McRPGPlayer mcRPGPlayer, Party party) {
        super(new GUIBuilder(mcRPGPlayer));
        this.party = party;
        this.buildFunction = gUIBuilder -> {
            FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_ROLE_GUI);
            Inventory inventory = Bukkit.createInventory(null, (int)fileConfiguration.getInt("Size", 27), (String)Methods.color(fileConfiguration.getString("Title")));
            ArrayList<GUIItem> arrayList = new ArrayList<GUIItem>();
            for (PartyPermissions partyPermissions : PartyPermissions.values()) {
                String string = partyPermissions.getName().replace(" ", "") + ".";
                int n = fileConfiguration.getInt(string + "Slot");
                string = string + party.getRoleForPermission(partyPermissions).getName() + ".";
                ItemStack itemStack = new ItemStack(Material.getMaterial((String)fileConfiguration.getString(string + "Material")));
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setDisplayName(Methods.color(fileConfiguration.getString(string + "DisplayName")));
                itemMeta.setLore(Methods.colorLore(fileConfiguration.getStringList(string + "Lore")));
                itemStack.setItemMeta(itemMeta);
                arrayList.add(new GUIItem(itemStack, n));
                this.partyPermissionsMap.put(n, partyPermissions);
            }
            ItemStack itemStack = new ItemStack(Material.AIR);
            if (fileConfiguration.contains("FillerItem")) {
                Material material = Material.getMaterial((String)fileConfiguration.getString("FillerItem.Material"));
                itemStack = new ItemStack(material, 1);
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setDisplayName(Methods.color(fileConfiguration.getString("FillerItem.DisplayName", "")));
                itemStack.setItemMeta(itemMeta);
                if (fileConfiguration.contains("FillerItem.Lore")) {
                    itemMeta.setLore(Methods.colorLore(fileConfiguration.getStringList("FillerItem.Lore")));
                    itemStack.setItemMeta(itemMeta);
                }
            }
            return Methods.fillInventory(inventory, itemStack, arrayList);
        };
        this.getGui().setBuildGUIFunction(this.buildFunction);
        this.getGui().rebuildGUI();
    }

    public Party getParty() {
        return this.party;
    }

    public Map<Integer, PartyPermissions> getPartyPermissionsMap() {
        return this.partyPermissionsMap;
    }
}

