/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.PartyNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUIBuilder;
import us.eunoians.mcrpg.gui.GUIInventoryFunction;
import us.eunoians.mcrpg.gui.GUIItem;
import us.eunoians.mcrpg.gui.GUIPlaceHolderFunction;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.party.PartyManager;
import us.eunoians.mcrpg.players.McRPGPlayer;

public class PartyMemberGUI
extends GUI {
    private GUIInventoryFunction guiInventoryFunction;
    private GUIPlaceHolderFunction guiPlaceHolderFunction;

    public PartyMemberGUI(McRPGPlayer mcRPGPlayer) {
        super(new GUIBuilder(mcRPGPlayer));
        PartyManager partyManager = McRPG.getInstance().getPartyManager();
        if (mcRPGPlayer.getPartyID() == null || partyManager.getParty(mcRPGPlayer.getPartyID()) == null) {
            throw new PartyNotFoundException("The player is either no in a party or the party is invalid and as such could not be handled");
        }
        Party party = partyManager.getParty(mcRPGPlayer.getPartyID());
        this.guiInventoryFunction = gUIBuilder -> {
            OfflinePlayer offlinePlayer;
            int n;
            ArrayList<GUIItem> arrayList = new ArrayList<GUIItem>();
            FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_MEMBER_GUI);
            int n2 = Math.min(54, n + ((n = party.getAllMemberUUIDs().size()) % 9 != 0 ? 9 - n % 9 : 0));
            Inventory inventory = Bukkit.createInventory(null, (int)n2, (String)Methods.color(fileConfiguration.getString("Title")));
            int n3 = 0;
            for (UUID uUID : party.getAllMemberUUIDs()) {
                Object object;
                offlinePlayer = Bukkit.getOfflinePlayer((UUID)uUID);
                ItemStack itemStack = new ItemStack(Material.getMaterial((String)fileConfiguration.getString("PartyMemberItem.Material", "PLAYER_HEAD")));
                ItemMeta itemMeta = itemStack.getItemMeta();
                if (itemStack.getType().equals((Object)Material.PLAYER_HEAD)) {
                    object = (SkullMeta)itemMeta;
                    if (fileConfiguration.contains("PartyMemberItem.Owner")) {
                        if (fileConfiguration.getString("PartyMemberItem.Owner").equalsIgnoreCase("%Player%")) {
                            object.setOwningPlayer(offlinePlayer);
                        } else {
                            object.setOwningPlayer(Bukkit.getOfflinePlayer((String)fileConfiguration.getString("PartyMemberItem.Owner")));
                        }
                    } else {
                        object.setOwningPlayer(offlinePlayer);
                    }
                    itemStack.setItemMeta((ItemMeta)object);
                    itemStack = itemStack.clone();
                    itemMeta = itemStack.getItemMeta();
                }
                object = new ArrayList();
                for (String string : fileConfiguration.getStringList("PartyMemberItem.Lore")) {
                    object.add(string.replace("%Last_Login%", offlinePlayer.isOnline() ? (!offlinePlayer.getPlayer().hasMetadata("vanished") ? fileConfiguration.getString("Strings.CurrentlyOnline", "&a&lOnline") : Methods.getLastLoginDay(offlinePlayer)) : Methods.getLastLoginDay(offlinePlayer)).replace("%Party_Role%", party.getPartyMember(uUID).getPartyRole().getName()));
                }
                itemMeta.setLore(Methods.colorLore((List<String>)object));
                itemMeta.setDisplayName(Methods.color(fileConfiguration.getString("PartyMemberItem.DisplayName", "&5" + offlinePlayer.getName()).replace("%Player%", offlinePlayer.getName())));
                itemStack.setItemMeta(itemMeta);
                arrayList.add(new GUIItem(itemStack, n3));
                ++n3;
            }
            ItemStack itemStack = new ItemStack(Material.AIR);
            if (fileConfiguration.contains("FillerItem")) {
                UUID uUID;
                uUID = Material.getMaterial((String)fileConfiguration.getString("FillerItem.Material"));
                itemStack = new ItemStack((Material)uUID, 1);
                offlinePlayer = itemStack.getItemMeta();
                offlinePlayer.setDisplayName(Methods.color(fileConfiguration.getString("FillerItem.DisplayName", "")));
                itemStack.setItemMeta((ItemMeta)offlinePlayer);
                if (fileConfiguration.contains("FillerItem.Lore")) {
                    offlinePlayer.setLore(Methods.colorLore(fileConfiguration.getStringList("FillerItem.Lore")));
                    itemStack.setItemMeta((ItemMeta)offlinePlayer);
                }
            }
            return Methods.fillInventory(inventory, itemStack, arrayList);
        };
        this.getGui().setBuildGUIFunction(this.guiInventoryFunction);
        this.getGui().rebuildGUI();
    }
}

