/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.gui;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUITrackerBit;
import us.eunoians.mcrpg.players.McRPGPlayer;

public class GUITracker {
    private static HashMap<UUID, GUITrackerBit> guiTracker = new HashMap();

    public static boolean isPlayerTracked(Player player) {
        boolean bl = false;
        if (guiTracker.containsKey(player.getUniqueId())) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPlayerTracked(McRPGPlayer mcRPGPlayer) {
        boolean bl = false;
        if (guiTracker.containsKey(mcRPGPlayer.getUuid())) {
            bl = true;
        }
        return bl;
    }

    public static boolean isPlayerTracked(UUID uUID) {
        boolean bl = false;
        if (guiTracker.containsKey(uUID)) {
            bl = true;
        }
        return bl;
    }

    public static boolean doesPlayerHavePrevious(McRPGPlayer mcRPGPlayer) {
        return guiTracker.containsKey(mcRPGPlayer.getUuid()) && guiTracker.get(mcRPGPlayer.getUuid()).hasPreviousGUI();
    }

    public static boolean doesPlayerHavePrevious(Player player) {
        return guiTracker.containsKey(player.getUniqueId()) && guiTracker.get(player.getUniqueId()).hasPreviousGUI();
    }

    public static boolean doesPlayerHavePrevious(UUID uUID) {
        return guiTracker.containsKey(uUID) && guiTracker.get(uUID).hasPreviousGUI();
    }

    public static void stopTrackingPlayer(McRPGPlayer mcRPGPlayer) {
        guiTracker.remove(mcRPGPlayer.getUuid());
    }

    public static void stopTrackingPlayer(Player player) {
        guiTracker.remove(player.getUniqueId());
    }

    public static void stopTrackingPlayer(UUID uUID) {
        guiTracker.remove(uUID);
    }

    public static GUI getPlayersGUI(McRPGPlayer mcRPGPlayer) {
        return guiTracker.get(mcRPGPlayer.getUuid()).getCurrentGUI();
    }

    public static GUI getPlayersGUI(Player player) {
        return guiTracker.get(player.getUniqueId()).getCurrentGUI();
    }

    public static GUI getPlayersGUI(UUID uUID) {
        return guiTracker.get(uUID).getCurrentGUI();
    }

    public static GUI getPlayersPreviousGUI(McRPGPlayer mcRPGPlayer) {
        return guiTracker.get(mcRPGPlayer.getUuid()).getPreviousGUI();
    }

    public static GUI getPlayersPreviousGUI(Player player) {
        return guiTracker.get(player.getUniqueId()).getPreviousGUI();
    }

    public static GUI getPlayersPreviousGUI(UUID uUID) {
        return guiTracker.get(uUID).getPreviousGUI();
    }

    public static GUI replacePlayersGUI(McRPGPlayer mcRPGPlayer, GUI gUI) {
        GUITracker.setPlayersCurrentGUI(mcRPGPlayer.getUuid(), gUI, true);
        return gUI;
    }

    public static GUI replacePlayersGUI(Player player, GUI gUI) {
        GUITracker.setPlayersCurrentGUI(player.getUniqueId(), gUI, true);
        return gUI;
    }

    public static GUI replacePlayersGUI(UUID uUID, GUI gUI) {
        GUITracker.setPlayersCurrentGUI(uUID, gUI, true);
        return gUI;
    }

    public static void trackPlayer(McRPGPlayer mcRPGPlayer, GUI gUI) {
        GUITrackerBit gUITrackerBit = new GUITrackerBit(gUI);
        guiTracker.put(mcRPGPlayer.getUuid(), gUITrackerBit);
    }

    public static void trackPlayer(Player player, GUI gUI) {
        GUITrackerBit gUITrackerBit = new GUITrackerBit(gUI);
        guiTracker.put(player.getUniqueId(), gUITrackerBit);
    }

    public static void trackPlayer(UUID uUID, GUI gUI) {
        GUITrackerBit gUITrackerBit = new GUITrackerBit(gUI);
        guiTracker.put(uUID, gUITrackerBit);
    }

    public static void setPlayersPreviousGUI(McRPGPlayer mcRPGPlayer, GUI gUI) {
        guiTracker.get(mcRPGPlayer.getUuid()).setPreviousGUI(gUI);
    }

    public static void setPlayersPreviousGUI(Player player, GUI gUI) {
        guiTracker.get(player.getUniqueId()).setPreviousGUI(gUI);
    }

    private static void setPlayersPreviousGUI(UUID uUID, GUI gUI) {
        guiTracker.get(uUID).setPreviousGUI(gUI);
    }

    private static void setPlayersCurrentGUI(UUID uUID, GUI gUI, boolean bl) {
        if (bl) {
            GUI gUI2 = guiTracker.get(uUID).getCurrentGUI();
            GUITracker.setPlayersPreviousGUI(uUID, gUI2);
            guiTracker.get(uUID).setCurrentGUI(gUI);
        } else {
            guiTracker.get(uUID).setCurrentGUI(gUI);
            GUITracker.setPlayersPreviousGUI(uUID, null);
        }
    }
}

