/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.gui.GUIBindEventFunction;
import us.eunoians.mcrpg.gui.GUIEventBinder;
import us.eunoians.mcrpg.gui.GUIInventoryFunction;
import us.eunoians.mcrpg.gui.GUIItem;
import us.eunoians.mcrpg.gui.GUIPlaceHolderFunction;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.PartyPermissions;

public class GUIBuilder {
    private String path;
    private Inventory inv;
    private String rawPath;
    private ArrayList<GUIEventBinder> boundEvents;
    private FileConfiguration config;
    private ArrayList<GUIItem> items;
    private McRPGPlayer player;
    private GUIPlaceHolderFunction replacePlaceHoldersFunction = gUIBuilder -> {
        if (gUIBuilder.getRawPath().equalsIgnoreCase("MainGUI")) {
            for (int i = 0; i < gUIBuilder.getInv().getSize(); ++i) {
                ItemStack itemStack = gUIBuilder.getInv().getItem(i);
                if (itemStack == null || !itemStack.hasItemMeta() || !itemStack.getItemMeta().hasLore()) continue;
                ItemMeta itemMeta = itemStack.getItemMeta();
                ArrayList arrayList = new ArrayList();
                itemMeta.getLore().forEach(string -> {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    String string2 = "N/A";
                    String string3 = "N/A";
                    String string4 = "N/A";
                    String string5 = "N/A";
                    String string6 = "N/A";
                    if (gUIBuilder.getPlayer().getPartyID() != null) {
                        Party party = McRPG.getInstance().getPartyManager().getParty(gUIBuilder.getPlayer().getPartyID());
                        n = party.getOnlinePlayers().size();
                        n2 = party.getAllMembers().size();
                        n3 = party.getPartyUpgradePoints();
                        string2 = party.getRoleForPermission(PartyPermissions.PRIVATE_BANK).getName();
                        string3 = party.getRoleForPermission(PartyPermissions.KICK_PLAYERS).getName();
                        string4 = party.getRoleForPermission(PartyPermissions.PVP).getName();
                        string5 = party.getRoleForPermission(PartyPermissions.INVITE_PLAYERS).getName();
                        string6 = party.getRoleForPermission(PartyPermissions.UPGRADE_PARTY).getName();
                    }
                    arrayList.add(string.replace("%Power_Level%", Integer.toString(gUIBuilder.getPlayer().getPowerLevel())).replace("%Ability_Points%", Integer.toString(gUIBuilder.getPlayer().getAbilityPoints())).replace("%Online_Members%", Integer.toString(n)).replace("%Total_Members%", Integer.toString(n2)).replace("%Party_Points%", Integer.toString(n3)).replace("%Bank_Role%", string2).replace("%Kick_Role%", string3).replace("%Pvp_Role%", string4).replace("%Invite_Role%", string5).replace("%Upgrade_Role%", string6));
                });
                itemMeta.setLore(arrayList);
                itemStack.setItemMeta(itemMeta);
                gUIBuilder.getInv().setItem(i, itemStack);
            }
        }
    };
    private GUIInventoryFunction buildGUIFunction = gUIBuilder -> {
        ItemStack itemStack;
        Object object;
        Party party;
        String string = "0";
        if (this.player.getPartyID() != null && (party = McRPG.getInstance().getPartyManager().getParty(this.player.getPartyID())) != null) {
            string = Integer.toString(party.getPartyLevel());
        }
        party = Bukkit.createInventory(null, (int)this.config.getInt(this.path + "Size"), (String)Methods.color(this.player.getPlayer(), this.config.getString(this.path + "Title").replace("%Party_Level%", string)));
        this.items = new ArrayList();
        for (String string2 : this.config.getConfigurationSection(this.path + "Items").getKeys(false)) {
            Object object2;
            object = Material.getMaterial((String)this.config.getString(this.path + "Items." + string2 + ".Material"));
            itemStack = new ItemStack(object, 1);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (object.equals((Object)Material.PLAYER_HEAD)) {
                object2 = (SkullMeta)itemMeta;
                object2.setOwningPlayer(this.player.getOfflineMcRPGPlayer());
                itemStack.setItemMeta((ItemMeta)object2);
            }
            itemMeta.setDisplayName(Methods.color(this.player.getPlayer(), this.config.getString(this.path + "Items." + string2 + ".Name")));
            if (this.config.contains(this.path + "Items." + string2 + ".Lore")) {
                object2 = this.config.getStringList(this.path + "Items." + string2 + ".Lore");
                object2 = Methods.colorLore((List<String>)object2);
                itemMeta.setLore((List)object2);
            }
            itemStack.setItemMeta(itemMeta);
            itemStack.getItemMeta().addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            object2 = new GUIItem(itemStack, this.config.getInt(this.path + ".Items." + string2 + ".Slot"));
            this.items.add((GUIItem)object2);
        }
        ItemStack itemStack2 = new ItemStack(Material.AIR);
        if (this.config.contains(this.path + "FillerItem")) {
            String string2;
            string2 = Material.getMaterial((String)this.config.getString(this.path + "FillerItem.Material"));
            itemStack2 = new ItemStack((Material)string2, 1);
            itemStack = itemStack2.getItemMeta();
            itemStack.setDisplayName(Methods.color(this.player.getPlayer(), this.config.getString(this.path + "FillerItem.Name")));
            itemStack2.setItemMeta((ItemMeta)itemStack);
            if (this.config.contains(this.path + "FillerItem.Lore")) {
                object = this.config.getStringList(this.path + "FillerItem.Lore");
                object = Methods.colorLore((List<String>)object);
                itemStack.setLore((List)object);
                itemStack2.setItemMeta((ItemMeta)itemStack);
            }
        }
        return Methods.fillInventory((Inventory)party, itemStack2, this.items);
    };
    private GUIBindEventFunction bindEventsFunction = gUIBuilder -> {
        ArrayList<GUIEventBinder> arrayList = new ArrayList<GUIEventBinder>();
        if (!this.config.contains(this.path + "Events")) {
            return arrayList;
        }
        for (String string : this.config.getConfigurationSection(this.path + "Events").getKeys(false)) {
            GUIEventBinder gUIEventBinder = new GUIEventBinder(Integer.parseInt(string), this.config.getStringList(this.path + "Events." + string));
            arrayList.add(gUIEventBinder);
        }
        return arrayList;
    };

    public GUIBuilder(String string, String string2, McRPGPlayer mcRPGPlayer) {
        this.player = mcRPGPlayer;
        File file = new File(McRPG.getInstance().getDataFolder(), File.separator + "guis" + File.separator + string);
        this.config = YamlConfiguration.loadConfiguration((File)file);
        this.rawPath = string2;
        this.path = "Gui." + string2 + ".";
        this.inv = this.buildGUIFunction.generateInventory(this);
        this.boundEvents = this.bindEventsFunction.bindEvents(this);
    }

    public GUIBuilder(String string, FileConfiguration fileConfiguration, McRPGPlayer mcRPGPlayer) {
        this.player = mcRPGPlayer;
        this.rawPath = string;
        this.config = fileConfiguration;
        this.path = "Gui." + string + ".";
        this.inv = this.buildGUIFunction.generateInventory(this);
        this.boundEvents = this.bindEventsFunction.bindEvents(this);
    }

    public GUIBuilder(McRPGPlayer mcRPGPlayer) {
        this.player = mcRPGPlayer;
    }

    public GUIBuilder() {
    }

    public GUIBuilder clone() {
        return new GUIBuilder(this.rawPath, this.config, this.player);
    }

    public void setNewInventory(Inventory inventory) {
        this.inv = inventory;
    }

    public void rebuildGUI() {
        this.inv = this.buildGUIFunction.generateInventory(this);
    }

    public void rebindEvents() {
        this.boundEvents = this.bindEventsFunction.bindEvents(this);
    }

    public void replacePlaceHolders() {
        this.replacePlaceHoldersFunction.replacePlaceHolders(this);
    }

    public String getPath() {
        return this.path;
    }

    public Inventory getInv() {
        return this.inv;
    }

    public String getRawPath() {
        return this.rawPath;
    }

    public ArrayList<GUIEventBinder> getBoundEvents() {
        return this.boundEvents;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public ArrayList<GUIItem> getItems() {
        return this.items;
    }

    public void setItems(ArrayList<GUIItem> arrayList) {
        this.items = arrayList;
    }

    public McRPGPlayer getPlayer() {
        return this.player;
    }

    public GUIPlaceHolderFunction getReplacePlaceHoldersFunction() {
        return this.replacePlaceHoldersFunction;
    }

    public void setReplacePlaceHoldersFunction(GUIPlaceHolderFunction gUIPlaceHolderFunction) {
        this.replacePlaceHoldersFunction = gUIPlaceHolderFunction;
    }

    public GUIInventoryFunction getBuildGUIFunction() {
        return this.buildGUIFunction;
    }

    public void setBuildGUIFunction(GUIInventoryFunction gUIInventoryFunction) {
        this.buildGUIFunction = gUIInventoryFunction;
    }

    public GUIBindEventFunction getBindEventsFunction() {
        return this.bindEventsFunction;
    }

    public void setBindEventsFunction(GUIBindEventFunction gUIBindEventFunction) {
        this.bindEventsFunction = gUIBindEventFunction;
    }
}

