/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.gui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.abilities.mining.RemoteTransfer;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUIBuilder;
import us.eunoians.mcrpg.gui.GUIInventoryFunction;
import us.eunoians.mcrpg.gui.GUIItem;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.types.UnlockedAbilities;

public class EditLoadoutGUI
extends GUI {
    private EditType editType;
    private BaseAbility replaceAbility;
    private GUIInventoryFunction buildGUIFunction;
    private List<UnlockedAbilities> abilities;

    public EditLoadoutGUI(McRPGPlayer mcRPGPlayer, EditType editType) {
        super(new GUIBuilder(mcRPGPlayer));
        this.editType = editType;
        this.buildGUIFunction = gUIBuilder -> {
            UnlockedAbilities unlockedAbilities;
            FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.EDIT_LOADOUT_GUI);
            String string = "";
            if (editType == EditType.TOGGLE) {
                string = Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration.getString("Title.Toggle"));
            } else if (editType == EditType.ABILITY_UPGRADE) {
                string = Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration.getString("Title.Upgrade").replace("%AbilityPoints%", Integer.toString(mcRPGPlayer.getAbilityPoints())));
            }
            int n = McRPG.getInstance().getConfig().getInt("PlayerConfiguration.AmountOfTotalAbilities");
            int n2 = n % 9 != 0 ? n - n % 9 + 9 : n;
            Inventory inventory = Bukkit.createInventory(null, (int)n2, (String)string);
            ArrayList<GUIItem> arrayList = new ArrayList<GUIItem>();
            for (int i = 0; i < mcRPGPlayer.getAbilityLoadout().size(); ++i) {
                unlockedAbilities = mcRPGPlayer.getAbilityLoadout().get(i);
                BaseAbility baseAbility = mcRPGPlayer.getBaseAbility(unlockedAbilities);
                FileConfiguration fileConfiguration2 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.fromString(baseAbility.getGenericAbility().getSkill().getName()));
                String string2 = baseAbility.getGenericAbility().getName() + "Config.Item.";
                ItemStack itemStack = new ItemStack(Material.getMaterial((String)fileConfiguration2.getString(string2 + "Material")), fileConfiguration2.getInt(string2 + "Amount"));
                ItemMeta itemMeta = itemStack.getItemMeta();
                String string3 = "Tier" + Methods.convertToNumeral(baseAbility.getCurrentTier());
                itemMeta.setDisplayName(Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration2.getString(string2 + "DisplayName") + " " + string3));
                itemMeta.setLore(Methods.colorLore(fileConfiguration2.getStringList(string2 + "PlayerLore")));
                List list = itemMeta.getLore();
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                Object object = new ArrayList();
                for (Object object2 : itemMeta.getLore()) {
                    for (String string4 : fileConfiguration2.getConfigurationSection(baseAbility.getGenericAbility().getName() + "Config." + string3).getKeys(false)) {
                        object2 = ((String)object2).replace("%" + string4 + "%", fileConfiguration2.get(baseAbility.getGenericAbility().getName() + "Config." + string3 + "." + string4).toString());
                    }
                    object.add(object2);
                }
                if (baseAbility instanceof RemoteTransfer) {
                    Iterator iterator;
                    String string4;
                    Object object2;
                    Iterator<String> iterator2 = new ArrayList();
                    object2 = (RemoteTransfer)baseAbility;
                    if (((RemoteTransfer)object2).getLinkedChestLocation() == null) {
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string4 = (String)iterator.next();
                            string4 = string4.replace("%Location%", "None");
                            iterator2.add(string4);
                        }
                    } else {
                        iterator = object.iterator();
                        while (iterator.hasNext()) {
                            string4 = (String)iterator.next();
                            string4 = string4.replace("%Location%", "X:" + ((RemoteTransfer)object2).getLinkedChestLocation().getBlockX() + " Y:" + ((RemoteTransfer)object2).getLinkedChestLocation().getBlockY() + " Z:" + ((RemoteTransfer)object2).getLinkedChestLocation().getBlockZ());
                            iterator2.add(string4);
                        }
                    }
                    object = iterator2;
                }
                if (editType == EditType.ABILITY_UPGRADE) {
                    if (baseAbility.getCurrentTier() >= ((UnlockedAbilities)baseAbility.getGenericAbility()).getMaxTier()) {
                        for (Object object2 : fileConfiguration.getStringList("AbilityItem.MaxedLore")) {
                            object.add(Methods.color(mcRPGPlayer.getPlayer(), (String)object2));
                        }
                    } else {
                        for (Object object2 : fileConfiguration.getStringList("AbilityItem.LevelPromptLore")) {
                            object2 = ((String)object2).replace("%Level%", Integer.toString(((UnlockedAbilities)baseAbility.getGenericAbility()).tierUnlockLevel(baseAbility.getCurrentTier() + 1)));
                            object2 = ((String)object2).replace("%Tier%", Methods.convertToNumeral(baseAbility.getCurrentTier() + 1));
                            object2 = ((String)object2).replace("%Skill%", baseAbility.getGenericAbility().getSkill().getDisplayName());
                            object.add(Methods.color(mcRPGPlayer.getPlayer(), (String)object2));
                        }
                    }
                }
                itemMeta.setLore(object);
                itemStack.setItemMeta(itemMeta);
                if (baseAbility.isToggled()) {
                    for (Object object2 : fileConfiguration.getStringList("AbilityItem.ToggledOnLore")) {
                        object.add(Methods.color(mcRPGPlayer.getPlayer(), (String)object2));
                    }
                    itemMeta.setLore((List)object);
                    itemStack.setItemMeta(itemMeta);
                    itemStack.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
                } else {
                    for (Object object2 : fileConfiguration.getStringList("AbilityItem.ToggledOffLore")) {
                        object.add(Methods.color(mcRPGPlayer.getPlayer(), (String)object2));
                    }
                    itemMeta.setLore((List)object);
                    itemStack.setItemMeta(itemMeta);
                }
                arrayList.add(new GUIItem(itemStack, i));
            }
            ItemStack itemStack = new ItemStack(Material.AIR);
            if (fileConfiguration.contains("FillerItem")) {
                itemStack = new ItemStack(Material.valueOf((String)fileConfiguration.getString("FillerItem.Material")), fileConfiguration.getInt("FillerItem.Amount"));
                unlockedAbilities = itemStack.getItemMeta();
                unlockedAbilities.setDisplayName(Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration.getString("FillerItem.DisplayName")));
                unlockedAbilities.setLore(Methods.colorLore(fileConfiguration.getStringList("FillerItem.Lore")));
                itemStack.setItemMeta((ItemMeta)unlockedAbilities);
            }
            return Methods.fillInventory(inventory, itemStack, arrayList);
        };
        this.getGui().setBuildGUIFunction(this.buildGUIFunction);
        this.getGui().rebuildGUI();
        this.abilities = mcRPGPlayer.getAbilityLoadout();
    }

    public EditLoadoutGUI(McRPGPlayer mcRPGPlayer, EditType editType, BaseAbility baseAbility) {
        super(new GUIBuilder(mcRPGPlayer));
        this.editType = editType;
        this.replaceAbility = baseAbility;
        this.buildGUIFunction = gUIBuilder -> {
            UnlockedAbilities unlockedAbilities;
            String string = this.editType == EditType.ABILITY_OVERRIDE || this.editType == EditType.ABILITY_REPLACE ? "&eOverride an ability with " + baseAbility.getGenericAbility().getName() : (this.editType == EditType.ABILITY_UPGRADE ? "&Upgrade an ability! You have " + mcRPGPlayer.getAbilityPoints() + " points to spend." : "&eEdit your ability loadout");
            int n = McRPG.getInstance().getConfig().getInt("PlayerConfiguration.AmountOfTotalAbilities");
            int n2 = n % 9 != 0 ? n - n % 9 + 9 : n;
            Inventory inventory = Bukkit.createInventory(null, (int)n2, (String)Methods.color(mcRPGPlayer.getPlayer(), string));
            ArrayList<GUIItem> arrayList = new ArrayList<GUIItem>();
            for (int i = 0; i < mcRPGPlayer.getAbilityLoadout().size(); ++i) {
                unlockedAbilities = mcRPGPlayer.getAbilityLoadout().get(i);
                BaseAbility baseAbility2 = mcRPGPlayer.getBaseAbility(unlockedAbilities);
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.fromString(baseAbility2.getGenericAbility().getSkill().getName()));
                String string2 = baseAbility2.getGenericAbility().getName() + "Config.Item.";
                ItemStack itemStack = new ItemStack(Material.getMaterial((String)fileConfiguration.getString(string2 + "Material")), fileConfiguration.getInt(string2 + "Amount"));
                ItemMeta itemMeta = itemStack.getItemMeta();
                String string3 = "Tier" + Methods.convertToNumeral(baseAbility2.getCurrentTier());
                itemMeta.setDisplayName(Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration.getString(string2 + "DisplayName") + " " + string3));
                itemMeta.setLore(Methods.colorLore(fileConfiguration.getStringList(string2 + "Lore")));
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (String string4 : itemMeta.getLore()) {
                    for (String string5 : fileConfiguration.getConfigurationSection(baseAbility2.getGenericAbility().getName() + "Config." + string3).getKeys(false)) {
                        string4 = string4.replace("%" + string5 + "%", fileConfiguration.getString(baseAbility2.getGenericAbility().getName() + "Config." + string3 + "." + string5));
                    }
                    arrayList2.add(string4);
                }
                itemMeta.setLore(arrayList2);
                itemStack.setItemMeta(itemMeta);
                if (baseAbility2.isToggled()) {
                    itemStack.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
                }
                arrayList.add(new GUIItem(itemStack, i));
            }
            ItemStack itemStack = new ItemStack(Material.GRAY_STAINED_GLASS_PANE, 1);
            unlockedAbilities = itemStack.getItemMeta();
            unlockedAbilities.setDisplayName(" ");
            itemStack.setItemMeta((ItemMeta)unlockedAbilities);
            inventory = Methods.fillInventory(inventory, itemStack, arrayList);
            return inventory;
        };
        this.getGui().setBuildGUIFunction(this.buildGUIFunction);
        this.getGui().rebuildGUI();
        this.abilities = mcRPGPlayer.getAbilityLoadout();
    }

    public UnlockedAbilities getAbilityFromSlot(int n) {
        return this.abilities.get(n);
    }

    public EditType getEditType() {
        return this.editType;
    }

    public BaseAbility getReplaceAbility() {
        return this.replaceAbility;
    }

    public List<UnlockedAbilities> getAbilities() {
        return this.abilities;
    }

    public static enum EditType {
        TOGGLE,
        ABILITY_OVERRIDE,
        ABILITY_UPGRADE,
        ABILITY_REPLACE;

    }
}

