/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.gui;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUIBuilder;
import us.eunoians.mcrpg.gui.GUIInventoryFunction;
import us.eunoians.mcrpg.gui.GUIItem;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.skills.Skill;
import us.eunoians.mcrpg.types.Skills;

public class EditDefaultAbilitiesGUI
extends GUI {
    private GUIInventoryFunction buildGUIFunction;
    private ArrayList<BaseAbility> defaultAbilityList = new ArrayList();

    public EditDefaultAbilitiesGUI(McRPGPlayer mcRPGPlayer) {
        super(new GUIBuilder(mcRPGPlayer));
        this.buildGUIFunction = gUIBuilder -> {
            BaseAbility baseAbility;
            Skill skill;
            FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.EDIT_DEFAULT_ABILITIES_GUI);
            String string = Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration.getString("Title"));
            Inventory inventory = Bukkit.createInventory(null, (int)fileConfiguration.getInt("Size"), (String)string);
            ArrayList<GUIItem> arrayList = new ArrayList<GUIItem>();
            Skills[] skillsArray = Skills.values();
            int n = 0;
            for (int i = 0; i < skillsArray.length; ++i) {
                skill = mcRPGPlayer.getSkill(skillsArray[i]);
                if (!skillsArray[i].isEnabled()) continue;
                baseAbility = skill.getDefaultAbility();
                this.defaultAbilityList.add(baseAbility);
                FileConfiguration fileConfiguration2 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.fromString(skill.getName()));
                String string2 = baseAbility.getGenericAbility().getName().replace(" ", "").replace("_", "") + "Config.Item.";
                ItemStack itemStack = new ItemStack(Material.getMaterial((String)fileConfiguration2.getString(string2 + "Material")), fileConfiguration2.getInt(string2 + "Amount"));
                ItemMeta itemMeta = itemStack.getItemMeta();
                itemMeta.setDisplayName(Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration2.getString(string2 + "DisplayName")));
                itemMeta.setLore(Methods.colorLore(fileConfiguration2.getStringList(string2 + "MenuLore")));
                List list = itemMeta.getLore();
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                itemMeta.setLore(list);
                itemStack.setItemMeta(itemMeta);
                if (baseAbility.isToggled()) {
                    list.add(Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration.getString("AbilityItems.ToggledOn")));
                    itemMeta.setLore(list);
                    itemStack.setItemMeta(itemMeta);
                    itemStack.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
                } else {
                    list.add(Methods.color(fileConfiguration.getString("AbilityItems.ToggledOff")));
                    itemMeta.setLore(list);
                    itemStack.setItemMeta(itemMeta);
                }
                arrayList.add(new GUIItem(itemStack, n));
                ++n;
            }
            ItemStack itemStack = new ItemStack(Material.AIR);
            if (fileConfiguration.contains("FillerItem")) {
                itemStack = new ItemStack(Material.valueOf((String)fileConfiguration.getString("FillerItem.Material")), fileConfiguration.getInt("FillerItem.Amount"));
                skill = itemStack.getItemMeta();
                skill.setDisplayName(Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration.getString("FillerItem.DisplayName")));
                skill.setLore(Methods.colorLore(fileConfiguration.getStringList("FillerItem.Lore")));
                itemStack.setItemMeta((ItemMeta)skill);
            }
            skill = new ItemStack(Material.valueOf((String)fileConfiguration.getString("BackButton.Material")));
            baseAbility = skill.getItemMeta();
            baseAbility.setDisplayName(Methods.color(mcRPGPlayer.getPlayer(), fileConfiguration.getString("BackButton.DisplayName")));
            baseAbility.setLore(Methods.colorLore(fileConfiguration.getStringList("BackButton.Lore")));
            skill.setItemMeta((ItemMeta)baseAbility);
            arrayList.add(new GUIItem((ItemStack)skill, fileConfiguration.getInt("BackButton.Slot")));
            return Methods.fillInventory(inventory, itemStack, arrayList);
        };
        this.getGui().setBuildGUIFunction(this.buildGUIFunction);
        this.getGui().rebuildGUI();
    }

    public ArrayList<BaseAbility> getDefaultAbilityList() {
        return this.defaultAbilityList;
    }
}

