/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.events.vanilla;

import java.io.File;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.brewing.BrewingStandManager;
import us.eunoians.mcrpg.util.blockmeta.conversion.BlockStoreConversionMain;

public class WorldListener
implements Listener {
    private final McRPG plugin;
    private static boolean errored = false;

    public WorldListener(McRPG mcRPG) {
        this.plugin = mcRPG;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent structureGrowEvent) {
        if (!McRPG.getPlaceStore().isTrue(structureGrowEvent.getLocation().getBlock())) {
            return;
        }
        for (BlockState blockState : structureGrowEvent.getBlocks()) {
            McRPG.getPlaceStore().setFalse(blockState);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldInit(WorldInitEvent worldInitEvent) {
        World world = worldInitEvent.getWorld();
        if (!new File(world.getWorldFolder(), "mcmmo_data").exists() || this.plugin == null) {
            return;
        }
        this.plugin.getLogger().info("Converting block storage for " + world.getName() + " to a new format.");
        new BlockStoreConversionMain(world).run();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onWorldUnload(WorldUnloadEvent worldUnloadEvent) {
        McRPG.getPlaceStore().unloadWorld(worldUnloadEvent.getWorld());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChunkUnload(ChunkUnloadEvent chunkUnloadEvent) {
        Chunk chunk = chunkUnloadEvent.getChunk();
        BrewingStandManager brewingStandManager = McRPG.getInstance().getBrewingStandManager();
        if (chunk == null || chunkUnloadEvent.getWorld() == null) {
            return;
        }
        if (McRPG.getPlaceStore() != null) {
            McRPG.getPlaceStore().chunkUnloaded(chunk.getX(), chunk.getZ(), chunkUnloadEvent.getWorld());
        } else {
            McRPG.resetPlaceStore();
        }
        brewingStandManager.unloadChunk(chunk);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent blockPistonExtendEvent) {
        BlockFace blockFace = blockPistonExtendEvent.getDirection();
        Block block = blockPistonExtendEvent.getBlock();
        block = block.getRelative(blockFace, 2);
        for (Block block2 : blockPistonExtendEvent.getBlocks()) {
            block = block2.getRelative(blockFace);
            McRPG.getPlaceStore().setTrue(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent blockPistonRetractEvent) {
        BlockFace blockFace = blockPistonRetractEvent.getDirection();
        Block block = blockPistonRetractEvent.getBlock().getRelative(blockFace);
        McRPG.getPlaceStore().setTrue(block);
        for (Block block2 : blockPistonRetractEvent.getBlocks()) {
            block = block2.getRelative(blockFace);
            McRPG.getPlaceStore().setTrue(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityBlockFormEvent(EntityBlockFormEvent entityBlockFormEvent) {
        McRPG.getPlaceStore().setTrue(entityBlockFormEvent.getBlock());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockFormEvent(BlockFormEvent blockFormEvent) {
        if (blockFormEvent.getNewState().getType() != Material.OBSIDIAN) {
            McRPG.getPlaceStore().setTrue(blockFormEvent.getNewState());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        BlockState blockState = blockPlaceEvent.getBlock().getState();
        McRPG.getPlaceStore().setTrue(blockState);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockMultiPlace(BlockMultiPlaceEvent blockMultiPlaceEvent) {
        for (BlockState blockState : blockMultiPlaceEvent.getReplacedBlockStates()) {
            BlockState blockState2 = blockState.getBlock().getState();
            McRPG.getPlaceStore().setTrue(blockState2);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent blockGrowEvent) {
        BlockState blockState = blockGrowEvent.getBlock().getState();
        McRPG.getPlaceStore().setFalse(blockState);
    }
}

