/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.events.vanilla;

import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.archery.BlessingOfApollo;
import us.eunoians.mcrpg.abilities.archery.BlessingOfArtemis;
import us.eunoians.mcrpg.abilities.archery.Combo;
import us.eunoians.mcrpg.abilities.archery.CurseOfHades;
import us.eunoians.mcrpg.abilities.archery.Daze;
import us.eunoians.mcrpg.abilities.archery.Puncture;
import us.eunoians.mcrpg.abilities.archery.TippedArrows;
import us.eunoians.mcrpg.api.events.mcrpg.McRPGEvent;
import us.eunoians.mcrpg.api.events.mcrpg.archery.BlessingOfApolloEvent;
import us.eunoians.mcrpg.api.events.mcrpg.archery.BlessingOfArtemisEvent;
import us.eunoians.mcrpg.api.events.mcrpg.archery.ComboEvent;
import us.eunoians.mcrpg.api.events.mcrpg.archery.CurseOfHadesEvent;
import us.eunoians.mcrpg.api.events.mcrpg.archery.DazeEvent;
import us.eunoians.mcrpg.api.events.mcrpg.archery.PunctureEvent;
import us.eunoians.mcrpg.api.events.mcrpg.archery.TippedArrowsEvent;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.DefaultAbilities;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.types.UnlockedAbilities;
import us.eunoians.mcrpg.util.Parser;

public class ShootEvent
implements Listener {
    private static HashMap<UUID, BukkitTask> arrowTasks = new HashMap();

    @EventHandler
    public static void shootEvent(EntityShootBowEvent entityShootBowEvent) {
        if (PlayerManager.isPlayerFrozen(entityShootBowEvent.getEntity().getUniqueId())) {
            return;
        }
        if (McRPG.getInstance().getConfig().contains("Configuration.DisabledWorlds") && McRPG.getInstance().getConfig().getStringList("Configuration.DisabledWorlds").contains(entityShootBowEvent.getEntity().getWorld().getName())) {
            return;
        }
        if (entityShootBowEvent.getEntity() instanceof Player) {
            Player player = (Player)entityShootBowEvent.getEntity();
            if (entityShootBowEvent.getProjectile() instanceof Arrow) {
                McRPGPlayer mcRPGPlayer;
                try {
                    mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
                }
                catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                    return;
                }
                Arrow arrow = (Arrow)entityShootBowEvent.getProjectile();
                if (!Skills.ARCHERY.isEnabled()) {
                    return;
                }
                Methods.setMetadata((Entity)arrow, "ShootLoc", Methods.locToString(entityShootBowEvent.getEntity().getLocation()));
                Methods.setMetadata((Entity)arrow, "Shooter", entityShootBowEvent.getEntity().getUniqueId().toString());
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.ARCHERY_CONFIG);
                if (mcRPGPlayer.isReadying()) {
                    if (mcRPGPlayer.getReadyingAbilityBit().getAbilityReady() == UnlockedAbilities.BLESSING_OF_ARTEMIS) {
                        String string = "BlessingOfArtemisConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.BLESSING_OF_ARTEMIS).getCurrentTier()) + ".";
                        double d = fileConfiguration.getDouble(string + "DamageMultiplier");
                        int n = fileConfiguration.getInt(string + "Cooldown");
                        int n2 = fileConfiguration.getInt(string + "InvisDuration");
                        BlessingOfArtemisEvent blessingOfArtemisEvent = new BlessingOfArtemisEvent(mcRPGPlayer, (BlessingOfArtemis)mcRPGPlayer.getBaseAbility(UnlockedAbilities.BLESSING_OF_ARTEMIS), n, n2, d);
                        Bukkit.getPluginManager().callEvent((Event)blessingOfArtemisEvent);
                        if (!blessingOfArtemisEvent.isCancelled()) {
                            Methods.setMetadata((Entity)arrow, "Artemis", blessingOfArtemisEvent.getDmgMultiplier());
                            player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, blessingOfArtemisEvent.getInvisDuration() * 20, 0));
                            Calendar calendar = Calendar.getInstance();
                            calendar.add(13, blessingOfArtemisEvent.getCooldown());
                            mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.BLESSING_OF_ARTEMIS, calendar.getTimeInMillis());
                            mcRPGPlayer.setReadying(false);
                            Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                            mcRPGPlayer.setReadyingAbilityBit(null);
                            FileConfiguration fileConfiguration2 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SOUNDS_FILE);
                            player.getLocation().getWorld().playSound(player.getLocation(), Sound.valueOf((String)fileConfiguration2.getString("Sounds.Archery.BlessingOfArtemis.Sound")), (float)fileConfiguration2.getInt("Sounds.Archery.BlessingOfArtemis.Volume"), (float)fileConfiguration2.getInt("Sounds.Archery.BlessingOfArtemis.Pitch"));
                            player.getLocation().getWorld().spawnParticle(Particle.SMOKE_LARGE, player.getEyeLocation(), 1);
                            ShootEvent.trackArrowParticles(arrow, Particle.SMOKE_NORMAL);
                            player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.BlessingOfArtemis.Activated")));
                        }
                    } else if (mcRPGPlayer.getReadyingAbilityBit().getAbilityReady() == UnlockedAbilities.BLESSING_OF_APOLLO) {
                        String string = "BlessingOfApolloConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.BLESSING_OF_APOLLO).getCurrentTier()) + ".";
                        int n = fileConfiguration.getInt(string + "Cooldown");
                        int n3 = fileConfiguration.getInt(string + "FireResDuration");
                        int n4 = fileConfiguration.getInt(string + "IgniteDuration");
                        BlessingOfApolloEvent blessingOfApolloEvent = new BlessingOfApolloEvent(mcRPGPlayer, (BlessingOfApollo)mcRPGPlayer.getBaseAbility(UnlockedAbilities.BLESSING_OF_APOLLO), n, n3, n4);
                        Bukkit.getPluginManager().callEvent((Event)blessingOfApolloEvent);
                        if (!blessingOfApolloEvent.isCancelled()) {
                            Methods.setMetadata((Entity)arrow, "Apollo", blessingOfApolloEvent.getIgniteDuration());
                            player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, blessingOfApolloEvent.getFireResDuration() * 20, 0));
                            Calendar calendar = Calendar.getInstance();
                            calendar.add(13, blessingOfApolloEvent.getCooldown());
                            mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.BLESSING_OF_APOLLO, calendar.getTimeInMillis());
                            mcRPGPlayer.setReadying(false);
                            Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                            mcRPGPlayer.setReadyingAbilityBit(null);
                            FileConfiguration fileConfiguration3 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SOUNDS_FILE);
                            player.getLocation().getWorld().playSound(player.getLocation(), Sound.valueOf((String)fileConfiguration3.getString("Sounds.Archery.BlessingOfApollo.Sound")), (float)fileConfiguration3.getInt("Sounds.Archery.BlessingOfApollo.Volume"), (float)fileConfiguration3.getInt("Sounds.Archery.BlessingOfApollo.Pitch"));
                            ShootEvent.trackArrowParticles(arrow, Particle.FLAME);
                            player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.BlessingOfApollo.Activated")));
                        }
                    } else if (mcRPGPlayer.getReadyingAbilityBit().getAbilityReady() == UnlockedAbilities.CURSE_OF_HADES) {
                        String string = "CurseOfHadesConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.CURSE_OF_HADES).getCurrentTier()) + ".";
                        int n = fileConfiguration.getInt(string + "Cooldown");
                        int n5 = fileConfiguration.getInt(string + "WitherDuration");
                        int n6 = fileConfiguration.getInt(string + "WitherLevel");
                        int n7 = fileConfiguration.getInt(string + "SlownessDuration");
                        int n8 = fileConfiguration.getInt(string + "SlownessLevel");
                        int n9 = fileConfiguration.getInt(string + "BlindnessDuration");
                        CurseOfHadesEvent curseOfHadesEvent = new CurseOfHadesEvent(mcRPGPlayer, (CurseOfHades)mcRPGPlayer.getBaseAbility(UnlockedAbilities.CURSE_OF_HADES), n, n5, n6, n7, n8, n9);
                        Bukkit.getPluginManager().callEvent((Event)curseOfHadesEvent);
                        if (!curseOfHadesEvent.isCancelled()) {
                            Methods.setMetadata((Entity)arrow, "Hades1", curseOfHadesEvent.getWitherDuration());
                            Methods.setMetadata((Entity)arrow, "Hades2", curseOfHadesEvent.getWitherLevel());
                            Methods.setMetadata((Entity)arrow, "Hades3", curseOfHadesEvent.getSlownessDuration());
                            Methods.setMetadata((Entity)arrow, "Hades4", curseOfHadesEvent.getSlownessLevel());
                            Methods.setMetadata((Entity)arrow, "Hades5", curseOfHadesEvent.getBlindnessDuration());
                            Calendar calendar = Calendar.getInstance();
                            calendar.add(13, curseOfHadesEvent.getCooldown());
                            mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.CURSE_OF_HADES, calendar.getTimeInMillis());
                            mcRPGPlayer.setReadying(false);
                            Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                            mcRPGPlayer.setReadyingAbilityBit(null);
                            FileConfiguration fileConfiguration4 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SOUNDS_FILE);
                            player.getLocation().getWorld().playSound(player.getLocation(), Sound.valueOf((String)fileConfiguration4.getString("Sounds.Archery.CurseOfHades.Sound")), (float)fileConfiguration4.getInt("Sounds.Archery.CurseOfHades.Volume"), (float)fileConfiguration4.getInt("Sounds.Archery.CurseOfHades.Pitch"));
                            ShootEvent.trackArrowParticles(arrow, Particle.SQUID_INK);
                            player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.CurseOfHades.Activated")));
                        }
                    }
                } else {
                    Random random;
                    int n;
                    int n10;
                    Random random2;
                    int n11;
                    int n12;
                    Object object;
                    if (entityShootBowEvent.getProjectile().getType() == EntityType.ARROW && DefaultAbilities.DAZE.isEnabled() && mcRPGPlayer.getBaseAbility(DefaultAbilities.DAZE).isToggled()) {
                        Parser parser = DefaultAbilities.DAZE.getActivationEquation();
                        parser.setVariable("archery_level", mcRPGPlayer.getSkill(Skills.ARCHERY).getCurrentLevel());
                        parser.setVariable("power_level", mcRPGPlayer.getPowerLevel());
                        int n13 = (int)(parser.getValue() * 1000.0);
                        Random random3 = new Random();
                        int n14 = random3.nextInt(100000);
                        if (n13 >= n14) {
                            Daze daze = (Daze)mcRPGPlayer.getBaseAbility(DefaultAbilities.DAZE);
                            object = "DazeConfig.";
                            int n15 = fileConfiguration.getInt(object + "NauseaDuration");
                            int n16 = fileConfiguration.getInt(object + "BlindnessDuration");
                            boolean bl = fileConfiguration.getBoolean(object + "MakePlayerLookUp");
                            DazeEvent dazeEvent = new DazeEvent(mcRPGPlayer, daze, bl, n16, n15);
                            Bukkit.getPluginManager().callEvent((Event)dazeEvent);
                            if (!dazeEvent.isCancelled()) {
                                Methods.setMetadata((Entity)arrow, "DazeN", dazeEvent.getNauseaDuration());
                                Methods.setMetadata((Entity)arrow, "DazeB", dazeEvent.getBlindnessDuration());
                                Methods.setMetadata((Entity)arrow, "DazeF", dazeEvent.isForcePlayerLookup());
                            }
                        }
                    }
                    if (UnlockedAbilities.PUNCTURE.isEnabled() && mcRPGPlayer.getAbilityLoadout().contains(UnlockedAbilities.PUNCTURE) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.PUNCTURE).isToggled() && (n12 = fileConfiguration.getInt("PunctureConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.PUNCTURE).getCurrentTier()) + ".ActivationChance") * 1000) >= (n11 = (random2 = new Random()).nextInt(100000))) {
                        PunctureEvent punctureEvent = new PunctureEvent(mcRPGPlayer, (Puncture)mcRPGPlayer.getBaseAbility(UnlockedAbilities.PUNCTURE));
                        Bukkit.getPluginManager().callEvent((Event)punctureEvent);
                        if (!punctureEvent.isCancelled()) {
                            Methods.setMetadata((Entity)arrow, "Puncture", player.getUniqueId().toString());
                        }
                    }
                    if (UnlockedAbilities.TIPPED_ARROWS.isEnabled() && mcRPGPlayer.getAbilityLoadout().contains(UnlockedAbilities.TIPPED_ARROWS) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.TIPPED_ARROWS).isToggled() && (n10 = fileConfiguration.getInt("TippedArrowsConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.TIPPED_ARROWS).getCurrentTier()) + ".ActivationChance") * 1000) >= (n = (random = new Random()).nextInt(100000))) {
                        List list = fileConfiguration.getStringList("TippedArrowsConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.TIPPED_ARROWS).getCurrentTier()) + ".PossibleEffects");
                        int n17 = random.nextInt(list.size());
                        object = new TippedArrowsEvent(mcRPGPlayer, (TippedArrows)mcRPGPlayer.getBaseAbility(UnlockedAbilities.TIPPED_ARROWS), (String)list.get(n17));
                        if (!((McRPGEvent)((Object)object)).isCancelled()) {
                            Methods.setMetadata((Entity)arrow, "TippedArrows", ((TippedArrowsEvent)((Object)object)).getEffectString());
                        }
                    }
                    if (UnlockedAbilities.COMBO.isEnabled() && mcRPGPlayer.getAbilityLoadout().contains(UnlockedAbilities.COMBO) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.COMBO).isToggled()) {
                        if (player.hasMetadata("ComboCooldown")) {
                            long l = ((MetadataValue)player.getMetadata("ComboCooldown").get(0)).asLong();
                            Calendar calendar = Calendar.getInstance();
                            if (calendar.getTimeInMillis() - l >= (long)fileConfiguration.getInt("ComboConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.COMBO).getCurrentTier()) + ".CooldownBetweenActivation")) {
                                player.removeMetadata("ComboCooldown", (Plugin)McRPG.getInstance());
                            } else {
                                return;
                            }
                        }
                        String string = "ComboConfig.Tier" + Methods.convertToNumeral(mcRPGPlayer.getBaseAbility(UnlockedAbilities.COMBO).getCurrentTier()) + ".";
                        double d = fileConfiguration.getDouble(string + "DamageMultiplier");
                        int n18 = fileConfiguration.getInt(string + "MaxLengthBetweenShots");
                        int n19 = fileConfiguration.getInt(string + "CooldownBetweenActivation");
                        object = new ComboEvent(mcRPGPlayer, (Combo)mcRPGPlayer.getBaseAbility(UnlockedAbilities.COMBO), d, n18, n19);
                        Bukkit.getPluginManager().callEvent((Event)object);
                        if (!((McRPGEvent)((Object)object)).isCancelled()) {
                            Methods.setMetadata((Entity)arrow, "Combo1", player.getUniqueId().toString());
                            Methods.setMetadata((Entity)arrow, "Combo2", ((ComboEvent)((Object)object)).getDmgMultiplier());
                            Methods.setMetadata((Entity)arrow, "Combo3", n18);
                            Methods.setMetadata((Entity)arrow, "Combo4", n19);
                        }
                    }
                }
            } else {
                return;
            }
        }
    }

    public static void trackArrowParticles(final Arrow arrow, final Particle particle) {
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                if (!arrow.isValid()) {
                    ((BukkitTask)arrowTasks.remove(arrow.getUniqueId())).cancel();
                    return;
                }
                arrow.getLocation().getWorld().spawnParticle(particle, arrow.getLocation(), 4);
            }
        }.runTaskTimer((Plugin)McRPG.getInstance(), 10L, 15L);
        arrowTasks.put(arrow.getUniqueId(), bukkitTask);
    }

    public static HashMap<UUID, BukkitTask> getArrowTasks() {
        return arrowTasks;
    }
}

