/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.events.vanilla;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.swords.RageSpike;
import us.eunoians.mcrpg.api.events.mcrpg.swords.PreRageSpikeEvent;
import us.eunoians.mcrpg.api.events.mcrpg.swords.RageSpikeDamageEvent;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.UnlockedAbilities;

public class ShiftToggle
implements Listener {
    private static Map<UUID, Integer> playersCharging = new HashMap<UUID, Integer>();

    public static boolean isPlayerCharging(Player player) {
        return playersCharging.containsKey(player.getUniqueId());
    }

    public static void removePlayerCharging(Player player) {
        Bukkit.getScheduler().cancelTask(playersCharging.remove(player).intValue());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void shiftToggle(final PlayerToggleSneakEvent playerToggleSneakEvent) {
        McRPGPlayer mcRPGPlayer;
        if (PlayerManager.isPlayerFrozen(playerToggleSneakEvent.getPlayer().getUniqueId())) {
            return;
        }
        if (McRPG.getInstance().getConfig().contains("Configuration.DisabledWorlds") && McRPG.getInstance().getConfig().getStringList("Configuration.DisabledWorlds").contains(playerToggleSneakEvent.getPlayer().getWorld().getName())) {
            return;
        }
        final Player player = playerToggleSneakEvent.getPlayer();
        try {
            mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
        }
        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
            return;
        }
        if (mcRPGPlayer.isReadying() && playerToggleSneakEvent.isSneaking() && mcRPGPlayer.getReadyingAbilityBit() != null && mcRPGPlayer.getReadyingAbilityBit().getAbilityReady() == UnlockedAbilities.RAGE_SPIKE) {
            final PreRageSpikeEvent preRageSpikeEvent = new PreRageSpikeEvent(mcRPGPlayer, (RageSpike)mcRPGPlayer.getBaseAbility(UnlockedAbilities.RAGE_SPIKE));
            Bukkit.getPluginManager().callEvent((Event)preRageSpikeEvent);
            if (playerToggleSneakEvent.isCancelled()) {
                return;
            }
            mcRPGPlayer.getActiveAbilities().add(UnlockedAbilities.RAGE_SPIKE);
            int n = (int)preRageSpikeEvent.getChargeTime() * 20;
            player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.RageSpike.Charging").replace("%Charge%", Double.toString(preRageSpikeEvent.getChargeTime()))));
            int n2 = new BukkitRunnable(){

                public void run() {
                    Vector vector = new Vector(player.getLocation().getDirection().getX(), 0.0, player.getLocation().getDirection().getZ());
                    FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SOUNDS_FILE);
                    player.getLocation().getWorld().playSound(player.getLocation(), Sound.valueOf((String)fileConfiguration.getString("Sounds.Swords.RageSpike.Sound")), (float)fileConfiguration.getDouble("Sounds.Swords.RageSpike.Volume"), (float)fileConfiguration.getDouble("Sounds.Swords.RageSpike.Pitch"));
                    playerToggleSneakEvent.getPlayer().setVelocity(vector.multiply(5));
                    playerToggleSneakEvent.getPlayer().setVelocity(vector.multiply(5));
                    final AtomicInteger atomicInteger = new AtomicInteger(0);
                    final ArrayList arrayList = new ArrayList();
                    new BukkitRunnable(){

                        public void run() {
                            if (atomicInteger.incrementAndGet() == 21) {
                                this.cancel();
                            } else {
                                for (Entity entity : player.getNearbyEntities(2.0, 2.0, 2.0)) {
                                    if (!(entity instanceof LivingEntity) || ShiftToggle.isNPCEntity(entity) || entity instanceof ArmorStand || arrayList.contains(entity.getUniqueId())) continue;
                                    LivingEntity livingEntity = (LivingEntity)entity;
                                    RageSpikeDamageEvent rageSpikeDamageEvent = new RageSpikeDamageEvent(mcRPGPlayer, (RageSpike)mcRPGPlayer.getBaseAbility(UnlockedAbilities.RAGE_SPIKE), livingEntity, preRageSpikeEvent.getDamage());
                                    Bukkit.getPluginManager().callEvent((Event)rageSpikeDamageEvent);
                                    if (rageSpikeDamageEvent.isCancelled()) continue;
                                    Vector vector = new Vector(entity.getLocation().getDirection().getX(), entity.getLocation().getDirection().getY(), player.getLocation().getDirection().getZ());
                                    entity.setVelocity(vector.multiply(-4.3));
                                    livingEntity.damage((double)rageSpikeDamageEvent.getDamage());
                                    arrayList.add(entity.getUniqueId());
                                }
                            }
                        }
                    }.runTaskTimer((Plugin)McRPG.getInstance(), 0L, 1L);
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(13, preRageSpikeEvent.getCooldown());
                    mcRPGPlayer.getActiveAbilities().remove(UnlockedAbilities.RAGE_SPIKE);
                    mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.RAGE_SPIKE, calendar.getTimeInMillis());
                    playersCharging.remove(player.getUniqueId());
                }
            }.runTaskLater((Plugin)McRPG.getInstance(), (long)n).getTaskId();
            playersCharging.put(player.getUniqueId(), n2);
            mcRPGPlayer.setReadying(false);
            Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
            mcRPGPlayer.setReadyingAbilityBit(null);
        } else if (ShiftToggle.isPlayerCharging(player) && !playerToggleSneakEvent.isSneaking()) {
            Bukkit.getScheduler().cancelTask(playersCharging.remove(player.getUniqueId()).intValue());
            player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.RageSpike.ChargeCancelled")));
            mcRPGPlayer.getActiveAbilities().remove(UnlockedAbilities.RAGE_SPIKE);
            return;
        }
    }

    private static boolean isNPCEntity(Entity entity) {
        return entity == null || entity.hasMetadata("NPC") || entity instanceof NPC || entity.getClass().getName().equalsIgnoreCase("cofh.entity.PlayerFake");
    }
}

