/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.events.vanilla;

import java.util.ArrayList;
import java.util.Iterator;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.sorcery.PotionAffinity;
import us.eunoians.mcrpg.api.events.mcrpg.sorcery.PotionAffinityEvent;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.brewing.BasePotion;
import us.eunoians.mcrpg.api.util.brewing.PotionFactory;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.UnlockedAbilities;

public class PotionDrinkEvent
implements Listener {
    @EventHandler
    public void drinkEvent(PlayerItemConsumeEvent playerItemConsumeEvent) {
        if (playerItemConsumeEvent.getItem().getType() == Material.POTION) {
            if (McRPG.getInstance().getConfig().contains("Configuration.DisabledWorlds") && McRPG.getInstance().getConfig().getStringList("Configuration.DisabledWorlds").contains(playerItemConsumeEvent.getPlayer().getWorld().getName())) {
                return;
            }
            PotionMeta potionMeta = (PotionMeta)playerItemConsumeEvent.getItem().getItemMeta();
            try {
                McRPGPlayer mcRPGPlayer = PlayerManager.getPlayer(playerItemConsumeEvent.getPlayer().getUniqueId());
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SORCERY_CONFIG);
                if (fileConfiguration.getBoolean("SorceryEnabled") && UnlockedAbilities.POTION_AFFINITY.isEnabled() && mcRPGPlayer.doesPlayerHaveAbilityInLoadout(UnlockedAbilities.POTION_AFFINITY) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.POTION_AFFINITY).isToggled()) {
                    PotionAffinity potionAffinity = (PotionAffinity)mcRPGPlayer.getBaseAbility(UnlockedAbilities.POTION_AFFINITY);
                    double d = fileConfiguration.getDouble("PotionAffinityConfig.Tier" + Methods.convertToNumeral(potionAffinity.getCurrentTier()) + ".PotionDurationBonus");
                    PotionAffinityEvent potionAffinityEvent = new PotionAffinityEvent(potionAffinity, mcRPGPlayer, d, playerItemConsumeEvent.getItem());
                    Bukkit.getPluginManager().callEvent((Event)potionAffinityEvent);
                    if (!potionAffinityEvent.isCancelled()) {
                        Object object;
                        d = potionAffinityEvent.getDurationMultiplier();
                        d /= 100.0;
                        d += 1.0;
                        ItemStack itemStack = playerItemConsumeEvent.getItem();
                        if (potionMeta.getBasePotionData().getType() != PotionType.UNCRAFTABLE) {
                            object = PotionFactory.convertItemStackToBasePotion(playerItemConsumeEvent.getItem());
                            itemStack = ((BasePotion)object).getAsItem();
                        }
                        if (potionMeta.hasCustomEffects()) {
                            object = potionMeta.getCustomEffects();
                            ArrayList<PotionEffect> arrayList = new ArrayList<PotionEffect>();
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                PotionEffect potionEffect = (PotionEffect)iterator.next();
                                PotionEffect potionEffect2 = new PotionEffect(potionEffect.getType(), (int)((double)potionEffect.getDuration() * d), potionEffect.getAmplifier());
                                arrayList.add(potionEffect2);
                            }
                            potionMeta.clearCustomEffects();
                            for (PotionEffect potionEffect : arrayList) {
                                potionMeta.addCustomEffect(potionEffect, true);
                            }
                        }
                        itemStack.setItemMeta((ItemMeta)potionMeta);
                        playerItemConsumeEvent.setItem(itemStack);
                    }
                }
            }
            catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                mcRPGPlayerNotFoundException.printStackTrace();
            }
        }
    }
}

