/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.events.vanilla;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.events.vanilla.ShiftToggle;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;

public class PlayerLogoutEvent
implements Listener {
    private static HashMap<UUID, BukkitTask> playerLogOutTasks = new HashMap();

    public static boolean hasPlayer(UUID uUID) {
        return playerLogOutTasks.containsKey(uUID);
    }

    public static void cancelRemove(UUID uUID) {
        playerLogOutTasks.remove(uUID).cancel();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void logout(PlayerQuitEvent playerQuitEvent) {
        final Player player = playerQuitEvent.getPlayer();
        try {
            McRPGPlayer mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
        }
        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
            return;
        }
        if (McRPG.getInstance().getDisplayManager().doesPlayerHaveDisplay(player)) {
            McRPG.getInstance().getDisplayManager().removePlayersDisplay(player);
        }
        if (ShiftToggle.isPlayerCharging(player)) {
            ShiftToggle.removePlayerCharging(player);
        }
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                if (!player.isOnline() && PlayerManager.isPlayerStored(player.getUniqueId())) {
                    PlayerManager.removePlayer(player.getUniqueId());
                }
                playerLogOutTasks.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)McRPG.getInstance(), 6000L);
        playerLogOutTasks.put(player.getUniqueId(), bukkitTask);
    }
}

