/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.events.vanilla;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.block.Block;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.BaseAbility;
import us.eunoians.mcrpg.abilities.excavation.Extraction;
import us.eunoians.mcrpg.abilities.excavation.FrenzyDig;
import us.eunoians.mcrpg.abilities.excavation.HandDigging;
import us.eunoians.mcrpg.abilities.herbalism.MassHarvest;
import us.eunoians.mcrpg.abilities.herbalism.PansBlessing;
import us.eunoians.mcrpg.abilities.mining.BlastMining;
import us.eunoians.mcrpg.abilities.mining.DoubleDrop;
import us.eunoians.mcrpg.abilities.mining.OreScanner;
import us.eunoians.mcrpg.abilities.mining.SuperBreaker;
import us.eunoians.mcrpg.api.events.mcrpg.excavation.FrenzyDigEvent;
import us.eunoians.mcrpg.api.events.mcrpg.excavation.HandDiggingEvent;
import us.eunoians.mcrpg.api.events.mcrpg.herbalism.MassHarvestEvent;
import us.eunoians.mcrpg.api.events.mcrpg.herbalism.PansBlessingEvent;
import us.eunoians.mcrpg.api.events.mcrpg.mining.BlastMiningEvent;
import us.eunoians.mcrpg.api.events.mcrpg.mining.BlastTestEvent;
import us.eunoians.mcrpg.api.events.mcrpg.mining.OreScannerEvent;
import us.eunoians.mcrpg.api.events.mcrpg.mining.SuperBreakerEvent;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.brewing.BrewingStandManager;
import us.eunoians.mcrpg.api.util.brewing.standmeta.BrewingGUI;
import us.eunoians.mcrpg.events.vanilla.BreakEvent;
import us.eunoians.mcrpg.gui.GUI;
import us.eunoians.mcrpg.gui.GUITracker;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.players.PlayerReadyBit;
import us.eunoians.mcrpg.types.DefaultAbilities;
import us.eunoians.mcrpg.types.Skills;
import us.eunoians.mcrpg.types.UnlockedAbilities;
import us.eunoians.mcrpg.util.mcmmo.ItemUtils;

public class InteractHandler
implements Listener {
    private static ItemStack shovel;

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void interactHandler(PlayerInteractEvent playerInteractEvent) {
        McRPGPlayer mcRPGPlayer;
        Player player;
        if (PlayerManager.isPlayerFrozen(playerInteractEvent.getPlayer().getUniqueId())) {
            return;
        }
        if (shovel == null) {
            shovel = new ItemStack(Material.DIAMOND_SHOVEL);
            shovel.addEnchantment(Enchantment.SILK_TOUCH, 1);
            player = shovel.getItemMeta();
            player.setUnbreakable(true);
            shovel.setItemMeta((ItemMeta)player);
        }
        player = playerInteractEvent.getPlayer();
        try {
            mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
        }
        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
            return;
        }
        if (!playerInteractEvent.isCancelled() && playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK && playerInteractEvent.getClickedBlock().getType() == Material.BREWING_STAND) {
            if (player.isSneaking() && player.getInventory().getItemInMainHand() != null && player.getInventory().getItemInMainHand().getType() != Material.AIR) {
                return;
            }
            BrewingStand brewingStand = (BrewingStand)playerInteractEvent.getClickedBlock().getState();
            if (!Skills.SORCERY.isEnabled()) {
                return;
            }
            mcRPGPlayer.getPlayer().incrementStatistic(Statistic.BREWINGSTAND_INTERACTION);
            BrewingStandManager brewingStandManager = McRPG.getInstance().getBrewingStandManager();
            BrewingGUI brewingGUI = brewingStandManager.isBrewingStandLoaded(brewingStand) ? brewingStandManager.getBrewingStandWrapper(brewingStand).getBrewingGUI() : McRPG.getInstance().getBrewingStandManager().initNewBrewingStand(brewingStand).getBrewingGUI();
            brewingGUI.setLastInteractedPlayer((OfflinePlayer)player);
            GUITracker.trackPlayer(player, (GUI)brewingGUI);
            playerInteractEvent.setCancelled(true);
            player.openInventory(brewingGUI.getInv());
            return;
        }
        ItemStack itemStack = playerInteractEvent.getItem();
        if (itemStack == null) {
            if (mcRPGPlayer.isHandDigging() && playerInteractEvent.getClickedBlock() != null && mcRPGPlayer.getHandDiggingBlocks().contains(playerInteractEvent.getClickedBlock().getType())) {
                playerInteractEvent.getClickedBlock().breakNaturally(shovel);
            }
            return;
        }
        if (playerInteractEvent.isCancelled() && playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        Material material = block == null ? Material.AIR : block.getType();
        if (mcRPGPlayer.isReadying()) {
            PlayerReadyBit playerReadyBit = mcRPGPlayer.getReadyingAbilityBit();
            if (playerReadyBit == null) {
                mcRPGPlayer.setReadying(false);
                return;
            }
            UnlockedAbilities unlockedAbilities = playerReadyBit.getAbilityReady();
            BaseAbility baseAbility = mcRPGPlayer.getSkill(unlockedAbilities.getSkill()).getAbility(unlockedAbilities);
            if (unlockedAbilities == UnlockedAbilities.BLAST_MINING) {
                if (itemStack.getType() == Material.TNT) {
                    BlastMining blastMining = (BlastMining)baseAbility;
                    FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.MINING_CONFIG);
                    playerInteractEvent.setCancelled(true);
                    String string = "BlastMiningConfig.Tier" + Methods.convertToNumeral(blastMining.getCurrentTier());
                    int n = fileConfiguration.getInt(string + ".Radius");
                    int n2 = fileConfiguration.getInt(string + ".Cooldown");
                    boolean bl = fileConfiguration.getBoolean(string + ".UseBlackList");
                    boolean bl2 = fileConfiguration.getBoolean(string + ".UseWhiteList");
                    List list = fileConfiguration.getStringList(string + ".BlackList");
                    List list2 = fileConfiguration.getStringList(string + ".WhiteList");
                    ArrayList<Block> arrayList = new ArrayList<Block>();
                    for (int i = -1 * n; i < n; ++i) {
                        for (int j = -1 * n; j < n; ++j) {
                            for (int k = -1 * n; k < n; ++k) {
                                arrayList.add(playerInteractEvent.getClickedBlock().getLocation().add((double)i, (double)k, (double)j).getBlock());
                            }
                        }
                    }
                    BlastMiningEvent blastMiningEvent = new BlastMiningEvent(mcRPGPlayer, blastMining, arrayList, n2);
                    Bukkit.getPluginManager().callEvent((Event)blastMiningEvent);
                    if (!blastMiningEvent.isCancelled()) {
                        mcRPGPlayer.getActiveAbilities().add(UnlockedAbilities.BLAST_MINING);
                        itemStack.setAmount(itemStack.getAmount() - 1);
                        if (itemStack.getAmount() <= 0) {
                            itemStack.setType(Material.AIR);
                        }
                        player.getLocation().getWorld().spawnParticle(Particle.EXPLOSION_NORMAL, player.getLocation(), 30);
                        FileConfiguration fileConfiguration2 = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SOUNDS_FILE);
                        player.getLocation().getWorld().playSound(player.getLocation(), Sound.valueOf((String)fileConfiguration2.getString("Sounds.Mining.BlastMining.Sound")), (float)fileConfiguration2.getInt("Sounds.Mining.BlastMining.Volume"), (float)fileConfiguration2.getInt("Sounds.Mining.BlastMining.Pitch"));
                        ItemStack itemStack2 = new ItemStack(Material.DIAMOND_PICKAXE, 1);
                        for (Block block2 : blastMiningEvent.getBlocks()) {
                            Material material2 = block2.getType();
                            if (material2 == Material.WATER || material2 == Material.LAVA || material2.toString().contains("AIR") || bl && list.contains(material2.toString()) || bl2 && !list2.contains(material2.toString())) continue;
                            BlastTestEvent blastTestEvent = new BlastTestEvent(block2, player);
                            Bukkit.getPluginManager().callEvent((Event)blastTestEvent);
                            if (blastTestEvent.isCancelled()) continue;
                            block2.breakNaturally(itemStack2);
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(13, blastMiningEvent.getCooldown());
                        Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                        mcRPGPlayer.setReadyingAbilityBit(null);
                        mcRPGPlayer.setReadying(false);
                        mcRPGPlayer.getActiveAbilities().remove(UnlockedAbilities.BLAST_MINING);
                        mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.BLAST_MINING, calendar.getTimeInMillis());
                    }
                }
                return;
            }
            if (unlockedAbilities.equals(UnlockedAbilities.SUPER_BREAKER) && (playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK || playerInteractEvent.getAction() == Action.LEFT_CLICK_AIR)) {
                SuperBreaker superBreaker = (SuperBreaker)baseAbility;
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.MINING_CONFIG);
                int n = fileConfiguration.getInt("SuperBreakerConfig.Tier" + Methods.convertToNumeral(superBreaker.getCurrentTier()) + ".Duration");
                int n3 = fileConfiguration.getInt("SuperBreakerConfig.Tier" + Methods.convertToNumeral(superBreaker.getCurrentTier()) + ".Cooldown");
                double d = fileConfiguration.getDouble("SuperBreakerConfig.Tier" + Methods.convertToNumeral(superBreaker.getCurrentTier()) + ".ActivationBoost");
                final SuperBreakerEvent superBreakerEvent = new SuperBreakerEvent(mcRPGPlayer, superBreaker, n3, d, n);
                Bukkit.getPluginManager().callEvent((Event)superBreakerEvent);
                if (superBreakerEvent.isCancelled()) {
                    return;
                }
                mcRPGPlayer.getActiveAbilities().add(UnlockedAbilities.SUPER_BREAKER);
                Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                mcRPGPlayer.setReadyingAbilityBit(null);
                mcRPGPlayer.setReadying(false);
                final DoubleDrop doubleDrop = (DoubleDrop)mcRPGPlayer.getBaseAbility(DefaultAbilities.DOUBLE_DROP);
                doubleDrop.setBonusChance(doubleDrop.getBonusChance() + superBreakerEvent.getBoost());
                PotionEffect potionEffect = new PotionEffect(PotionEffectType.FAST_DIGGING, superBreakerEvent.getHasteDuration() * 20, 20);
                player.addPotionEffect(potionEffect);
                mcRPGPlayer.getPlayer().sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.SuperBreaker.Activated")));
                new BukkitRunnable(){

                    public void run() {
                        Calendar calendar;
                        doubleDrop.setBonusChance(0.0);
                        if (mcRPGPlayer.isOnline()) {
                            mcRPGPlayer.getPlayer().sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.SuperBreaker.Deactivated")));
                            calendar = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SOUNDS_FILE);
                            mcRPGPlayer.getPlayer().getLocation().getWorld().playSound(mcRPGPlayer.getPlayer().getLocation(), Sound.valueOf((String)calendar.getString("Sounds.Mining.SuperBreaker.Sound")), (float)calendar.getInt("Sounds.Mining.SuperBreaker.Volume"), (float)calendar.getInt("Sounds.Mining.SuperBreaker.Pitch"));
                        }
                        calendar = Calendar.getInstance();
                        calendar.add(13, superBreakerEvent.getCooldown());
                        mcRPGPlayer.getActiveAbilities().remove(UnlockedAbilities.SUPER_BREAKER);
                        mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.SUPER_BREAKER, calendar.getTimeInMillis());
                    }
                }.runTaskLater((Plugin)McRPG.getInstance(), (long)(superBreakerEvent.getHasteDuration() * 20));
                return;
            }
            if (unlockedAbilities.equals(UnlockedAbilities.FRENZY_DIG) && (playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK || playerInteractEvent.getAction() == Action.LEFT_CLICK_AIR)) {
                FrenzyDig frenzyDig = (FrenzyDig)baseAbility;
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.EXCAVATION_CONFIG);
                int n = fileConfiguration.getInt("FrenzyDigConfig.Tier" + Methods.convertToNumeral(frenzyDig.getCurrentTier()) + ".Duration");
                int n4 = fileConfiguration.getInt("FrenzyDigConfig.Tier" + Methods.convertToNumeral(frenzyDig.getCurrentTier()) + ".Cooldown");
                double d = fileConfiguration.getDouble("FrenzyDigConfig.Tier" + Methods.convertToNumeral(frenzyDig.getCurrentTier()) + ".ActivationBoost");
                final FrenzyDigEvent frenzyDigEvent = new FrenzyDigEvent(mcRPGPlayer, frenzyDig, n, n4, d);
                Bukkit.getPluginManager().callEvent((Event)frenzyDigEvent);
                if (frenzyDigEvent.isCancelled()) {
                    return;
                }
                Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                mcRPGPlayer.setReadyingAbilityBit(null);
                mcRPGPlayer.setReadying(false);
                final Extraction extraction = (Extraction)mcRPGPlayer.getBaseAbility(DefaultAbilities.EXTRACTION);
                extraction.setBonusChance(extraction.getBonusChance() + frenzyDigEvent.getExtractionBuff());
                PotionEffect potionEffect = new PotionEffect(PotionEffectType.FAST_DIGGING, frenzyDigEvent.getHasteDuration() * 20, 20);
                player.addPotionEffect(potionEffect);
                mcRPGPlayer.getPlayer().sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.FrenzyDig.Activated")));
                mcRPGPlayer.getActiveAbilities().add(UnlockedAbilities.FRENZY_DIG);
                new BukkitRunnable(){

                    public void run() {
                        Calendar calendar;
                        extraction.setBonusChance(0.0);
                        if (mcRPGPlayer.isOnline()) {
                            mcRPGPlayer.getPlayer().sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.FrenzyDig.Deactivated")));
                            calendar = McRPG.getInstance().getFileManager().getFile(FileManager.Files.SOUNDS_FILE);
                            mcRPGPlayer.getPlayer().getLocation().getWorld().playSound(mcRPGPlayer.getPlayer().getLocation(), Sound.valueOf((String)calendar.getString("Sounds.Excavation.FrenzyDig.Sound")), (float)calendar.getInt("Sounds.Excavation.FrenzyDig.Volume"), (float)calendar.getInt("Sounds.Excavation.FrenzyDig.Pitch"));
                        }
                        calendar = Calendar.getInstance();
                        calendar.add(13, frenzyDigEvent.getCooldown());
                        mcRPGPlayer.getActiveAbilities().remove(UnlockedAbilities.FRENZY_DIG);
                        mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.FRENZY_DIG, calendar.getTimeInMillis());
                    }
                }.runTaskLater((Plugin)McRPG.getInstance(), (long)(frenzyDigEvent.getHasteDuration() * 20));
                return;
            }
            if (unlockedAbilities.equals(UnlockedAbilities.HAND_DIGGING) && (playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK || playerInteractEvent.getAction() == Action.LEFT_CLICK_AIR)) {
                HandDigging handDigging = (HandDigging)baseAbility;
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.EXCAVATION_CONFIG);
                if (playerInteractEvent.getClickedBlock() == null || playerInteractEvent.getClickedBlock().getType() == null) {
                    return;
                }
                if (BreakEvent.canLargerSpade(playerInteractEvent.getClickedBlock().getType())) {
                    int n = fileConfiguration.getInt("HandDiggingConfig.Tier" + Methods.convertToNumeral(handDigging.getCurrentTier()) + ".Duration");
                    int n5 = fileConfiguration.getInt("HandDiggingConfig.Tier" + Methods.convertToNumeral(handDigging.getCurrentTier()) + ".Cooldown");
                    final HandDiggingEvent handDiggingEvent = new HandDiggingEvent(mcRPGPlayer, handDigging, n, n5, BreakEvent.getExcavationBlocks());
                    Bukkit.getPluginManager().callEvent((Event)handDiggingEvent);
                    if (!handDiggingEvent.isCancelled()) {
                        mcRPGPlayer.getPlayer().sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.HandDigging.Activated")));
                        Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                        mcRPGPlayer.setReadyingAbilityBit(null);
                        mcRPGPlayer.setReadying(false);
                        mcRPGPlayer.setHandDigging(true);
                        mcRPGPlayer.setHandDiggingBlocks(handDiggingEvent.getBreakableBlocks());
                        mcRPGPlayer.getActiveAbilities().add(UnlockedAbilities.HAND_DIGGING);
                        new BukkitRunnable(){

                            public void run() {
                                mcRPGPlayer.setHandDigging(false);
                                mcRPGPlayer.getPlayer().sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.HandDigging.Deactivated")));
                                Calendar calendar = Calendar.getInstance();
                                calendar.add(13, handDiggingEvent.getCooldown());
                                mcRPGPlayer.getActiveAbilities().remove(UnlockedAbilities.HAND_DIGGING);
                                mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.HAND_DIGGING, calendar.getTimeInMillis());
                            }
                        }.runTaskLater((Plugin)McRPG.getInstance(), (long)(handDiggingEvent.getDuration() * 20));
                    }
                }
            } else if (unlockedAbilities == UnlockedAbilities.ORE_SCANNER && (playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK || playerInteractEvent.getAction() == Action.LEFT_CLICK_AIR)) {
                OreScanner oreScanner = (OreScanner)baseAbility;
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.MINING_CONFIG);
                playerInteractEvent.setCancelled(true);
                int n = fileConfiguration.getInt("OreScannerConfig.Tier" + Methods.convertToNumeral(oreScanner.getCurrentTier()) + ".Radius");
                int n6 = fileConfiguration.getInt("OreScannerConfig.Tier" + Methods.convertToNumeral(oreScanner.getCurrentTier()) + ".Cooldown");
                OreScannerEvent oreScannerEvent = new OreScannerEvent(mcRPGPlayer, oreScanner, n6);
                Bukkit.getPluginManager().callEvent((Event)oreScannerEvent);
                if (oreScannerEvent.isCancelled()) {
                    return;
                }
                Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                mcRPGPlayer.setReadyingAbilityBit(null);
                mcRPGPlayer.setReadying(false);
                Calendar calendar = Calendar.getInstance();
                calendar.add(13, oreScannerEvent.getCooldown());
                mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.ORE_SCANNER, calendar.getTimeInMillis());
                Location location = null;
                Location location2 = null;
                Location location3 = null;
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (int i = -1 * n; i < n; ++i) {
                    for (int j = -1 * n; j < n; ++j) {
                        for (int k = -1 * n; k < n; ++k) {
                            Block block3 = player.getLocation().add((double)i, (double)k, (double)j).getBlock();
                            Material material3 = block3.getType();
                            if (material3 == Material.GOLD_ORE) {
                                if (location == null) {
                                    location = block3.getLocation();
                                } else if (player.getLocation().distance(location) > player.getLocation().distance(block3.getLocation())) {
                                    location = block3.getLocation();
                                }
                                ++n7;
                                continue;
                            }
                            if (material3 == Material.EMERALD_ORE) {
                                if (location2 == null) {
                                    location2 = block3.getLocation();
                                } else if (player.getLocation().distance(location2) > player.getLocation().distance(block3.getLocation())) {
                                    location2 = block3.getLocation();
                                }
                                ++n8;
                                continue;
                            }
                            if (material3 != Material.DIAMOND_ORE) continue;
                            if (location3 == null) {
                                location3 = block3.getLocation();
                            } else if (player.getLocation().distance(location3) > player.getLocation().distance(block3.getLocation())) {
                                location3 = block3.getLocation();
                            }
                            ++n9;
                        }
                    }
                }
                if (location3 == null && location == null && location2 == null) {
                    player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.OreScanner.NothingFound")));
                    return;
                }
                player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.OreScanner.PointingToValuable")));
                Location location4 = null;
                if (location != null) {
                    location4 = location;
                    player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.OreScanner.GoldFound").replace("%Amount%", Integer.toString(n7))));
                }
                if (location2 != null) {
                    location4 = location2;
                    player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.OreScanner.EmeraldsFound").replace("%Amount%", Integer.toString(n8))));
                }
                if (location3 != null) {
                    location4 = location3;
                    player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.OreScanner.DiamondsFound").replace("%Amount%", Integer.toString(n9))));
                }
                player.teleport(Methods.lookAt(player.getLocation(), location4));
            } else if (unlockedAbilities == UnlockedAbilities.MASS_HARVEST && playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (ItemUtils.isCrop(material)) {
                    FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.HERBALISM_CONFIG);
                    MassHarvest massHarvest = (MassHarvest)mcRPGPlayer.getBaseAbility(UnlockedAbilities.MASS_HARVEST);
                    int n = fileConfiguration.getInt("MassHarvestConfig.Tier" + Methods.convertToNumeral(massHarvest.getCurrentTier()) + ".Range");
                    ItemStack itemStack3 = player.getItemInHand().clone();
                    MassHarvestEvent massHarvestEvent = new MassHarvestEvent(mcRPGPlayer, massHarvest, n);
                    Bukkit.getPluginManager().callEvent((Event)massHarvestEvent);
                    if (!massHarvestEvent.isCancelled()) {
                        mcRPGPlayer.getActiveAbilities().add(UnlockedAbilities.MASS_HARVEST);
                        Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                        mcRPGPlayer.setReadyingAbilityBit(null);
                        mcRPGPlayer.setReadying(false);
                        playerInteractEvent.setCancelled(true);
                        int n10 = fileConfiguration.getInt("MassHarvestConfig.Tier" + Methods.convertToNumeral(massHarvest.getCurrentTier()) + ".Cooldown");
                        for (int i = -1 * n; i < n; ++i) {
                            block10: for (int j = -1 * n; j < n; ++j) {
                                for (int k = -2; k < 2; ++k) {
                                    Block block4 = player.getLocation().add((double)i, (double)k, (double)j).getBlock();
                                    Material material4 = block4.getType();
                                    if (!ItemUtils.isCrop(material4)) continue;
                                    BlockBreakEvent blockBreakEvent = new BlockBreakEvent(block4, player);
                                    Bukkit.getPluginManager().callEvent((Event)blockBreakEvent);
                                    if (blockBreakEvent.isCancelled()) continue;
                                    block4.breakNaturally(itemStack3);
                                    if (material == Material.PUMPKIN || material == Material.MELON) continue block10;
                                    block4.setType(material4);
                                    Ageable ageable = (Ageable)block4.getBlockData();
                                    ageable.setAge(0);
                                    block4.setBlockData((BlockData)ageable);
                                }
                            }
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(13, n10);
                        player.sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.MassHarvest.Activated")));
                        mcRPGPlayer.getActiveAbilities().remove(UnlockedAbilities.MASS_HARVEST);
                        mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.MASS_HARVEST, calendar.getTimeInMillis());
                    }
                }
            } else if (unlockedAbilities == UnlockedAbilities.PANS_BLESSING && playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK && itemStack.getType() == Material.BONE_MEAL) {
                if (!ItemUtils.isCrop(material)) {
                    return;
                }
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.HERBALISM_CONFIG);
                PansBlessing pansBlessing = (PansBlessing)mcRPGPlayer.getBaseAbility(UnlockedAbilities.PANS_BLESSING);
                int n = fileConfiguration.getInt("PansBlessingConfig.Tier" + Methods.convertToNumeral(pansBlessing.getCurrentTier()) + ".Radius");
                PansBlessingEvent pansBlessingEvent = new PansBlessingEvent(mcRPGPlayer, pansBlessing, n);
                Bukkit.getPluginManager().callEvent((Event)pansBlessingEvent);
                if (!pansBlessingEvent.isCancelled()) {
                    mcRPGPlayer.setReadying(false);
                    Bukkit.getScheduler().cancelTask(mcRPGPlayer.getReadyingAbilityBit().getEndTaskID());
                    mcRPGPlayer.setReadyingAbilityBit(null);
                    mcRPGPlayer.getActiveAbilities().add(UnlockedAbilities.PANS_BLESSING);
                    int n11 = fileConfiguration.getInt("PansBlessingConfig.Tier" + Methods.convertToNumeral(pansBlessing.getCurrentTier()) + ".Cooldown");
                    for (int i = -1 * n; i <= n; ++i) {
                        for (int j = -1 * n; j <= n; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                Block block5 = playerInteractEvent.getClickedBlock().getLocation().add((double)i, (double)k, (double)j).getBlock();
                                Material material5 = block5.getType();
                                if (!ItemUtils.isCrop(material5)) continue;
                                Ageable ageable = (Ageable)block5.getBlockData();
                                int n12 = ageable.getMaximumAge();
                                ageable.setAge(ageable.getMaximumAge());
                                BlockGrowEvent blockGrowEvent = new BlockGrowEvent(block5, block5.getState());
                                if (blockGrowEvent.isCancelled()) continue;
                                block5.setBlockData((BlockData)ageable);
                                block5.getLocation().getWorld().spawnParticle(Particle.VILLAGER_HAPPY, block5.getLocation(), 5);
                            }
                        }
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(13, n11);
                    player.sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.PansBlessing.Activated")));
                    mcRPGPlayer.getActiveAbilities().remove(UnlockedAbilities.PANS_BLESSING);
                    mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.PANS_BLESSING, calendar.getTimeInMillis());
                }
            }
        }
    }
}

