/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.events.vanilla;

import java.util.Calendar;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.axes.BloodFrenzy;
import us.eunoians.mcrpg.abilities.fitness.DivineEscape;
import us.eunoians.mcrpg.api.events.mcrpg.axes.BloodFrenzyEvent;
import us.eunoians.mcrpg.api.events.mcrpg.fitness.DivineEscapeEvent;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.api.util.books.BookManager;
import us.eunoians.mcrpg.api.util.books.SkillBookFactory;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.UnlockedAbilities;
import us.eunoians.mcrpg.util.mcmmo.MobHealthbarUtils;

public class DeathEvent
implements Listener {
    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDeathHighest(EntityDamageEvent entityDamageEvent) {
        Player player;
        if (PlayerManager.isPlayerFrozen(entityDamageEvent.getEntity().getUniqueId())) {
            return;
        }
        if (McRPG.getInstance().getConfig().contains("Configuration.DisabledWorlds") && McRPG.getInstance().getConfig().getStringList("Configuration.DisabledWorlds").contains(entityDamageEvent.getEntity().getWorld().getName())) {
            return;
        }
        if (entityDamageEvent.getEntity() instanceof Player && (player = (Player)entityDamageEvent.getEntity()).getHealth() - entityDamageEvent.getDamage() <= 0.0 && player.getBedSpawnLocation() != null) {
            McRPGPlayer mcRPGPlayer;
            try {
                mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
            }
            catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                return;
            }
            if (UnlockedAbilities.DIVINE_ESCAPE.isEnabled() && mcRPGPlayer.getAbilityLoadout().contains(UnlockedAbilities.DIVINE_ESCAPE) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.DIVINE_ESCAPE).isToggled()) {
                if (mcRPGPlayer.getCooldown(UnlockedAbilities.DIVINE_ESCAPE) > -1L) {
                    return;
                }
                FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.FITNESS_CONFIG);
                DivineEscape divineEscape = (DivineEscape)mcRPGPlayer.getBaseAbility(UnlockedAbilities.DIVINE_ESCAPE);
                String string = "DivineEscapeConfig.Tier" + Methods.convertToNumeral(divineEscape.getCurrentTier()) + ".";
                double d = fileConfiguration.getDouble(string + "McRPGExpPenalty");
                int n = fileConfiguration.getInt(string + "McRPGExpPenaltyDuration");
                double d2 = fileConfiguration.getDouble(string + "DamagePenalty");
                int n2 = fileConfiguration.getInt(string + "DamagePenaltyDuration");
                int n3 = fileConfiguration.getInt(string + "Cooldown");
                DivineEscapeEvent divineEscapeEvent = new DivineEscapeEvent(mcRPGPlayer, divineEscape, d, d2);
                Bukkit.getPluginManager().callEvent((Event)divineEscapeEvent);
                if (!divineEscapeEvent.isCancelled()) {
                    entityDamageEvent.setCancelled(true);
                    player.setHealth(player.getMaxHealth());
                    new BukkitRunnable(){

                        public void run() {
                            if (player.isOnline() && player.getBedLocation() != null) {
                                player.teleport(player.getBedSpawnLocation());
                            }
                        }
                    }.runTaskLater((Plugin)McRPG.getInstance(), 1L);
                    player.sendMessage(Methods.color(player, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.DivineEscape.Activated")).replace("%Exp_Debuff%", Double.toString(d)).replace("%Damage_Debuff%", Double.toString(d2)));
                    mcRPGPlayer.setDivineEscapeDamageDebuff(divineEscapeEvent.getDamageIncreaseDebuff());
                    mcRPGPlayer.setDivineEscapeExpDebuff(divineEscapeEvent.getExpDebuff());
                    Calendar calendar = Calendar.getInstance();
                    calendar.add(13, n3);
                    mcRPGPlayer.addAbilityOnCooldown(UnlockedAbilities.DIVINE_ESCAPE, calendar.getTimeInMillis());
                    calendar = Calendar.getInstance();
                    calendar.add(13, n);
                    mcRPGPlayer.setDivineEscapeExpEnd(calendar.getTimeInMillis());
                    calendar = Calendar.getInstance();
                    calendar.add(13, n2);
                    mcRPGPlayer.setDivineEscapeDamageEnd(calendar.getTimeInMillis());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDeathMonitor(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getEntity() instanceof LivingEntity && !(entityDamageByEntityEvent.getEntity() instanceof ArmorStand) && ((LivingEntity)entityDamageByEntityEvent.getEntity()).getHealth() - entityDamageByEntityEvent.getDamage() <= 0.0) {
            double d;
            LivingEntity livingEntity = (LivingEntity)entityDamageByEntityEvent.getEntity();
            BookManager bookManager = McRPG.getInstance().getBookManager();
            Random random = new Random();
            int n = McRPG.getInstance().getFileManager().getFile(FileManager.Files.CONFIG).getBoolean("Configuration.DisableBooksInEnd", false) && entityDamageByEntityEvent.getDamager().getLocation().getBlock().getBiome().name().contains("END") ? 100001 : random.nextInt(100000);
            Location location = entityDamageByEntityEvent.getDamager().getLocation();
            EntityType entityType = livingEntity.getType();
            if (livingEntity.hasMetadata("ExpModifier")) {
                if (bookManager.getEnabledUnlockEvents().contains("KillSpawned") && !bookManager.getUnlockExcluded().contains(entityType.name())) {
                    d = bookManager.getDefaultUnlockChance();
                    if (bookManager.getEntityChances().containsKey("Unlock") && bookManager.getEntityChances().get("Unlock").containsKey(entityType)) {
                        d = bookManager.getEntityChances().get("Unlock").get(entityType);
                    }
                    if ((d *= 1000.0) >= (double)n) {
                        location.getWorld().dropItemNaturally(location, SkillBookFactory.generateUnlockBook());
                    }
                }
                if (bookManager.getEnabledUpgradeEvents().contains("KillSpawned") && !bookManager.getUpgradeExcluded().contains(entityType.name())) {
                    d = bookManager.getDefaultUpgradeChance();
                    if (bookManager.getEntityChances().containsKey("Upgrade") && bookManager.getEntityChances().get("Upgrade").containsKey(entityType)) {
                        d = bookManager.getEntityChances().get("Upgrade").get(entityType);
                    }
                    if ((d *= 1000.0) >= (double)n) {
                        location.getWorld().dropItemNaturally(location, SkillBookFactory.generateUpgradeBook());
                    }
                }
            } else {
                if (bookManager.getEnabledUnlockEvents().contains("KillNatural") && !bookManager.getUnlockExcluded().contains(entityType.name())) {
                    d = bookManager.getDefaultUnlockChance();
                    if (bookManager.getEntityChances().containsKey("Unlock") && bookManager.getEntityChances().get("Unlock").containsKey(entityType)) {
                        d = bookManager.getEntityChances().get("Unlock").get(entityType);
                    }
                    if ((d *= 1000.0) >= (double)n) {
                        location.getWorld().dropItemNaturally(location, SkillBookFactory.generateUnlockBook());
                    }
                }
                if (bookManager.getEnabledUpgradeEvents().contains("KillNatural") && !bookManager.getUpgradeExcluded().contains(entityType.name())) {
                    d = bookManager.getDefaultUpgradeChance();
                    if (bookManager.getEntityChances().containsKey("Upgrade") && bookManager.getEntityChances().get("Upgrade").containsKey(entityType)) {
                        d = bookManager.getEntityChances().get("Upgrade").get(entityType);
                    }
                    if ((d *= 1000.0) >= (double)n) {
                        location.getWorld().dropItemNaturally(location, SkillBookFactory.generateUpgradeBook());
                    }
                }
            }
            if (entityDamageByEntityEvent.getDamager() instanceof Player) {
                McRPGPlayer mcRPGPlayer;
                try {
                    mcRPGPlayer = PlayerManager.getPlayer(entityDamageByEntityEvent.getDamager().getUniqueId());
                }
                catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                    return;
                }
                if (UnlockedAbilities.BLOOD_FRENZY.isEnabled() && mcRPGPlayer.getAbilityLoadout().contains(UnlockedAbilities.BLOOD_FRENZY) && mcRPGPlayer.getBaseAbility(UnlockedAbilities.BLOOD_FRENZY).isToggled()) {
                    BloodFrenzy bloodFrenzy = (BloodFrenzy)mcRPGPlayer.getBaseAbility(UnlockedAbilities.BLOOD_FRENZY);
                    FileConfiguration fileConfiguration = McRPG.getInstance().getFileManager().getFile(FileManager.Files.AXES_CONFIG);
                    boolean bl = fileConfiguration.getBoolean("BloodFrenzyConfig.ActiveOnMobs");
                    if (livingEntity instanceof Player || bl) {
                        String string = "BloodFrenzyConfig.Tier" + Methods.convertToNumeral(bloodFrenzy.getCurrentTier()) + ".";
                        int n2 = fileConfiguration.getInt(string + "HasteLevel") - 1;
                        int n3 = fileConfiguration.getInt(string + "HasteDuration");
                        int n4 = fileConfiguration.getInt(string + "RegenerationLevel") - 1;
                        int n5 = fileConfiguration.getInt(string + "RegenerationDuration");
                        BloodFrenzyEvent bloodFrenzyEvent = new BloodFrenzyEvent(mcRPGPlayer, bloodFrenzy, n3, n2, n5, n4, livingEntity);
                        Bukkit.getPluginManager().callEvent((Event)bloodFrenzyEvent);
                        if (!bloodFrenzyEvent.isCancelled()) {
                            PotionEffect potionEffect;
                            Player player = mcRPGPlayer.getPlayer();
                            if (player.hasPotionEffect(PotionEffectType.FAST_DIGGING)) {
                                potionEffect = player.getPotionEffect(PotionEffectType.FAST_DIGGING);
                                if (potionEffect.getDuration() < bloodFrenzyEvent.getHasteDuration() * 20 && potionEffect.getAmplifier() <= bloodFrenzyEvent.getHasteLevel()) {
                                    player.removePotionEffect(PotionEffectType.FAST_DIGGING);
                                    player.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, bloodFrenzyEvent.getHasteDuration() * 20, bloodFrenzyEvent.getHasteLevel()));
                                }
                            } else {
                                player.addPotionEffect(new PotionEffect(PotionEffectType.FAST_DIGGING, bloodFrenzyEvent.getHasteDuration() * 20, bloodFrenzyEvent.getHasteLevel()));
                            }
                            if (player.hasPotionEffect(PotionEffectType.REGENERATION)) {
                                potionEffect = player.getPotionEffect(PotionEffectType.REGENERATION);
                                if (potionEffect.getDuration() < bloodFrenzyEvent.getRegenDuration() * 20 && potionEffect.getAmplifier() <= bloodFrenzyEvent.getRegenLevel()) {
                                    player.removePotionEffect(PotionEffectType.REGENERATION);
                                    player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, bloodFrenzyEvent.getRegenDuration() * 20, bloodFrenzyEvent.getRegenLevel()));
                                }
                            } else {
                                player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, bloodFrenzyEvent.getRegenDuration() * 20, bloodFrenzyEvent.getRegenLevel()));
                            }
                        }
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDeathLowest(PlayerDeathEvent playerDeathEvent) {
        String string = playerDeathEvent.getDeathMessage();
        if (string == null) {
            return;
        }
        Player player = playerDeathEvent.getEntity();
        playerDeathEvent.setDeathMessage(MobHealthbarUtils.fixDeathMessage(string, player));
    }
}

