/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.events.vanilla;

import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.util.mcmmo.BlockUtils;

public class BlockListener
implements Listener {
    private final McRPG plugin;

    public BlockListener(McRPG mcRPG) {
        this.plugin = mcRPG;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFallingBlock(EntityChangeBlockEvent entityChangeBlockEvent) {
        if (entityChangeBlockEvent.getEntityType().equals((Object)EntityType.FALLING_BLOCK)) {
            if (entityChangeBlockEvent.getTo().equals((Object)Material.AIR) && McRPG.getPlaceStore().isTrue(entityChangeBlockEvent.getBlock())) {
                entityChangeBlockEvent.getEntity().setMetadata("mcMMOBlockFall", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)entityChangeBlockEvent.getBlock().getLocation()));
            } else {
                List list = entityChangeBlockEvent.getEntity().getMetadata("mcMMOBlockFall");
                if (!list.isEmpty()) {
                    if (((MetadataValue)list.get(0)).value() == null) {
                        return;
                    }
                    Block block = ((Location)((MetadataValue)list.get(0)).value()).getBlock();
                    McRPG.getPlaceStore().setTrue(entityChangeBlockEvent.getBlock());
                    McRPG.getPlaceStore().setFalse(block);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent blockPlaceEvent) {
        Player player = blockPlaceEvent.getPlayer();
        if (!PlayerManager.isPlayerStored(blockPlaceEvent.getPlayer().getUniqueId())) {
            return;
        }
        BlockState blockState = blockPlaceEvent.getBlock().getState();
        if (blockState.getType() != Material.CHORUS_FLOWER) {
            McRPG.getPlaceStore().setTrue(blockState);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent blockGrowEvent) {
        BlockState blockState = blockGrowEvent.getBlock().getState();
        McRPG.getPlaceStore().setFalse(blockState);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent blockBreakEvent) {
        BlockState blockState = blockBreakEvent.getBlock().getState();
        Location location = blockState.getLocation();
        Block block = blockBreakEvent.getBlock();
        Player player = blockBreakEvent.getPlayer();
        if (!PlayerManager.isPlayerStored(player.getUniqueId()) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        McRPG.getPlaceStore().setFalse(blockState);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockDamage(BlockDamageEvent blockDamageEvent) {
        Player player = blockDamageEvent.getPlayer();
        if (!PlayerManager.isPlayerStored(player.getUniqueId())) {
            return;
        }
        BlockState blockState = blockDamageEvent.getBlock().getState();
        if (BlockUtils.canActivateAbilities(blockState)) {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
        }
    }
}

