/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.events.mcrpg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.abilities.swords.Bleed;
import us.eunoians.mcrpg.api.events.mcrpg.swords.BleedEvent;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;

public class BleedHandler
implements Listener {
    private static HashMap<UUID, BukkitTask> targetsBleedTasks = new HashMap();
    private static HashMap<UUID, ArrayList<UUID>> playersTargeted = new HashMap();

    public static void cancelTarget(UUID uUID) {
        if (targetsBleedTasks.containsKey(uUID)) {
            targetsBleedTasks.get(uUID).cancel();
            targetsBleedTasks.remove(uUID);
            return;
        }
    }

    public static boolean isTargeted(UUID uUID) {
        return targetsBleedTasks.containsKey(uUID);
    }

    public static ArrayList<UUID> getPlayersTargetedBy(UUID uUID) {
        if (playersTargeted.containsKey(uUID)) {
            return playersTargeted.get(uUID);
        }
        return new ArrayList<UUID>();
    }

    public static void setPlayersTargetedBy(UUID uUID, ArrayList<UUID> arrayList) {
        playersTargeted.put(uUID, arrayList);
    }

    public static void addPlayerTargetedBy(UUID uUID, UUID uUID2) {
        if (playersTargeted.containsKey(uUID)) {
            playersTargeted.get(uUID).add(uUID2);
        } else {
            ArrayList<UUID> arrayList = new ArrayList<UUID>();
            arrayList.add(uUID2);
            playersTargeted.put(uUID, arrayList);
        }
    }

    public static void removePlayerTargeted(UUID uUID, UUID uUID2) {
        playersTargeted.get(uUID).remove(uUID2);
        if (playersTargeted.get(uUID).isEmpty()) {
            playersTargeted.remove(uUID);
        }
    }

    private static void startBleedImmunityTimer(final McRPGPlayer mcRPGPlayer, int n) {
        if (!mcRPGPlayer.isOnline()) {
            return;
        }
        mcRPGPlayer.setHasBleedImmunity(true);
        new BukkitRunnable(){

            public void run() {
                if (mcRPGPlayer.isOnline()) {
                    mcRPGPlayer.setHasBleedImmunity(false);
                }
            }
        }.runTaskLater((Plugin)McRPG.getInstance(), (long)(n * 20));
    }

    @EventHandler(priority=EventPriority.LOW)
    public void bleed(BleedEvent bleedEvent) {
        Entity entity = bleedEvent.getTarget();
        McRPGPlayer mcRPGPlayer = bleedEvent.getMcRPGPlayer();
        Bleed bleed = bleedEvent.getBleed();
        if (BleedHandler.isTargeted(entity.getUniqueId())) {
            bleedEvent.setCancelled(true);
            return;
        }
        if (entity instanceof Player) {
            McRPGPlayer mcRPGPlayer2;
            try {
                mcRPGPlayer2 = PlayerManager.getPlayer(bleedEvent.getTarget().getUniqueId());
            }
            catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                bleedEvent.setCancelled(true);
                return;
            }
            if (!bleed.canTarget()) {
                bleedEvent.setCancelled(true);
                return;
            }
            if (bleedEvent.isBleedImmunityEnabled() && mcRPGPlayer2.isHasBleedImmunity()) {
                bleedEvent.setCancelled(true);
                return;
            }
            BleedHandler.addPlayerTargetedBy(mcRPGPlayer.getUuid(), mcRPGPlayer2.getUuid());
            mcRPGPlayer2.getPlayer().sendMessage(Methods.color(mcRPGPlayer.getPlayer(), McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.Bleed.PlayerBleeding")));
        }
        this.startBleedTimer(bleedEvent);
    }

    private void startBleedTimer(final BleedEvent bleedEvent) {
        final AtomicInteger atomicInteger = new AtomicInteger(bleedEvent.getBaseDuration() / bleedEvent.getFrequency());
        BukkitTask bukkitTask = new BukkitRunnable(){

            public void run() {
                Entity entity = bleedEvent.getTarget();
                if (atomicInteger.get() == 0 || entity.isDead() || entity instanceof Player && !((Player)entity).isOnline()) {
                    if (entity instanceof Player && ((Player)entity).isOnline()) {
                        McRPGPlayer mcRPGPlayer;
                        entity.sendMessage(Methods.color((Player)entity, McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Abilities.Bleed.BleedingStopped")));
                        try {
                            mcRPGPlayer = PlayerManager.getPlayer(bleedEvent.getTarget().getUniqueId());
                        }
                        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
                            bleedEvent.setCancelled(true);
                            return;
                        }
                        if (bleedEvent.isBleedImmunityEnabled()) {
                            BleedHandler.startBleedImmunityTimer(mcRPGPlayer, bleedEvent.getBleedImmunityDuration());
                        }
                    }
                    BleedHandler.cancelTarget(entity.getUniqueId());
                    if (entity instanceof Player) {
                        BleedHandler.removePlayerTargeted(bleedEvent.getMcRPGPlayer().getUuid(), entity.getUniqueId());
                    }
                } else {
                    atomicInteger.decrementAndGet();
                    LivingEntity livingEntity = (LivingEntity)entity;
                    entity.getWorld().playEffect(livingEntity.getEyeLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_WIRE);
                    if (livingEntity.getHealth() > (double)bleedEvent.getMinimumHealthAllowed()) {
                        livingEntity.damage((double)bleedEvent.getDamage());
                    }
                }
            }
        }.runTaskTimer((Plugin)McRPG.getInstance(), 10L, (long)(bleedEvent.getFrequency() * 20));
        targetsBleedTasks.put(bleedEvent.getTarget().getUniqueId(), bukkitTask);
    }
}

