/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.database.tables;

import com.cyr1en.flatdb.annotations.Column;
import com.cyr1en.flatdb.annotations.Table;
import java.security.ProtectionDomain;
import javassist.ClassPool;
import javassist.LoaderClassPath;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.database.tables.Loadout;

public class LoadoutInstrumentation {
    private ClassPool classPool;
    private ClassLoader cl;
    private ProtectionDomain pd;
    private int loadOutSize;

    public LoadoutInstrumentation(McRPG mcRPG, int n) {
        this.loadOutSize = n;
        this.classPool = ClassPool.getDefault();
        this.cl = ((Object)((Object)mcRPG)).getClass().getClassLoader();
        this.pd = ((Object)((Object)mcRPG)).getClass().getProtectionDomain();
        this.classPool.appendClassPath(new LoaderClassPath(this.cl));
        this.classPool.appendClassPath(new LoaderClassPath(Table.class.getClassLoader()));
        this.classPool.appendClassPath(new LoaderClassPath(Column.class.getClassLoader()));
    }

    private ClassFile addFields() {
        ClassFile classFile = this.classPool.get(Loadout.class.getName()).getClassFile();
        AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(classFile.getConstPool(), "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation("com.cyr1en.flatdb.annotations.Column", classFile.getConstPool());
        annotationsAttribute.addAnnotation(annotation);
        for (int i = 1; i <= this.loadOutSize; ++i) {
            FieldInfo fieldInfo = new FieldInfo(classFile.getConstPool(), "slot" + i, "Ljava/lang/String;");
            fieldInfo.setAccessFlags(1);
            fieldInfo.addAttribute(annotationsAttribute);
            classFile.addField(fieldInfo);
        }
        return classFile;
    }

    public Class<?> instrument() {
        try {
            ClassFile classFile = this.addFields();
            classFile.setName("ILoadoutTable");
            return this.classPool.makeClass(classFile).toClass(this.cl, this.pd);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

