/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.database;

import com.cyr1en.flatdb.Database;
import com.cyr1en.flatdb.DatabaseBuilder;
import com.cyr1en.flatdb.util.FastStrings;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.api.util.Methods;
import us.eunoians.mcrpg.database.tables.LoadoutInstrumentation;
import us.eunoians.mcrpg.database.tables.PlayerData;
import us.eunoians.mcrpg.database.tables.PlayerSetting;
import us.eunoians.mcrpg.database.tables.skills.ArcheryTable;
import us.eunoians.mcrpg.database.tables.skills.AxesTable;
import us.eunoians.mcrpg.database.tables.skills.ExcavationTable;
import us.eunoians.mcrpg.database.tables.skills.FishingTable;
import us.eunoians.mcrpg.database.tables.skills.FitnessTable;
import us.eunoians.mcrpg.database.tables.skills.HerbalismTable;
import us.eunoians.mcrpg.database.tables.skills.MiningTable;
import us.eunoians.mcrpg.database.tables.skills.SorceryTable;
import us.eunoians.mcrpg.database.tables.skills.SwordsTable;
import us.eunoians.mcrpg.database.tables.skills.UnarmedTable;
import us.eunoians.mcrpg.database.tables.skills.WoodcuttingTable;

public class McRPGDb {
    private McRPG instance;
    private Database database;

    public McRPGDb(McRPG mcRPG) {
        this.instance = mcRPG;
        Class<?> clazz = new LoadoutInstrumentation(this.instance, mcRPG.getFileManager().getFile(FileManager.Files.CONFIG).getInt("PlayerConfiguration.AmountOfTotalAbilities")).instrument();
        DatabaseBuilder databaseBuilder = new DatabaseBuilder();
        databaseBuilder.setDatabasePrefix("mcrpg_");
        databaseBuilder.setPath(mcRPG.getDataFolder().getAbsolutePath() + "/database/mcrpg");
        databaseBuilder.appendTable(new Class[]{PlayerData.class});
        databaseBuilder.appendTable(new Class[]{PlayerSetting.class});
        databaseBuilder.appendTable(new Class[]{ArcheryTable.class});
        databaseBuilder.appendTable(new Class[]{HerbalismTable.class});
        databaseBuilder.appendTable(new Class[]{WoodcuttingTable.class});
        databaseBuilder.appendTable(new Class[]{MiningTable.class});
        databaseBuilder.appendTable(new Class[]{SwordsTable.class});
        databaseBuilder.appendTable(new Class[]{UnarmedTable.class});
        databaseBuilder.appendTable(new Class[]{FitnessTable.class});
        databaseBuilder.appendTable(new Class[]{ExcavationTable.class});
        databaseBuilder.appendTable(new Class[]{AxesTable.class});
        databaseBuilder.appendTable(new Class[]{FishingTable.class});
        databaseBuilder.appendTable(new Class[]{SorceryTable.class});
        databaseBuilder.appendTable(new Class[]{clazz});
        try {
            this.database = databaseBuilder.build();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void listAllTable() {
        try {
            DatabaseMetaData databaseMetaData = this.database.getMetaData().orElse(null);
            if (databaseMetaData == null) {
                return;
            }
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                Bukkit.getLogger().info(resultSet.getString("TABLE_NAME"));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void convertLegacyToFlatDB() {
        File file = new File(this.instance.getDataFolder(), File.separator + "PlayerData");
        if (!file.exists()) {
            Bukkit.getConsoleSender().sendMessage(Methods.color(this.instance.getPluginPrefix() + this.instance.getLangFile().getString("Messages.Utility.PlayerFolderDoesntExist")));
            return;
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        Instant instant = Instant.now();
        if (fileArray != null) {
            Bukkit.getConsoleSender().sendMessage(Methods.color(this.instance.getPluginPrefix() + this.instance.getLangFile().getString("Messages.Commands.Utility.BeginningConversion").replace("%FileAmount%", Integer.toString(fileArray.length))));
            LegacyDataConverter legacyDataConverter = new LegacyDataConverter();
            for (File file2 : fileArray) {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
                UUID uUID = UUID.fromString(file2.getName().replace(".yml", ""));
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                builder.put((Object)"uuid", (Object)uUID.toString());
                builder.put((Object)"ability_points", (Object)Integer.toString(yamlConfiguration.getInt("AbilityPoints")));
                builder.put((Object)"redeemable_exp", (Object)Integer.toString(yamlConfiguration.getInt("RedeemableExp")));
                builder.put((Object)"redeemable_levels", (Object)Integer.toString(yamlConfiguration.getInt("RedeemableLevels")));
                legacyDataConverter.convert("mcrpg_player_data", (Map<String, String>)builder.build());
                builder = new ImmutableMap.Builder();
                builder.put((Object)"uuid", (Object)uUID.toString());
                builder.put((Object)"keep_hand", (Object)String.valueOf(yamlConfiguration.getBoolean("KeepHandEmpty")));
                builder.put((Object)"ignore_tips", (Object)String.valueOf(yamlConfiguration.getBoolean("IgnoreTips")));
                builder.put((Object)"auto_deny", (Object)String.valueOf(yamlConfiguration.getBoolean("AutoDeny")));
                builder.put((Object)"display_type", (Object)yamlConfiguration.getString("DisplayType"));
                builder.put((Object)"health_type", (Object)yamlConfiguration.getString("HealthType"));
                legacyDataConverter.convert("mcrpg_player_settings", (Map<String, String>)builder.build());
                List list = yamlConfiguration.getStringList("AbilityLoadout");
                builder = new ImmutableMap.Builder();
                for (int i = 1; i <= list.size(); ++i) {
                    builder.put((Object)("slot" + i), list.get(i - 1));
                }
                legacyDataConverter.convert("mcrpg_loadout", (Map<String, String>)builder.build());
                Integer n2 = yamlConfiguration.getInt("Swords.CurrentExp");
                Integer n3 = yamlConfiguration.getInt("Swords.current_level");
                Boolean bl = yamlConfiguration.getBoolean("Swords.Bleed.IsToggled");
                Boolean bl2 = yamlConfiguration.getBoolean("Swords.Bleed+.IsToggled");
                Boolean bl3 = yamlConfiguration.getBoolean("Swords.DeeperWound.IsToggled");
                Boolean bl4 = yamlConfiguration.getBoolean("Swords.Vampire.IsToggled");
                Boolean bl5 = yamlConfiguration.getBoolean("Swords.RageSpike.IsToggled");
                Boolean bl6 = yamlConfiguration.getBoolean("Swords.SerratedStrikes.IsToggled");
                Boolean bl7 = yamlConfiguration.getBoolean("Swords.TaintedBlade.IsToggled");
                Integer n4 = yamlConfiguration.getInt("Swords.Bleed+.Tier");
                Integer n5 = yamlConfiguration.getInt("Swords.DeeperWound.Tier");
                Integer n6 = yamlConfiguration.getInt("Swords.Vampire.Tier");
                Integer n7 = yamlConfiguration.getInt("Swords.RageSpike.Tier");
                Integer n8 = yamlConfiguration.getInt("Swords.SerratedStrikes.Tier");
                Integer n9 = yamlConfiguration.getInt("Swords.TaintedBlade.Tier");
                Long l = 0L;
                if (yamlConfiguration.contains("Cooldowns.RageSpike")) {
                    l = yamlConfiguration.getLong("Cooldowns.RageSpike");
                }
                Long l2 = 0L;
                if (yamlConfiguration.contains("Cooldowns.SerratedStrikes")) {
                    l2 = yamlConfiguration.getLong("Cooldowns.SerratedStrikes");
                }
                Long l3 = 0L;
                if (yamlConfiguration.contains("Cooldowns.TaintedBlade")) {
                    l3 = yamlConfiguration.getLong("Cooldowns.TaintedBlade");
                }
                String string = "INSERT INTO mcrpg_swords_data (uuid, current_exp, current_level, is_bleed_toggled, is_bleed_plus_toggled, is_deeper_wound_toggled, is_vampire_toggled, is_rage_spike_toggled, is_serrated_strikes_toggled, is_tainted_blade_toggled, bleed_plus_tier, deeper_wound_tier, vampire_tier, rage_spike_tier, serrated_strikes_tier, tainted_blade_tier, rage_spike_cooldown, serrated_strikes_cooldown, tainted_blade_cooldown) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)";
                try {
                    this.database.getConnection().createStatement().execute(String.format(string, "'" + uUID.toString() + "'", n2.toString(), n3.toString(), bl.toString(), bl2.toString(), bl3.toString(), bl4.toString(), bl5.toString(), bl6.toString(), bl7.toString(), n4.toString(), n5.toString(), n6.toString(), n7.toString(), n8.toString(), n9.toString(), l.toString(), l2.toString(), l3.toString()));
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                n2 = yamlConfiguration.getInt("Mining.CurrentExp");
                n3 = yamlConfiguration.getInt("Mining.Level");
                Boolean bl8 = yamlConfiguration.getBoolean("Mining.DoubleDrop.IsToggled");
                Boolean bl9 = yamlConfiguration.getBoolean("Mining.RicherOres.IsToggled");
                Boolean bl10 = yamlConfiguration.getBoolean("Mining.RemoteTransfer.IsToggled");
                Boolean bl11 = yamlConfiguration.getBoolean("Mining.ItsATriple.IsToggled");
                Boolean bl12 = yamlConfiguration.getBoolean("Mining.SuperBreaker.IsToggled");
                Boolean bl13 = yamlConfiguration.getBoolean("Mining.BlastMining.IsToggled");
                Boolean bl14 = yamlConfiguration.getBoolean("Mining.OreScanner.IsToggled");
                Integer n10 = yamlConfiguration.getInt("Mining.RicherOres.Tier");
                Integer n11 = yamlConfiguration.getInt("Mining.RemoteTransfer.Tier");
                Integer n12 = yamlConfiguration.getInt("Mining.ItsATriple.Tier");
                Integer n13 = yamlConfiguration.getInt("Mining.SuperBreaker.Tier");
                Integer n14 = yamlConfiguration.getInt("Mining.BlastMining.Tier");
                Integer n15 = yamlConfiguration.getInt("Mining.OreScanner.Tier");
                Long l4 = 0L;
                if (yamlConfiguration.contains("Cooldowns.SuperBreaker")) {
                    l4 = yamlConfiguration.getLong("Cooldowns.SuperBreaker");
                }
                Long l5 = 0L;
                if (yamlConfiguration.contains("Cooldowns.BlastMining")) {
                    l5 = yamlConfiguration.getLong("Cooldowns.BlastMining");
                }
                Long l6 = 0L;
                if (yamlConfiguration.contains("Cooldowns.OreScanner")) {
                    l6 = yamlConfiguration.getLong("Cooldowns.OreScanner");
                }
                string = "INSERT INTO mcrpg_mining_data (uuid, current_exp, current_level, is_double_drop_toggled, is_richer_ores_toggled, is_remote_transfer_toggled, is_its_a_triple_toggled, is_super_breaker_toggled, is_blast_mining_toggled, is_ore_scanner_toggled, richer_ores_tier, remote_transfer_tier, its_a_triple_tier, super_breaker_tier, blast_mining_tier, ore_scanner_tier, super_break_cooldown, blast_mining_cooldown, ore_scanner_cooldown) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)";
                try {
                    this.database.getConnection().createStatement().execute(String.format(string, "'" + uUID.toString() + "'", n2.toString(), n3.toString(), bl8.toString(), bl9.toString(), bl10.toString(), bl11.toString(), bl12.toString(), bl13.toString(), bl14.toString(), n10.toString(), n11.toString(), n12.toString(), n13.toString(), n14.toString(), n15.toString(), l4.toString(), l5.toString(), l6.toString()));
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                n2 = yamlConfiguration.getInt("Unarmed.CurrentExp");
                n3 = yamlConfiguration.getInt("Unarmed.Level");
                Boolean bl15 = yamlConfiguration.getBoolean("Unarmed.StickyFingers.IsToggled");
                Boolean bl16 = yamlConfiguration.getBoolean("Unarmed.TighterGrip.IsToggled");
                Boolean bl17 = yamlConfiguration.getBoolean("Unarmed.Disarm.IsToggled");
                Boolean bl18 = yamlConfiguration.getBoolean("Unarmed.IronArm.IsToggled");
                Boolean bl19 = yamlConfiguration.getBoolean("Unarmed.Berserk.IsToggled");
                Boolean bl20 = yamlConfiguration.getBoolean("Unarmed.SmitingFist.IsToggled");
                Boolean bl21 = yamlConfiguration.getBoolean("Unarmed.DenseImpact.IsToggled");
                Integer n16 = yamlConfiguration.getInt("Unarmed.TighterGrip.Tier");
                Integer n17 = yamlConfiguration.getInt("Unarmed.Disarm.Tier");
                Integer n18 = yamlConfiguration.getInt("Unarmed.IronArm.Tier");
                Integer n19 = yamlConfiguration.getInt("Unarmed.Berserk.Tier");
                Integer n20 = yamlConfiguration.getInt("Unarmed.SmitingFist.Tier");
                Integer n21 = yamlConfiguration.getInt("Unarmed.DenseImpact.Tier");
                Long l7 = 0L;
                if (yamlConfiguration.contains("Cooldowns.Berserk")) {
                    l7 = yamlConfiguration.getLong("Cooldowns.Berserk");
                }
                Long l8 = 0L;
                if (yamlConfiguration.contains("Cooldowns.SmitingFist")) {
                    l8 = yamlConfiguration.getLong("Cooldowns.SmitingFist");
                }
                Long l9 = 0L;
                if (yamlConfiguration.contains("Cooldowns.DenseImpact")) {
                    l9 = yamlConfiguration.getLong("Cooldowns.DenseImpact");
                }
                string = "INSERT INTO mcrpg_unarmed_data (uuid, current_exp, current_level, is_sticky_fingers_toggled, is_tighter_grip_toggled, is_disarm_toggled, is_iron_arm_toggled, is_berserk_toggled, is_smiting_fist_toggled, is_dense_impact_toggled, tighter_grip_tier, disarm_tier, iron_arm_tier, berserk_tier, smiting_fist_tier, dense_impact_tier, berserk_cooldown, smiting_fist_cooldown, dense_impact_cooldown) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)";
                try {
                    this.database.getConnection().createStatement().execute(String.format(string, "'" + uUID.toString() + "'", n2.toString(), n3.toString(), bl15.toString(), bl16.toString(), bl17.toString(), bl18.toString(), bl19.toString(), bl20.toString(), bl21.toString(), n16.toString(), n17.toString(), n18.toString(), n19.toString(), n20.toString(), n21.toString(), l7.toString(), l8.toString(), l9.toString()));
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                n2 = yamlConfiguration.getInt("Herbalism.CurrentExp");
                n3 = yamlConfiguration.getInt("Herbalism.Level");
                Boolean bl22 = yamlConfiguration.getBoolean("Herbalism.TooManyPlants.IsToggled");
                Boolean bl23 = yamlConfiguration.getBoolean("Herbalism.FarmersDiet.IsToggled");
                Boolean bl24 = yamlConfiguration.getBoolean("Herbalism.DiamondFlowers.IsToggled");
                Boolean bl25 = yamlConfiguration.getBoolean("Herbalism.Replanting.IsToggled");
                Boolean bl26 = yamlConfiguration.getBoolean("Herbalism.MassHarvest.IsToggled");
                Boolean bl27 = yamlConfiguration.getBoolean("Herbalism.NaturesWrath.IsToggled");
                Boolean bl28 = yamlConfiguration.getBoolean("Herbalism.PansBlessing.IsToggled");
                Integer n22 = yamlConfiguration.getInt("Herbalism.FarmersDiet.Tier");
                Integer n23 = yamlConfiguration.getInt("Herbalism.DiamondFlowers.Tier");
                Integer n24 = yamlConfiguration.getInt("Herbalism.Replanting.Tier");
                Integer n25 = yamlConfiguration.getInt("Herbalism.MassHarvest.Tier");
                Integer n26 = yamlConfiguration.getInt("Herbalism.NaturesWrath.Tier");
                Integer n27 = yamlConfiguration.getInt("Herbalism.DenseImpact.Tier");
                Long l10 = 0L;
                if (yamlConfiguration.contains("Cooldowns.MassHarvest")) {
                    l10 = yamlConfiguration.getLong("Cooldowns.MassHarvest");
                }
                Long l11 = 0L;
                if (yamlConfiguration.contains("Cooldowns.NaturesWrath")) {
                    l11 = yamlConfiguration.getLong("Cooldowns.NaturesWrath");
                }
                Long l12 = 0L;
                if (yamlConfiguration.contains("Cooldowns.PansBlessing")) {
                    l12 = yamlConfiguration.getLong("Cooldowns.PansBlessing");
                }
                string = "INSERT INTO mcrpg_herbalism_data (uuid, current_exp, current_level, is_too_many_plants_toggled, is_farmers_diet_toggled, is_diamond_flowers_toggled, is_replanting_toggled, is_mass_harvest_toggled, is_natures_wrath_toggled, is_pans_blessing_toggled, farmers_diet_tier, diamond_flowers_tier, replanting_tier, mass_harvest_tier, natures_wrath_tier, pans_blessing_tier, mass_harvest_cooldown, natures_wrath_cooldown, pans_blessing_cooldown) VALUES (%s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s, %s)";
                try {
                    this.database.getConnection().createStatement().execute(String.format(string, "'" + uUID.toString() + "'", n2.toString(), n3.toString(), bl22.toString(), bl23.toString(), bl24.toString(), bl25.toString(), bl26.toString(), bl27.toString(), bl28.toString(), n22.toString(), n23.toString(), n24.toString(), n25.toString(), n26.toString(), n27.toString(), l10.toString(), l11.toString(), l12.toString()));
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
                builder = new ImmutableMap.Builder();
                builder.put((Object)"uuid", (Object)uUID.toString());
                builder.put((Object)"current_exp", (Object)Integer.toString(yamlConfiguration.getInt("Archery.CurrentExp")));
                builder.put((Object)"current_level", (Object)Integer.toString(yamlConfiguration.getInt("Archery.Level")));
                builder.put((Object)"is_daze_toggled", (Object)Boolean.toString(yamlConfiguration.getBoolean("Archery.Daze.IsToggled")));
                builder.put((Object)"is_puncture_toggled", (Object)Boolean.toString(yamlConfiguration.getBoolean("Archery.Puncture.IsToggled")));
                builder.put((Object)"is_tipped_arrows_toggled", (Object)Boolean.toString(yamlConfiguration.getBoolean("Archery.TippedArrows.IsToggled")));
                builder.put((Object)"is_blessing_of_artemis_toggled", (Object)Boolean.toString(yamlConfiguration.getBoolean("Archery.BlessingOfArtemis.IsToggled")));
                builder.put((Object)"is_blessing_of_apollo_toggled", (Object)Boolean.toString(yamlConfiguration.getBoolean("Archery.BlessingOfApollo.IsToggled")));
                builder.put((Object)"is_curse_of_hades_toggled", (Object)Boolean.toString(yamlConfiguration.getBoolean("Archery.CurseOfHades.IsToggled")));
                builder.put((Object)"puncture_tier", (Object)Integer.toString(yamlConfiguration.getInt("Archery.Puncture.Tier")));
                builder.put((Object)"tipped_arrows_tier", (Object)Integer.toString(yamlConfiguration.getInt("Archery.TippedArrows.Tier")));
                builder.put((Object)"combo_tier", (Object)Integer.toString(yamlConfiguration.getInt("Archery.Combo.Tier")));
                builder.put((Object)"blessing_of_artemis_tier", (Object)Integer.toString(yamlConfiguration.getInt("Archery.BlessingOfArtemis.Tier")));
                builder.put((Object)"blessing_of_apollo_tier", (Object)Integer.toString(yamlConfiguration.getInt("Archery.BlessingOfApollo.Tier")));
                builder.put((Object)"curse_of_hades_tier", (Object)Integer.toString(yamlConfiguration.getInt("Archery.CurseOfHades.Tier")));
                Long l13 = yamlConfiguration.contains("Cooldowns.BlessingOfArtemis") ? yamlConfiguration.getLong("Cooldowns.BlessingOfArtemis") : 0L;
                Long l14 = yamlConfiguration.contains("Cooldowns.BlessingOfApollo") ? yamlConfiguration.getLong("Cooldowns.BlessingOfApollo") : 0L;
                Long l15 = yamlConfiguration.contains("Cooldowns.CurseOfHades") ? yamlConfiguration.getLong("Cooldowns.CurseOfHades") : 0L;
                builder.put((Object)"blessing_of_artemis_cooldown", (Object)Long.toString(l13));
                builder.put((Object)"blessing_of_apollo_cooldown", (Object)Long.toString(l14));
                builder.put((Object)"curse_of_hades_cooldown", (Object)Long.toString(l15));
                legacyDataConverter.convert("mcrpg_archery_data", (Map<String, String>)builder.build());
                file2.delete();
                ++n;
            }
        }
        long l = Duration.between(instant, Instant.now()).getSeconds();
        file.delete();
        Bukkit.getConsoleSender().sendMessage(Methods.color(McRPG.getInstance().getPluginPrefix() + McRPG.getInstance().getLangFile().getString("Messages.Commands.Utility.ConversionComplete").replace("%Amount%", Integer.toString(n)).replace("%Seconds%", Long.toString(l))));
    }

    public Database getDatabase() {
        return this.database;
    }

    private class LegacyDataConverter {
        private Function<String, String> prepareValuesFunc = string -> {
            if (string.equals("true") || string.equals("false")) {
                return Boolean.getBoolean(string) ? "1" : "0";
            }
            if (FastStrings.isNumeric((CharSequence)string)) {
                return string;
            }
            return "'" + string + "'";
        };

        private String buildSql(String string, Map<String, String> map) {
            Set<String> set = map.keySet();
            String string2 = FastStrings.join((Object[])set.toArray(), (CharSequence)", ");
            String string3 = FastStrings.join((Object[])map.values().stream().map(this.prepareValuesFunc).toArray(), (CharSequence)", ");
            return String.format("INSERT INTO %s (%s) VALUES (%s)", string, string2, string3);
        }

        public void convert(String string, Map<String, String> map) {
            String string2 = this.buildSql(string, map);
            McRPGDb.this.database.executeUpdate(string2, new String[0]);
        }
    }
}

