/*
 * Decompiled with CFR 0.152.
 */
package us.eunoians.mcrpg.commands.prompts;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import us.eunoians.mcrpg.McRPG;
import us.eunoians.mcrpg.api.exceptions.McRPGPlayerNotFoundException;
import us.eunoians.mcrpg.api.util.FileManager;
import us.eunoians.mcrpg.party.Party;
import us.eunoians.mcrpg.party.PartyMember;
import us.eunoians.mcrpg.players.McRPGPlayer;
import us.eunoians.mcrpg.players.PlayerManager;
import us.eunoians.mcrpg.types.PartyPermissions;
import us.eunoians.mcrpg.types.PartyRoles;

public class McPartyPrompt
implements TabCompleter {
    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        boolean bl;
        McRPGPlayer mcRPGPlayer;
        if (!McRPG.getInstance().getFileManager().getFile(FileManager.Files.PARTY_CONFIG).getBoolean("PartiesEnabled", false)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Player player = (Player)commandSender;
        try {
            mcRPGPlayer = PlayerManager.getPlayer(player.getUniqueId());
        }
        catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {
            mcRPGPlayer = new McRPGPlayer(player.getUniqueId());
        }
        Party party = mcRPGPlayer.getPartyID() != null ? McRPG.getInstance().getPartyManager().getParty(mcRPGPlayer.getPartyID()) : null;
        PartyMember partyMember = party != null ? party.getPartyMember(player.getUniqueId()) : null;
        boolean bl2 = bl = party != null;
        if (stringArray.length == 1) {
            arrayList.add("invites");
            if (bl) {
                arrayList.add("leave");
                arrayList.add("tpa");
                arrayList.add("tpahere");
                arrayList.add("tpaccept");
                arrayList.add("chat");
                PartyRoles partyRoles = partyMember.getPartyRole();
                if (partyRoles.getId() <= party.getRoleForPermission(PartyPermissions.INVITE_PLAYERS).getId()) {
                    arrayList.add("invite");
                }
                if (partyRoles.getId() <= party.getRoleForPermission(PartyPermissions.KICK_PLAYERS).getId()) {
                    arrayList.add("kick");
                }
                if (partyRoles.getId() <= party.getRoleForPermission(PartyPermissions.PRIVATE_BANK).getId()) {
                    arrayList.add("storage");
                }
                if (partyRoles == PartyRoles.OWNER) {
                    arrayList.add("disband");
                    arrayList.add("promote");
                    arrayList.add("demote");
                    arrayList.add("setowner");
                    arrayList.add("roles");
                    arrayList.add("rename");
                }
            } else {
                arrayList.add("create");
            }
            return (List)StringUtil.copyPartialMatches((String)stringArray[0], arrayList, new ArrayList());
        }
        if (stringArray.length == 2) {
            if (bl) {
                if (partyMember.getPartyRole() == PartyRoles.OWNER) {
                    switch (stringArray[0].toLowerCase()) {
                        case "promote": {
                            for (PartyMember object : party.getAllMembers()) {
                                if (object.getPartyRole() != PartyRoles.MEMBER) continue;
                                arrayList.add(Bukkit.getOfflinePlayer((UUID)object.getUuid()).getName());
                            }
                            break;
                        }
                        case "demote": {
                            for (PartyMember partyMember2 : party.getAllMembers()) {
                                if (partyMember2.getPartyRole() != PartyRoles.MOD) continue;
                                arrayList.add(Bukkit.getOfflinePlayer((UUID)partyMember2.getUuid()).getName());
                            }
                            break;
                        }
                        case "setowner": {
                            for (PartyMember partyMember3 : party.getAllMembers()) {
                                if (partyMember3.getUuid().equals(player.getUniqueId())) continue;
                                arrayList.add(Bukkit.getOfflinePlayer((UUID)partyMember3.getUuid()).getName());
                            }
                            break;
                        }
                    }
                }
                if (partyMember.getPartyRole().getId() <= party.getRoleForPermission(PartyPermissions.KICK_PLAYERS).getId()) {
                    switch (stringArray[0].toLowerCase()) {
                        case "kick": {
                            for (UUID uUID : party.getAllMemberUUIDs()) {
                                if (uUID.equals(player.getUniqueId())) continue;
                                arrayList.add(Bukkit.getOfflinePlayer((UUID)uUID).getName());
                            }
                            break;
                        }
                    }
                }
                if (partyMember.getPartyRole().getId() <= party.getRoleForPermission(PartyPermissions.INVITE_PLAYERS).getId()) {
                    switch (stringArray[0].toLowerCase()) {
                        case "invite": {
                            for (Player player2 : Bukkit.getOnlinePlayers()) {
                                if (party.isPlayerInParty(player2.getUniqueId())) continue;
                                try {
                                    McRPGPlayer mcRPGPlayer2 = PlayerManager.getPlayer(player2.getUniqueId());
                                    if (mcRPGPlayer2.getPartyID() != null) continue;
                                    arrayList.add(player2.getName());
                                }
                                catch (McRPGPlayerNotFoundException mcRPGPlayerNotFoundException) {}
                            }
                            break;
                        }
                    }
                }
                if (stringArray[0].equalsIgnoreCase("tpa") || stringArray[0].equalsIgnoreCase("tpahere")) {
                    for (UUID uUID : party.getAllMemberUUIDs()) {
                        if (uUID.equals(player.getUniqueId())) continue;
                        arrayList.add(Bukkit.getOfflinePlayer((UUID)uUID).getName());
                    }
                }
            }
            return (List)StringUtil.copyPartialMatches((String)stringArray[1], arrayList, new ArrayList());
        }
        return null;
    }
}

